/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeInstanceTopologyRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeInstanceTopologyRequestMarshaller
implements Marshaller<Request<DescribeInstanceTopologyRequest>, DescribeInstanceTopologyRequest> {
    @Override
    public Request<DescribeInstanceTopologyRequest> marshall(DescribeInstanceTopologyRequest describeInstanceTopologyRequest) {
        SdkInternalList describeInstanceTopologyRequestFiltersList;
        SdkInternalList describeInstanceTopologyRequestGroupNamesList;
        SdkInternalList describeInstanceTopologyRequestInstanceIdsList;
        if (describeInstanceTopologyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceTopologyRequest> request = new DefaultRequest<DescribeInstanceTopologyRequest>(describeInstanceTopologyRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceTopology");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceTopologyRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceTopologyRequest.getNextToken()));
        }
        if (describeInstanceTopologyRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceTopologyRequest.getMaxResults()));
        }
        if (!(describeInstanceTopologyRequestInstanceIdsList = (SdkInternalList)describeInstanceTopologyRequest.getInstanceIds()).isEmpty() || !describeInstanceTopologyRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (Object describeInstanceTopologyRequestInstanceIdsListValue : describeInstanceTopologyRequestInstanceIdsList) {
                if (describeInstanceTopologyRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeInstanceTopologyRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (!(describeInstanceTopologyRequestGroupNamesList = (SdkInternalList)describeInstanceTopologyRequest.getGroupNames()).isEmpty() || !describeInstanceTopologyRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describeInstanceTopologyRequestGroupNamesListValue : describeInstanceTopologyRequestGroupNamesList) {
                if (describeInstanceTopologyRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString(describeInstanceTopologyRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (!(describeInstanceTopologyRequestFiltersList = (SdkInternalList)describeInstanceTopologyRequest.getFilters()).isEmpty() || !describeInstanceTopologyRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceTopologyRequestFiltersListValue : describeInstanceTopologyRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceTopologyRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeInstanceTopologyRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceTopologyRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

