/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyInstanceAttributeRequestMarshaller
implements Marshaller<Request<ModifyInstanceAttributeRequest>, ModifyInstanceAttributeRequest> {
    @Override
    public Request<ModifyInstanceAttributeRequest> marshall(ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {
        SdkInternalList modifyInstanceAttributeRequestGroupsList;
        SdkInternalList modifyInstanceAttributeRequestBlockDeviceMappingsList;
        if (modifyInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyInstanceAttributeRequest> request = new DefaultRequest<ModifyInstanceAttributeRequest>(modifyInstanceAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceAttributeRequest.getSourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.getSourceDestCheck()));
        }
        if (modifyInstanceAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyInstanceAttributeRequest.getAttribute()));
        }
        if (!(modifyInstanceAttributeRequestBlockDeviceMappingsList = (SdkInternalList)modifyInstanceAttributeRequest.getBlockDeviceMappings()).isEmpty() || !modifyInstanceAttributeRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (InstanceBlockDeviceMappingSpecification modifyInstanceAttributeRequestBlockDeviceMappingsListValue : modifyInstanceAttributeRequestBlockDeviceMappingsList) {
                EbsInstanceBlockDeviceSpecification ebs;
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getDeviceName()));
                }
                if ((ebs = modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getEbs()) != null) {
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getVolumeId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeId", StringUtils.fromString(ebs.getVolumeId()));
                    }
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getNoDevice()));
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(modifyInstanceAttributeRequestBlockDeviceMappingsListValue.getVirtualName()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.getDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.getDisableApiTermination()));
        }
        if (modifyInstanceAttributeRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.getEbsOptimized()));
        }
        if (modifyInstanceAttributeRequest.getEnaSupport() != null) {
            request.addParameter("EnaSupport.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.getEnaSupport()));
        }
        if (!(modifyInstanceAttributeRequestGroupsList = (SdkInternalList)modifyInstanceAttributeRequest.getGroups()).isEmpty() || !modifyInstanceAttributeRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String modifyInstanceAttributeRequestGroupsListValue : modifyInstanceAttributeRequestGroupsList) {
                if (modifyInstanceAttributeRequestGroupsListValue != null) {
                    request.addParameter("GroupId." + groupsListIndex, StringUtils.fromString(modifyInstanceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(modifyInstanceAttributeRequest.getInstanceId()));
        }
        if (modifyInstanceAttributeRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if (modifyInstanceAttributeRequest.getInstanceType() != null) {
            request.addParameter("InstanceType.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getInstanceType()));
        }
        if (modifyInstanceAttributeRequest.getKernel() != null) {
            request.addParameter("Kernel.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getKernel()));
        }
        if (modifyInstanceAttributeRequest.getRamdisk() != null) {
            request.addParameter("Ramdisk.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getRamdisk()));
        }
        if (modifyInstanceAttributeRequest.getSriovNetSupport() != null) {
            request.addParameter("SriovNetSupport.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getSriovNetSupport()));
        }
        if (modifyInstanceAttributeRequest.getUserData() != null) {
            request.addParameter("UserData.Value", StringUtils.fromString(modifyInstanceAttributeRequest.getUserData()));
        }
        if (modifyInstanceAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyInstanceAttributeRequest.getValue()));
        }
        if (modifyInstanceAttributeRequest.getDisableApiStop() != null) {
            request.addParameter("DisableApiStop.Value", StringUtils.fromBoolean(modifyInstanceAttributeRequest.getDisableApiStop()));
        }
        return request;
    }
}

