/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import java.math.BigDecimal;

public class DefaultViewVector
implements ColumnVector {
    private final ColumnVector underlyingVector;
    private final int offset;
    private final int size;

    public DefaultViewVector(ColumnVector columnVector, int n, int n2) {
        this.underlyingVector = columnVector;
        this.offset = n;
        this.size = n2 - n;
    }

    public DataType getDataType() {
        return this.underlyingVector.getDataType();
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
    }

    public boolean isNullAt(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.isNullAt(this.offset + n);
    }

    public boolean getBoolean(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getBoolean(this.offset + n);
    }

    public byte getByte(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getByte(this.offset + n);
    }

    public short getShort(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getShort(this.offset + n);
    }

    public int getInt(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getInt(this.offset + n);
    }

    public long getLong(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getLong(this.offset + n);
    }

    public float getFloat(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getFloat(this.offset + n);
    }

    public double getDouble(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getDouble(this.offset + n);
    }

    public byte[] getBinary(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getBinary(this.offset + n);
    }

    public String getString(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getString(this.offset + n);
    }

    public BigDecimal getDecimal(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getDecimal(this.offset + n);
    }

    public MapValue getMap(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getMap(this.offset + n);
    }

    public ArrayValue getArray(int n) {
        this.checkValidRowId(n);
        return this.underlyingVector.getArray(this.offset + n);
    }

    public ColumnVector getChild(int n) {
        return new DefaultViewVector(this.underlyingVector.getChild(n), this.offset, this.offset + this.size);
    }

    private void checkValidRowId(int n) {
        Preconditions.checkArgument((n >= 0 && n < this.size ? 1 : 0) != 0, (String)"Invalid rowId=%s for size=%s", (Object[])new Object[]{n, this.size});
    }
}

