(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    app.controller('GeometryMapColorController', function($scope) {
        $scope.geoLayers = [];

        $scope.onGeoLayerChange = function(index) {
            $scope.index = index;
            $scope.geoLayer = $scope.chart.def.geoLayers[index];
        };

        $scope.hasColor = function() {
            return $scope.geoLayer.uaColor.length;
        };

        $scope.$watch('chart.def.geoLayers', function(newValue) {
            //if a geolayer was selected already, we need to map it to the correct index (in case of reorder)
            if (!_.isNil($scope.geoLayer)) {
                const selectedGeoIndex = newValue.findIndex(layer => _.isEqual(layer, $scope.geoLayer));
                if (selectedGeoIndex >= 0) {
                    $scope.index = selectedGeoIndex;
                }
            } else {
                const displayedLayerIndex = newValue.findIndex(geoLayer => geoLayer.geometry && geoLayer.geometry.length);
                if (displayedLayerIndex >= 0) {
                    $scope.geoLayer = newValue[displayedLayerIndex];
                    $scope.index = displayedLayerIndex;
                }
            }

            const geoLayers = [];
            newValue.forEach((layer, index) => {
                if (layer.geometry && layer.geometry.length) {
                    let name = layer.geometry[0].column;
                    if (layer.uaColor && layer.uaColor.length) {
                        name += ` / ${layer.uaColor[0].column}`;
                    }
                    geoLayers.push({ id: index, name });
                }
            });
            $scope.geoLayers = geoLayers;
            $scope.hasGeoLayers = newValue && newValue.some(geoLayer => geoLayer.geometry && geoLayer.geometry.length);
        }, true);
    });
})();
