# encoding: utf-8
"""
Executor for containerized execution of python standalone evaluation recipe.
"""

import logging, json

from dataiku.base.folder_context import build_folder_context
from dataiku.base.utils import ErrorMonitoringWrapper
from dataiku.container.runner import setup_log
from dataiku.container.runner import read_execution


if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']

    with ErrorMonitoringWrapper():
        payload = json.loads(execution['payload'])
        execution_dir_folder_context = build_folder_context(execution["executionPath"])
        evaluation_store_folder_path_in_datadir = payload.get('evaluationStoreFolder', '')

        logging.info("Running standalone evaluation recipe main")
        if execution['type'] == 'RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON':
            from dataiku.doctor.evaluation.reg_standalone_evaluation_recipe import StandaloneEvaluateRecipe
            reference_dataset_schema = execution_dir_folder_context.read_json('reference_dataset_schema.json') if payload.get('referenceDatasetSmartName') else None
            runner = StandaloneEvaluateRecipe(payload['inputDatasetSmartName'],
                                              payload.get('managedFolderSmartId'),
                                              payload.get('referenceManagedFolderSmartId'),
                                              execution_dir_folder_context.read_json('desc.json'),
                                              execution_dir_folder_context.read_json('preparation_output_schema.json'),
                                              evaluation_store_folder_path_in_datadir,
                                              payload.get('referenceDatasetSmartName'),
                                              reference_dataset_schema,
                                              execution["executionPath"])
            runner.compute()
        else:
            raise Exception("Unsupported standalone eval recipe type: %s" % execution['type'])
