from dataiku.eda.types import Literal

import pandas as pd

from dataiku.eda.computations.computation import MultivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.types import FetchCSVModel, FetchCSVResultModel


class FetchCSV(MultivariateComputation):
    @staticmethod
    def get_type() -> Literal["fetch_csv"]:
        return "fetch_csv"

    def describe(self) -> str:
        return "FetchCSV(%s)" % ','.join(self.columns)

    @staticmethod
    def build(params: FetchCSVModel) -> 'FetchCSV':
        return FetchCSV(params['columns'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> FetchCSVResultModel:
        df_data = {}
        for column in self.columns:
            df_data[column] = idf.raw_col(column)

        df = pd.DataFrame(df_data, columns=self.columns)
        data_stream_id = ctx.df_store.register_dataframe(df)

        return {
            "type": FetchCSV.get_type(),
            "dataStreamId": data_stream_id.serialize(),
        }
