package __CLASSPACKAGE__;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig.Container;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.exposition.*;
import com.dataiku.dip.exposition.Exposables.*;
import com.dataiku.dip.exposition.ExposedEndpointConsumer.*;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.DKUtils.*;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;

public class __CLASSNAME__ {
    // a prefix to log lines from this class, to distinguish them in the overall log of the webapp or api deployment
    private final static String LOG_PREFIX = "[fy] ";
    
    public static class __CLASSNAME__Params implements ExpositionParams {
        // fields in this class are defined in 'params' in the exposition.json
        public String someString;
    }

    public static class __CLASSNAME__Meta implements ExpositionMeta {
        @Override
        public String getType() {
            throw new Error("unreachable");
        }

        @Override
        public ExpositionDesc getDesc(ExpositionUsageContext  usageContext) {
            throw new Error("unreachable");
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return __CLASSNAME__Params.class;
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 2 * 60 * 1000; // a typical upper bound on the time it takes for this exposition to be up and running
        }

        /** filtering whether this exposition applies to a particular container runtime configuration */
        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == Container.KUBERNETES;
        }

        /** filtering whether this exposition applies to container types (may be further filtered by container runtime configuration) */
        @Override
        public boolean handles(Container containerType) {
            return containerType == Container.KUBERNETES;
        }

        /** filtering whether this exposition is suitable for a particular DSS object type */
        @Override
        public boolean handles(ExposableKind kind) {
            return kind == ExposableKind.WEBAPP || kind == ExposableKind.API_DEPLOYER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            __CLASSNAME__Params params = exposition.getParamsAs(__CLASSNAME__Params.class);
            return new __CLASSNAME__Handler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }
    };

    private static class __CLASSNAME__Handler implements ExpositionHandler {
        private final __CLASSNAME__Params params;
        private final ContainerExecRuntimeConfig containerConfig;
        private final ExposedEndpointConsumer endpointConsumer; // callback to publish endpoints to

        private IStateLabelAggregator stateLabelAggregator; // for building states shown in the UI while the exposition starts
        
        // values collected from the exposable
        private AuthCtx authCtx;
        private String projectKey;
        private File tmpDir;
        private int exposedPort;
        private List<String> selectors;
        private List<String> labels;
        private List<String> annotations;
        private String executionId;

        // info on the yaml file of the service we create
        private List<String> serviceFiles; // the kubectl command-line arguments to point to the service
        private String serviceName; // the service name (used to query for its status)

        private ExpositionStatus status = new ExpositionStatus();
        private boolean closed;

        __CLASSNAME__Handler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, __CLASSNAME__Params params, ExposedEndpointConsumer endpointConsumer) {
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.containerConfig = containerConfig;
            this.endpointConsumer = endpointConsumer;
            this.params = params;
        }

        /**
         * remove anything created by this exposition
         */
        @Override
        public void cleanup() {
            closed = true;
            if (serviceFiles != null) {
                logger.warn("Remove service");
                try {
                    KubernetesExecUtils.delete(authCtx, projectKey, containerConfig, true, serviceFiles.toArray(new String[0]));
                } catch (IOException e) {
                    logger.error("Could not stop Kubernetes service", e);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Interrupted while stopping Kubernetes service", e);
                }
            }
        }

        /**
         * init() shouldn't start the exposition, only collect and prepare values. init() is called before start() and before getStatus()
         */
        @Override
        public void init(Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            this.stateLabelAggregator = stateLabelAggregator;
            KubernetesExposable kubernetesExposable = (KubernetesExposable) exposable;
            this.executionId = kubernetesExposable.getExecutionId(); // an identifier of the exposed object
            this.tmpDir = kubernetesExposable.getTmpDir(); // a folder where to store files for the exposition
            this.exposedPort = kubernetesExposable.getContainerizedPort(); // port in the container that we which to expose
            this.annotations = kubernetesExposable.getAnnotations(); // annotations of the DSS object
            this.labels = kubernetesExposable.getLabels(); // labels set on the deployment we expose
            this.selectors = kubernetesExposable.getSelectors(); // selectors for the pods
            // also available on a KubernetesExposable:
            // kubernetesExposable.getNamePrefix() = a prefix to build the services names with; depends on the type of DSS object exposed
            // kubernetesExposable.getProperties() = key-value pairs defined on the DSS object
            
            // build an unique service name
            this.serviceName = "svc-" + executionId;
            
            logger.info("Add yaml service");
            // we make a simple LoadBalancer service, starting from the base.yaml template
            File serviceFile = new File(tmpDir, "service_" + executionId + ".yaml");
            String base = IOUtils.toString(getClass().getClassLoader().getResourceAsStream("__CLASSPACKAGE__".replace(".", "/") + "/base.yaml"));
            String serviceDesc = base.replace("__SERVICE_NAME__", serviceName)
                                     .replace("__EXPOSED_PORT__", Integer.toString(exposedPort))
                                     .replace("__LABELS__", labels.stream().map(s -> "    " + s.trim()).collect(Collectors.joining("\n")))
                                     .replace("__ANNOTATIONS__", annotations.stream().map(s -> "    " + s.trim()).collect(Collectors.joining("\n")))
                                     .replace("__SELECTORS__", selectors.stream().map(s -> "    " + s.trim()).collect(Collectors.joining("\n")))
                                     .replace("__SOME_STRING__", StringUtils.defaultIfBlank(params.someString, "__was empty__"));
            logger.debug("Write service to " + serviceFile.getAbsolutePath() + " :\n" + serviceDesc);
            DKUFileUtils.writeFileUTF8(serviceFile, serviceDesc);
            serviceFiles = Lists.newArrayList("-f", serviceFile.getAbsolutePath());
        }

        /**
         * start the exposition
         */
        @Override
        public void start(LineSubscriptionAttacher mainLog, SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            // start the service
            String[] cmd = KubernetesExecUtils.getKubeCtlApplyCommand(authCtx, projectKey, containerConfig, serviceFiles.toArray(new String[0]));
            mainLog.handle("Running yaml " + Joiner.on(" ").join(cmd), false);

            smartLogTailBuilder.appendLine("Deploying plugin exposition");

            new DKUtils.ExecBuilder()
            .withCwd(tmpDir)
            .withEnv(KubernetesExecUtils.getKubeCtlEnv(containerConfig))
            .withArgs(cmd)
            .withErrorConsumer(new TailerLineSubscription(smartLogTailBuilder))
            .withOutputConsumer(new TailerLineSubscription(smartLogTailBuilder))
            .withOutputConsumer(mainLog.getSubSubscription(LOG_PREFIX))
            .withErrorConsumer(mainLog.getSubSubscription(LOG_PREFIX))
            .withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList(cmd)).withLogTailBuilder(smartLogTailBuilder))
            .exec();
        }

        /**
         * called after start(), waits for at least 1 endpoint of this exposition to become available
         */
        @Override
        public void waitReady(LineSubscriptionAttacher mainLog, SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            // wait for the service to have its IP
            Closeable ipState = stateLabelAggregator.startWaitingOn("Waiting on exposed service");
            while (true) {
                Thread.sleep(10000);

                // there is also AbstractKubernetesExpositionHandler.describeIngress() when the actual user-facing object is an ingress
                JsonObject obj = AbstractKubernetesExpositionHandler.describeService(authCtx, projectKey, mainLog, smartLogTailBuilder, containerConfig, tmpDir, serviceName, LOG_PREFIX);

                status.raw = obj;

                String host = AbstractKubernetesExpositionHandler.getIngressHost(obj);
                if (host != null) {
                    ipState.close();
                    ExposedEndpoint endpoint = new ExposedEndpoint("__ID__", null, "", host, 15000, null, ExposedEndpointAvailability.PUBLIC);
                    endpointConsumer.registerPort(endpoint);
                    status.endpoints.add(endpoint);
                    break;
                }
            }
            status.isHealthy = true;
        }

        /**
         * fetch the status of the exposition, consisting mostly of the endpoints you can contact the service on
         */
        @Override
        public ExpositionStatus getStatus(LineSubscriptionAttacher mainLog, SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            ExpositionStatus status = new ExpositionStatus();
            if (!closed) {
                // there is also AbstractKubernetesExpositionHandler.describeIngress() when the actual user-facing object is an ingress
                JsonObject obj = AbstractKubernetesExpositionHandler.describeService(authCtx, projectKey, mainLog, smartLogTailBuilder, containerConfig, tmpDir, serviceName, LOG_PREFIX);

                status.raw = obj;
                
                String host = AbstractKubernetesExpositionHandler.getIngressHost(obj);
                if (host != null) {
                    ExposedEndpoint endpoint = new ExposedEndpoint("__ID__", null, "", host, 15000, null, ExposedEndpointAvailability.PUBLIC);
                    status.endpoints.add(endpoint);
                    status.isHealthy = true;
                }
            }
            return status;
        }
    }

    private static Logger logger = Logger.getLogger("dip.webapp.expose.plugin");
}

