# coding: utf-8
"""
Executor for containerized execution of the mlflow interactive model server.
"""

import logging
from dataiku.base.socket_block_link import parse_javalink_args
from dataiku.core import debugging
from dataiku.container.runner import read_execution
from dataiku.external_ml.mlflow.interactive_model_server import serve
import sys

if __name__ == "__main__":
    logging.basicConfig(level=logging.INFO,
                        format='[%(asctime)s] [%(process)s/%(threadName)s] [%(levelname)s] [%(name)s] %(message)s')
    debugging.install_handler()

    execution = read_execution()
    port, secret, server_cert = parse_javalink_args()
    serve(port, secret, server_cert=server_cert)
