from dataiku.llm.python.custom.base_model import BaseModel
from dataiku.llm.python.processing import _NotImplementedError
from dataiku.llm.python.types import EmbeddingQuery, EmbeddingSettings, EmbeddingResponse
from dataiku.llm.tracing import SpanBuilder

class BaseEmbeddingModel(BaseModel):
    """The base interface for an embedding model"""

    def process(self, query: EmbeddingQuery, settings: EmbeddingSettings, trace: SpanBuilder) -> EmbeddingResponse:
        raise _NotImplementedError

    async def aprocess(self, query: EmbeddingQuery, settings: EmbeddingSettings, trace: SpanBuilder) -> EmbeddingResponse:
        raise _NotImplementedError
