/*
 * Decompiled with CFR 0.152.
 */
package io.delta.tables;

import io.delta.tables.DeltaColumnBuilder;
import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTableBuilder;
import io.delta.tables.execution.CreateTableOptions;
import io.delta.tables.execution.DeltaConvert$;
import io.delta.tables.execution.ReplaceTableOptions;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.catalog.DeltaTableV2$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class DeltaTable$
implements scala.Serializable {
    public static DeltaTable$ MODULE$;

    static {
        new DeltaTable$();
    }

    public DeltaTable convertToDelta(SparkSession spark, String identifier, StructType partitionSchema) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)new Some((Object)partitionSchema), (Option<String>)None$.MODULE$);
    }

    public DeltaTable convertToDelta(SparkSession spark, String identifier, String partitionSchema) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema)), (Option<String>)None$.MODULE$);
    }

    public DeltaTable convertToDelta(SparkSession spark, String identifier) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public DeltaTable forPath(String path) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.forPath(sparkSession, path);
    }

    public DeltaTable forPath(SparkSession sparkSession, String path) {
        return this.forPath(sparkSession, path, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public DeltaTable forPath(SparkSession sparkSession, String path, Map<String, String> hadoopConf) {
        scala.collection.immutable.Map badOptions = hadoopConf.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DeltaTable$.$anonfun$forPath$2(k))).toMap(Predef$.MODULE$.$conforms());
        if (!badOptions.isEmpty()) {
            throw DeltaErrors$.MODULE$.unsupportedDeltaTableForPathHadoopConf((scala.collection.immutable.Map<String, String>)badOptions);
        }
        Path hdpPath = new Path(path);
        scala.collection.immutable.Map fileSystemOptions = hadoopConf.toMap(Predef$.MODULE$.$conforms());
        if (DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, hdpPath, (scala.collection.immutable.Map<String, String>)fileSystemOptions)) {
            SparkSession x$1 = sparkSession;
            Path x$2 = hdpPath;
            scala.collection.immutable.Map x$3 = fileSystemOptions;
            Option<CatalogTable> x$4 = DeltaTableV2$.MODULE$.apply$default$3();
            Option<String> x$5 = DeltaTableV2$.MODULE$.apply$default$4();
            Option<DeltaTimeTravelSpec> x$6 = DeltaTableV2$.MODULE$.apply$default$5();
            return new DeltaTable((Dataset<Row>)sparkSession.read().format("delta").options((Map)fileSystemOptions).load(path), new DeltaTableV2(x$1, x$2, x$4, x$5, x$6, (scala.collection.immutable.Map<String, String>)x$3));
        }
        throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier((Option<String>)new Some((Object)path), DeltaTableIdentifier$.MODULE$.apply$default$2()));
    }

    public DeltaTable forPath(SparkSession sparkSession, String path, java.util.Map<String, String> hadoopConf) {
        scala.collection.immutable.Map fsOptions = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(hadoopConf).asScala()).toMap(Predef$.MODULE$.$conforms());
        return this.forPath(sparkSession, path, (Map<String, String>)fsOptions);
    }

    public DeltaTable forName(String tableOrViewName) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.forName(sparkSession, tableOrViewName);
    }

    public DeltaTable forName(SparkSession sparkSession, String tableName) {
        TableIdentifier tableId = sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        if (DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, tableId)) {
            CatalogTable tbl = sparkSession.sessionState().catalog().getTableMetadata(tableId);
            return new DeltaTable((Dataset<Row>)sparkSession.table(tableName), new DeltaTableV2(sparkSession, new Path(tbl.location()), (Option<CatalogTable>)new Some((Object)tbl), (Option<String>)new Some((Object)tableName), DeltaTableV2$.MODULE$.apply$default$5(), DeltaTableV2$.MODULE$.apply$default$6()));
        }
        if (DeltaTableUtils$.MODULE$.isValidPath(tableId)) {
            return this.forPath(sparkSession, tableId.table());
        }
        Some x$1 = new Some((Object)tableId);
        Option<String> x$2 = DeltaTableIdentifier$.MODULE$.apply$default$1();
        throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier(x$2, (Option<TableIdentifier>)x$1));
    }

    public boolean isDeltaTable(SparkSession sparkSession, String identifier) {
        Path identifierPath = new Path(identifier);
        if (BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_STRICT_CHECK_DELTA_TABLE()))) {
            Option<Path> rootOption = DeltaTableUtils$.MODULE$.findDeltaTableRoot(sparkSession, identifierPath, DeltaTableUtils$.MODULE$.findDeltaTableRoot$default$3());
            return rootOption.isDefined() && DeltaLog$.MODULE$.forTable(sparkSession, (Path)rootOption.get()).tableExists();
        }
        return DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, identifierPath, DeltaTableUtils$.MODULE$.isDeltaTable$default$3());
    }

    public boolean isDeltaTable(String identifier) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.isDeltaTable(sparkSession, identifier);
    }

    @Evolving
    public DeltaTableBuilder create() {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.create(sparkSession);
    }

    @Evolving
    public DeltaTableBuilder create(SparkSession spark) {
        return new DeltaTableBuilder(spark, new CreateTableOptions(false));
    }

    @Evolving
    public DeltaTableBuilder createIfNotExists() {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.createIfNotExists(sparkSession);
    }

    @Evolving
    public DeltaTableBuilder createIfNotExists(SparkSession spark) {
        return new DeltaTableBuilder(spark, new CreateTableOptions(true));
    }

    @Evolving
    public DeltaTableBuilder replace() {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.replace(sparkSession);
    }

    @Evolving
    public DeltaTableBuilder replace(SparkSession spark) {
        return new DeltaTableBuilder(spark, new ReplaceTableOptions(false));
    }

    @Evolving
    public DeltaTableBuilder createOrReplace() {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.createOrReplace(sparkSession);
    }

    @Evolving
    public DeltaTableBuilder createOrReplace(SparkSession spark) {
        return new DeltaTableBuilder(spark, new ReplaceTableOptions(true));
    }

    @Evolving
    public DeltaColumnBuilder columnBuilder(String colName) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.activeSparkSessionNotFound();
        });
        return this.columnBuilder(sparkSession, colName);
    }

    @Evolving
    public DeltaColumnBuilder columnBuilder(SparkSession spark, String colName) {
        return new DeltaColumnBuilder(spark, colName);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$forPath$2(String k) {
        return !DeltaTableUtils$.MODULE$.validDeltaTableHadoopPrefixes().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)k.startsWith(x$1)));
    }

    private DeltaTable$() {
        MODULE$ = this;
    }
}

