/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.exceptions.ConcurrentTransactionException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.ConflictCheckerPredicateElimination;
import org.apache.spark.sql.delta.ConflictCheckerPredicateElimination$PredicateElimination$;
import org.apache.spark.sql.delta.CurrentTransactionInfo;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableReadPredicate;
import org.apache.spark.sql.delta.DeltaTableReadPredicate$;
import org.apache.spark.sql.delta.DomainMetadataUtils$;
import org.apache.spark.sql.delta.InCommitTimestampUtils$;
import org.apache.spark.sql.delta.IsolationLevel;
import org.apache.spark.sql.delta.RowId;
import org.apache.spark.sql.delta.RowId$;
import org.apache.spark.sql.delta.RowId$RowTrackingMetadataDomain$;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.Serializable$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotIsolation$;
import org.apache.spark.sql.delta.TableFeature$;
import org.apache.spark.sql.delta.TypeWidening$;
import org.apache.spark.sql.delta.TypeWideningMetadata$;
import org.apache.spark.sql.delta.WinningCommitSummary;
import org.apache.spark.sql.delta.WriteSerializable$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.JobInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.NotebookInfo;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.DeltaSparkPlanUtils;
import org.apache.spark.sql.delta.util.DeltaSparkPlanUtils$SubqueryExpression$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h!B\u0013'\u0001\u0019\u0002\u0004\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005)\")q\u000b\u0001C\u00011\"9a\f\u0001b\u0001\n#y\u0006BB2\u0001A\u0003%\u0001\rC\u0004e\u0001\t\u0007I\u0011C0\t\r\u0015\u0004\u0001\u0015!\u0003a\u0011\u001d1\u0007A1A\u0005\u0012\u001dDaa\u001f\u0001!\u0002\u0013A\u0007b\u0002?\u0001\u0005\u0004%\t\" \u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003\u007f\u0011%\t)\u0001\u0001a\u0001\n#\t9\u0001C\u0005\u0002\n\u0001\u0001\r\u0011\"\u0005\u0002\f!9\u0011q\u0003\u0001!B\u00139\u0005BCA\r\u0001!\u0015\r\u0011\"\u0005\u0002\u001c!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0014\u0001\u0011E\u0011\u0011\u0006\u0005\b\u0003W\u0001A\u0011CA\u0017\u0011\u001d\ty\u0003\u0001C\t\u0003[Aq!!\r\u0001\t#\t\u0019\u0004C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005=\u0005\u0001\"\u0005\u0002.!9\u0011\u0011\u0013\u0001\u0005\u0012\u00055\u0002bBAJ\u0001\u0011E\u0011Q\u0006\u0005\b\u0003+\u0003A\u0011CA\u0017\u0011\u001d\t9\n\u0001C\u0005\u0003[Aq!!'\u0001\t\u0013\ti\u0003C\u0004\u0002\u001c\u0002!I!!\f\t\u000f\u0005u\u0005\u0001\"\u0003\u0002.!9\u0011q\u0014\u0001\u0005\n\u00055\u0002bBAQ\u0001\u0011E\u00111\u0015\u0005\b\u0003_\u0003A\u0011CAY\u0011\u001d\tY\u000e\u0001C\t\u0003[A!\"!8\u0001\u0011\u000b\u0007I\u0011CAp\u0005=\u0019uN\u001c4mS\u000e$8\t[3dW\u0016\u0014(BA\u0014)\u0003\u0015!W\r\u001c;b\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\n\u0005\u0001E:T\b\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\n\u0001\"\\3uKJLgnZ\u0005\u0003ye\u0012A\u0002R3mi\u0006dunZ4j]\u001e\u0004\"AP \u000e\u0003\u0019J!\u0001\u0011\u0014\u0003G\r{gN\u001a7jGR\u001c\u0005.Z2lKJ\u0004&/\u001a3jG\u0006$X-\u00127j[&t\u0017\r^5p]\u000e\u0001\u0001CA\"E\u001b\u0005A\u0013BA#)\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003uIg.\u001b;jC2\u001cUO\u001d:f]R$&/\u00198tC\u000e$\u0018n\u001c8J]\u001a|\u0007C\u0001 I\u0013\tIeE\u0001\fDkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>t\u0017J\u001c4p\u0003]9\u0018N\u001c8j]\u001e\u001cu.\\7ji\u001aKG.Z*uCR,8\u000f\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006\u0011am\u001d\u0006\u0003!2\na\u0001[1e_>\u0004\u0018B\u0001*N\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u000fSN|G.\u0019;j_:dUM^3m!\tqT+\u0003\u0002WM\tq\u0011j]8mCRLwN\u001c'fm\u0016d\u0017A\u0002\u001fj]&$h\bF\u0003Z5ncV\f\u0005\u0002?\u0001!)1&\u0002a\u0001\u0005\")a)\u0002a\u0001\u000f\")!*\u0002a\u0001\u0017\")1+\u0002a\u0001)\u0006!r/\u001b8oS:<7i\\7nSR4VM]:j_:,\u0012\u0001\u0019\t\u0003e\u0005L!AY\u001a\u0003\t1{gnZ\u0001\u0016o&tg.\u001b8h\u0007>lW.\u001b;WKJ\u001c\u0018n\u001c8!\u0003-\u0019H/\u0019:u)&lW-T:\u0002\u0019M$\u0018M\u001d;US6,Wj\u001d\u0011\u0002\u0017QLW.\u001b8h'R\fGo]\u000b\u0002QB!\u0011N\u001c9a\u001b\u0005Q'BA6m\u0003\u001diW\u000f^1cY\u0016T!!\\\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002pU\n9\u0001*Y:i\u001b\u0006\u0004\bCA9y\u001d\t\u0011h\u000f\u0005\u0002tg5\tAO\u0003\u0002v\u0003\u00061AH]8pizJ!a^\u001a\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003oN\nA\u0002^5nS:<7\u000b^1ug\u0002\n\u0001\u0002Z3mi\u0006dunZ\u000b\u0002}B\u0011ah`\u0005\u0004\u0003\u00031#\u0001\u0003#fYR\fGj\\4\u0002\u0013\u0011,G\u000e^1M_\u001e\u0004\u0013AF2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0016\u0003\u001d\u000b!dY;se\u0016tG\u000f\u0016:b]N\f7\r^5p]&sgm\\0%KF$B!!\u0004\u0002\u0014A\u0019!'a\u0004\n\u0007\u0005E1G\u0001\u0003V]&$\b\u0002CA\u000b\u001f\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'A\fdkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>t\u0017J\u001c4pA\u0005!r/\u001b8oS:<7i\\7nSR\u001cV/\\7bef,\"!!\b\u0011\u0007y\ny\"C\u0002\u0002\"\u0019\u0012AcV5o]&twmQ8n[&$8+^7nCJL\u0018AD2iK\u000e\\7i\u001c8gY&\u001cGo\u001d\u000b\u0002\u000f\u0006Q2M]3bi\u0016<\u0016N\u001c8j]\u001e\u001cu.\\7jiN+X.\\1ssR\u0011\u0011QD\u0001\u001bG\",7m\u001b)s_R|7m\u001c7D_6\u0004\u0018\r^5cS2LG/\u001f\u000b\u0003\u0003\u001b\tac\u00195fG.tu.T3uC\u0012\fG/Y+qI\u0006$Xm]\u0001(O\u0016$h)\u001b:ti\u001aKG.Z'bi\u000eD\u0017N\\4QCJ$\u0018\u000e^5p]B\u0013X\rZ5dCR,7\u000f\u0006\u0003\u00026\u0005\u001d\u0003#\u0002\u001a\u00028\u0005m\u0012bAA\u001dg\t1q\n\u001d;j_:\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u00032\u0013aB1di&|gn]\u0005\u0005\u0003\u000b\nyDA\u0004BI\u00124\u0015\u000e\\3\t\u000f\u0005%c\u00031\u0001\u0002L\u0005)a-\u001b7fgB1\u0011QJA,\u0003wqA!a\u0014\u0002T9\u00191/!\u0015\n\u0003QJ1!!\u00164\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0017\u0002\\\t\u00191+Z9\u000b\u0007\u0005U3'A\u0018hKR4\u0015N]:u\r&dW-T1uG\"Lgn\u001a)beRLG/[8o!J,G-[2bi\u0016\u001c\u0018J\u001c;fe:\fG\u000e\u0006\u0005\u00026\u0005\u0005\u0014\u0011QAF\u0011\u001d\t\u0019g\u0006a\u0001\u0003K\nqAZ5mKN$e\r\u0005\u0003\u0002h\u0005md\u0002BA5\u0003srA!a\u001b\u0002x9!\u0011QNA;\u001d\u0011\ty'a\u001d\u000f\u0007M\f\t(C\u00010\u0013\tic&\u0003\u0002,Y%\u0011\u0011FK\u0005\u0004\u0003+B\u0013\u0002BA?\u0003\u007f\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005U\u0003\u0006C\u0004\u0002\u0004^\u0001\r!!\"\u0002KMDw.\u001e7e/&$WM\u001c(p]\u0012+G/\u001a:nS:L7\u000f^5d!J,G-[2bi\u0016\u001c\bc\u0001\u001a\u0002\b&\u0019\u0011\u0011R\u001a\u0003\u000f\t{w\u000e\\3b]\"9\u0011QR\fA\u0002\u0005\u0015\u0015!E:i_VdGmV5eK:\fE\u000e\\+eM\u0006!4\r[3dW\u001a{'/\u00113eK\u00124\u0015\u000e\\3t)\"\fGo\u00155pk2$\u0007*\u0019<f\u0005\u0016,gNU3bI\nK8)\u001e:sK:$H\u000b\u001f8\u0002]\rDWmY6G_J$U\r\\3uK\u00124\u0015\u000e\\3t\u0003\u001e\f\u0017N\\:u\u0007V\u0014(/\u001a8u)bt'+Z1e\r&dWm]\u00012G\",7m\u001b$pe\u0012+G.\u001a;fI\u001aKG.Z:BO\u0006Lgn\u001d;DkJ\u0014XM\u001c;Uq:$U\r\\3uK\u00124\u0015\u000e\\3t\u0003}\u001a\u0007.Z2l\r>\u0014X\u000b\u001d3bi\u0016$\u0017\t\u001d9mS\u000e\fG/[8o)J\fgn]1di&|g.\u00133t)\"\fGoQ;se\u0016tG\u000f\u0016=o\t\u0016\u0004XM\u001c3t\u001f:\fQd\u00195fG.Le\rR8nC&tW*\u001a;bI\u0006$\u0018mQ8oM2L7\r^\u0001\u001bkB$\u0017\r^3UsB,w+\u001b3f]&tw-T3uC\u0012\fG/Y\u0001\u001ae\u0016\f7o]5h]>3XM\u001d7baBLgn\u001a*po&#7/A\rsK\u0006\u001c8/[4o%><8i\\7nSR4VM]:j_:\u001c\u0018!\t:fg>dg/\u001a+j[\u0016\u001cH/Y7q\u001fJ$WM]5oO\u000e{gN\u001a7jGR\u001c\u0018!G4fiB\u0013X\r\u001e;z!\u0006\u0014H/\u001b;j_:lUm]:bO\u0016$2\u0001]AS\u0011\u001d\t9+\ta\u0001\u0003S\u000bq\u0002]1si&$\u0018n\u001c8WC2,Xm\u001d\t\u0006c\u0006-\u0006\u000f]\u0005\u0004\u0003[S(aA'ba\u0006Q!/Z2pe\u0012$\u0016.\\3\u0016\t\u0005M\u00161\u0018\u000b\u0005\u0003k\u000b9\u000e\u0006\u0003\u00028\u00065\u0007\u0003BA]\u0003wc\u0001\u0001B\u0004\u0002>\n\u0012\r!a0\u0003\u0003Q\u000bB!!1\u0002HB\u0019!'a1\n\u0007\u0005\u00157GA\u0004O_RD\u0017N\\4\u0011\u0007I\nI-C\u0002\u0002LN\u00121!\u00118z\u0011!\tyM\tCA\u0002\u0005E\u0017!\u00014\u0011\u000bI\n\u0019.a.\n\u0007\u0005U7G\u0001\u0005=Eft\u0017-\\3?\u0011\u0019\tIN\ta\u0001a\u0006)\u0001\u000f[1tK\u0006QAn\\4NKR\u0014\u0018nY:\u0002\u00131|w\r\u0015:fM&DX#\u00019")
public class ConflictChecker
implements DeltaLogging,
ConflictCheckerPredicateElimination {
    private WinningCommitSummary winningCommitSummary;
    private String logPrefix;
    private final SparkSession spark;
    private final CurrentTransactionInfo initialCurrentTransactionInfo;
    private final FileStatus winningCommitFileStatus;
    private final IsolationLevel isolationLevel;
    private final long winningCommitVersion;
    private final long startTimeMs;
    private final HashMap<String, Object> timingStats;
    private final DeltaLog deltaLog;
    private CurrentTransactionInfo currentTransactionInfo;
    private volatile ConflictCheckerPredicateElimination$PredicateElimination$ PredicateElimination$module;
    private volatile DeltaSparkPlanUtils$SubqueryExpression$ SubqueryExpression$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public ConflictCheckerPredicateElimination.PredicateElimination eliminateNonDeterministicPredicates(Seq<Expression> predicates, DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions) {
        return ConflictCheckerPredicateElimination.eliminateNonDeterministicPredicates$(this, predicates, checkDeterministicOptions);
    }

    @Override
    public boolean planContainsOnlyDeltaScans(LogicalPlan source) {
        return DeltaSparkPlanUtils.planContainsOnlyDeltaScans$(this, source);
    }

    @Override
    public Option<LogicalPlan> findFirstNonDeltaScan(LogicalPlan source) {
        return DeltaSparkPlanUtils.findFirstNonDeltaScan$(this, source);
    }

    @Override
    public boolean planIsDeterministic(LogicalPlan plan, DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions) {
        return DeltaSparkPlanUtils.planIsDeterministic$(this, plan, checkDeterministicOptions);
    }

    @Override
    public Option<Either<LogicalPlan, Expression>> findFirstNonDeterministicNode(LogicalPlan plan, DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions) {
        return DeltaSparkPlanUtils.findFirstNonDeterministicNode$((DeltaSparkPlanUtils)this, plan, checkDeterministicOptions);
    }

    @Override
    public boolean planContainsUdf(LogicalPlan plan) {
        return DeltaSparkPlanUtils.planContainsUdf$(this, plan);
    }

    @Override
    public Option<Either<LogicalPlan, Expression>> findFirstNonDeterministicChildNode(Seq<Expression> children, DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions) {
        return DeltaSparkPlanUtils.findFirstNonDeterministicChildNode$(this, children, checkDeterministicOptions);
    }

    @Override
    public Option<Either<LogicalPlan, Expression>> findFirstNonDeterministicNode(Expression child, DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions) {
        return DeltaSparkPlanUtils.findFirstNonDeterministicNode$((DeltaSparkPlanUtils)this, child, checkDeterministicOptions);
    }

    @Override
    public <In, Out> Option<Out> collectFirst(Iterable<In> input, Function1<In, Option<Out>> recurse) {
        return DeltaSparkPlanUtils.collectFirst$(this, input, recurse);
    }

    @Override
    public boolean containsDeterministicUDF(Seq<DeltaTableReadPredicate> predicates, boolean partitionedOnly) {
        return DeltaSparkPlanUtils.containsDeterministicUDF$(this, predicates, partitionedOnly);
    }

    @Override
    public boolean containsDeterministicUDF(Expression expr) {
        return DeltaSparkPlanUtils.containsDeterministicUDF$(this, expr);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public ConflictCheckerPredicateElimination$PredicateElimination$ PredicateElimination() {
        if (this.PredicateElimination$module == null) {
            this.PredicateElimination$lzycompute$1();
        }
        return this.PredicateElimination$module;
    }

    @Override
    public DeltaSparkPlanUtils$SubqueryExpression$ SubqueryExpression() {
        if (this.SubqueryExpression$module == null) {
            this.SubqueryExpression$lzycompute$1();
        }
        return this.SubqueryExpression$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long winningCommitVersion() {
        return this.winningCommitVersion;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public HashMap<String, Object> timingStats() {
        return this.timingStats;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public CurrentTransactionInfo currentTransactionInfo() {
        return this.currentTransactionInfo;
    }

    public void currentTransactionInfo_$eq(CurrentTransactionInfo x$1) {
        this.currentTransactionInfo = x$1;
    }

    private WinningCommitSummary winningCommitSummary$lzycompute() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.winningCommitSummary = this.createWinningCommitSummary();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.winningCommitSummary;
    }

    public WinningCommitSummary winningCommitSummary() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.winningCommitSummary$lzycompute();
        }
        return this.winningCommitSummary;
    }

    public CurrentTransactionInfo checkConflicts() {
        this.checkProtocolCompatibility();
        this.checkNoMetadataUpdates();
        this.checkIfDomainMetadataConflict();
        this.checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn();
        this.reassignOverlappingRowIds();
        this.reassignRowCommitVersions();
        this.updateTypeWideningMetadata();
        this.checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn();
        this.checkForDeletedFilesAgainstCurrentTxnReadFiles();
        this.checkForDeletedFilesAgainstCurrentTxnDeletedFiles();
        this.resolveTimestampOrderingConflicts();
        this.logMetrics();
        return this.currentTransactionInfo();
    }

    public WinningCommitSummary createWinningCommitSummary() {
        return (WinningCommitSummary)this.recordTime("initialize-old-commit", (Function0 & Serializable & scala.Serializable)() -> {
            Seq winningCommitActions = (Seq)this.deltaLog().store().read($this.winningCommitFileStatus, this.deltaLog().newDeltaHadoopConf()).map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json), Seq$.MODULE$.canBuildFrom());
            return new WinningCommitSummary((Seq<Action>)winningCommitActions, this.winningCommitVersion());
        });
    }

    public void checkProtocolCompatibility() {
        Protocol readProtocol;
        Protocol currentProtocol;
        if (this.winningCommitSummary().protocol().nonEmpty()) {
            Protocol readProtocol2;
            this.winningCommitSummary().protocol().foreach((Function1 & Serializable & scala.Serializable)p -> {
                ConflictChecker.$anonfun$checkProtocolCompatibility$1(this, p);
                return BoxedUnit.UNIT;
            });
            if (this.currentTransactionInfo().actions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkProtocolCompatibility$2(x$4)))) {
                throw DeltaErrors$.MODULE$.protocolChangedException(this.winningCommitSummary().commitInfo());
            }
            Protocol winningProtocol = (Protocol)this.winningCommitSummary().protocol().get();
            boolean isWinnerDroppingFeatures = TableFeature$.MODULE$.isProtocolRemovingExplicitFeatures(winningProtocol, readProtocol2 = this.currentTransactionInfo().readSnapshot().protocol());
            if (isWinnerDroppingFeatures) {
                throw DeltaErrors$.MODULE$.protocolChangedException(this.winningCommitSummary().commitInfo());
            }
        }
        if (TableFeature$.MODULE$.isProtocolRemovingExplicitFeatures(currentProtocol = this.currentTransactionInfo().protocol(), readProtocol = this.currentTransactionInfo().readSnapshot().protocol())) {
            Snapshot winningSnapshot = this.deltaLog().getSnapshotAt(this.winningCommitSummary().commitVersion(), this.deltaLog().getSnapshotAt$default$2());
            boolean isDowngradeCommitValid = TableFeature$.MODULE$.validateFeatureRemovalAtSnapshot(currentProtocol, readProtocol, winningSnapshot);
            if (!isDowngradeCommitValid) {
                throw DeltaErrors$.MODULE$.dropTableFeatureConflictRevalidationFailed(this.winningCommitSummary().commitInfo());
            }
            return;
        }
    }

    public void checkNoMetadataUpdates() {
        if (this.winningCommitSummary().metadataUpdates().nonEmpty()) {
            throw DeltaErrors$.MODULE$.metadataChangedException(this.winningCommitSummary().commitInfo());
        }
    }

    public Option<AddFile> getFirstFileMatchingPartitionPredicates(Seq<AddFile> files) {
        if (BoxesRunTime.unboxToBoolean((Object)this.currentTransactionInfo().commitInfo().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.isBlindAppend()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            Predef$.MODULE$.assert(this.currentTransactionInfo().readPredicates().isEmpty());
            return None$.MODULE$;
        }
        if (this.currentTransactionInfo().readWholeTable() || this.currentTransactionInfo().readSnapshot().metadata().partitionColumns().isEmpty()) {
            return files.headOption();
        }
        Dataset<Row> filesDf = package$.MODULE$.RichAddFileSeq(files).toDF(this.spark);
        String string = (String)this.spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_CONFLICT_DETECTION_WIDEN_NONDETERMINISTIC_PREDICATES());
        if ("off".equals(string)) {
            return this.getFirstFileMatchingPartitionPredicatesInternal(filesDf, false, false);
        }
        Option<AddFile> fileWithWidening2 = this.getFirstFileMatchingPartitionPredicatesInternal(filesDf, true, true);
        return fileWithWidening2.flatMap((Function1 & Serializable & scala.Serializable)fileWithWidening -> {
            Option<AddFile> fileWithoutWidening = this.getFirstFileMatchingPartitionPredicatesInternal(filesDf, false, false);
            if (fileWithoutWidening.isEmpty()) {
                DeltaLog x$1 = this.deltaLog();
                String x$2 = "delta.conflictDetection.partitionLevelConcurrency.additionalConflictDueToWideningOfNonDeterministicPredicate";
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wideningMode"), (Object)string), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"predicate"), this.currentTransactionInfo().readPredicates().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.partitionPredicate().toString(), Seq$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deterministicUDFs"), (Object)BoxesRunTime.boxToBoolean((boolean)this.containsDeterministicUDF(this.currentTransactionInfo().readPredicates(), true)))}));
                Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
            }
            String string = string;
            String string2 = "on";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some(fileWithWidening);
            }
            return fileWithoutWidening;
        });
    }

    private Option<AddFile> getFirstFileMatchingPartitionPredicatesInternal(Dataset<Row> filesDf, boolean shouldWidenNonDeterministicPredicates, boolean shouldWidenAllUdf) {
        Tuple2 tuple2 = this.currentTransactionInfo().readPredicates().partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.shouldRewriteFilter()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq rewrites = (Seq)tuple2._1();
        Seq nonRewrites = (Seq)tuple2._2();
        Set canonicalRewrites = (Set)ExpressionSet$.MODULE$.apply((TraversableOnce)rewrites.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.partitionPredicate(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)predicate -> this.rewritePredicateFn$1((Expression)predicate, true, shouldWidenNonDeterministicPredicates, shouldWidenAllUdf), Set$.MODULE$.canBuildFrom());
        Set canonicalNonRewrites = (Set)ExpressionSet$.MODULE$.apply((TraversableOnce)nonRewrites.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.partitionPredicate(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)predicate -> this.rewritePredicateFn$1((Expression)predicate, false, shouldWidenNonDeterministicPredicates, shouldWidenAllUdf), Set$.MODULE$.canBuildFrom());
        Set canonicalPredicates = canonicalRewrites.$plus$plus((GenTraversableOnce)canonicalNonRewrites);
        AddFile[] filesMatchingPartitionPredicates = (AddFile[])canonicalPredicates.iterator().flatMap((Function1 & Serializable & scala.Serializable)readPredicate -> {
            StructType x$1 = this.currentTransactionInfo().partitionSchemaAtReadTime();
            Dataset x$2 = filesDf;
            Seq<Expression> x$3 = readPredicate.partitionPredicates();
            boolean x$4 = readPredicate.shouldRewriteFilter();
            Seq<String> x$5 = DeltaLog$.MODULE$.filterFileList$default$4();
            return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaLog$.MODULE$.filterFileList(x$1, (Dataset<Row>)x$2, x$3, x$5, x$4).as(package$.MODULE$.addFileEncoder()).head(1))).headOption());
        }).take(1).toArray(ClassTag$.MODULE$.apply(AddFile.class));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesMatchingPartitionPredicates)).headOption();
    }

    public void checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn() {
        this.recordTime("checked-appends", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            IsolationLevel isolationLevel = $this.isolationLevel;
            if (WriteSerializable$.MODULE$.equals(isolationLevel) && !this.currentTransactionInfo().metadataChanged()) {
                seq = this.winningCommitSummary().changedDataAddedFiles();
            } else if (Serializable$.MODULE$.equals(isolationLevel) ? true : WriteSerializable$.MODULE$.equals(isolationLevel)) {
                seq = (Seq)this.winningCommitSummary().changedDataAddedFiles().$plus$plus(this.winningCommitSummary().blindAppendAddedFiles(), Seq$.MODULE$.canBuildFrom());
            } else if (SnapshotIsolation$.MODULE$.equals(isolationLevel)) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)isolationLevel);
            }
            Seq addedFilesToCheckForConflicts = seq;
            Option<AddFile> fileMatchingPartitionReadPredicates = this.getFirstFileMatchingPartitionPredicates(addedFilesToCheckForConflicts);
            if (fileMatchingPartitionReadPredicates.nonEmpty()) {
                IsolationLevel isolationLevel2 = $this.isolationLevel;
                WriteSerializable$ writeSerializable$ = WriteSerializable$.MODULE$;
                boolean isWriteSerializable = !(isolationLevel2 != null ? !isolationLevel2.equals(writeSerializable$) : writeSerializable$ != null);
                None$ retryMsg = isWriteSerializable && this.winningCommitSummary().onlyAddFiles() && this.winningCommitSummary().isBlindAppendOption().isEmpty() ? new Some((Object)"Upgrading all your concurrent writers to use the latest Delta Lake may avoid this error. Please upgrade and then retry this operation again.") : None$.MODULE$;
                throw DeltaErrors$.MODULE$.concurrentAppendException(this.winningCommitSummary().commitInfo(), this.getPrettyPartitionMessage(((AddFile)fileMatchingPartitionReadPredicates.get()).partitionValues()), (Option<String>)retryMsg);
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnReadFiles() {
        this.recordTime("checked-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map readFilePaths = ((TraversableOnce)this.currentTransactionInfo().readFiles().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.path()), f.partitionValues()), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Option deleteReadOverlap = this.winningCommitSummary().removedFiles().find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)readFilePaths.contains((Object)r.path())));
            if (deleteReadOverlap.nonEmpty()) {
                String filePath = ((RemoveFile)deleteReadOverlap.get()).path();
                String partition = this.getPrettyPartitionMessage((Map<String, String>)((Map)readFilePaths.apply((Object)filePath)));
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), new StringBuilder(4).append(filePath).append(" in ").append(partition).toString());
            }
            if (this.winningCommitSummary().removedFiles().nonEmpty() && this.currentTransactionInfo().readWholeTable()) {
                String filePath = ((RemoveFile)this.winningCommitSummary().removedFiles().head()).path();
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), String.valueOf(filePath));
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnDeletedFiles() {
        this.recordTime("checked-2x-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set txnDeletes = ((TraversableOnce)((TraversableLike)this.currentTransactionInfo().actions().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        return (B1)removeFile;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof RemoveFile;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.path(), Seq$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set deleteOverlap = (scala.collection.immutable.Set)((TraversableOnce)this.winningCommitSummary().removedFiles().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.path(), Seq$.MODULE$.canBuildFrom())).toSet().intersect((GenSet)txnDeletes);
            if (deleteOverlap.nonEmpty()) {
                throw DeltaErrors$.MODULE$.concurrentDeleteDeleteException(this.winningCommitSummary().commitInfo(), (String)deleteOverlap.head());
            }
        });
    }

    public void checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn() {
        if (this.winningCommitSummary().appLevelTransactions().exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn$1(this, x$12)))) {
            throw DeltaErrors$.MODULE$.concurrentTransactionException(this.winningCommitSummary().commitInfo());
        }
    }

    private void checkIfDomainMetadataConflict() {
        if (!DomainMetadataUtils$.MODULE$.domainMetadataSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        Map<String, DomainMetadata> winningDomainMetadataMap = DomainMetadataUtils$.MODULE$.extractDomainMetadatasMap(this.winningCommitSummary().actions());
        Buffer mergedDomainMetadata = (Buffer)Buffer$.MODULE$.empty();
        Seq updatedActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Action action = x0$1;
            if (action instanceof DomainMetadata) {
                DomainMetadata domainMetadata = (DomainMetadata)action;
                DomainMetadata mergedAction = ConflictChecker.resolveConflict$1(domainMetadata, winningDomainMetadataMap);
                mergedDomainMetadata.$plus$eq((Object)mergedAction);
                return mergedAction;
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$1 = mergedDomainMetadata.toSeq();
        Seq x$2 = updatedActions;
        String x$3 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$4 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$5 = qual$1.copy$default$3();
        boolean x$6 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$7 = qual$1.copy$default$5();
        Metadata x$8 = qual$1.copy$default$6();
        Protocol x$9 = qual$1.copy$default$7();
        Snapshot x$10 = qual$1.copy$default$9();
        Option<CommitInfo> x$11 = qual$1.copy$default$10();
        long x$12 = qual$1.copy$default$11();
        this.currentTransactionInfo_$eq(qual$1.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Seq<Action>)x$2, x$10, x$11, x$12, (Seq<DomainMetadata>)x$1));
    }

    private void updateTypeWideningMetadata() {
        if (!TypeWidening$.MODULE$.isEnabled(this.currentTransactionInfo().protocol(), this.currentTransactionInfo().metadata())) {
            return;
        }
        Seq newActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Action action = x0$1;
            if (action instanceof Metadata) {
                Metadata metadata = (Metadata)action;
                StructType updatedSchema = TypeWideningMetadata$.MODULE$.updateTypeChangeVersion(metadata.schema(), this.winningCommitVersion(), this.winningCommitVersion() + 1L);
                String x$1 = updatedSchema.json();
                String x$2 = metadata.copy$default$1();
                String x$3 = metadata.copy$default$2();
                String x$4 = metadata.copy$default$3();
                Format x$5 = metadata.copy$default$4();
                Seq<String> x$6 = metadata.copy$default$6();
                Map<String, String> x$7 = metadata.copy$default$7();
                Option<Object> x$8 = metadata.copy$default$8();
                return metadata.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$9 = newActions;
        String x$10 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$11 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$12 = qual$1.copy$default$3();
        boolean x$13 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$14 = qual$1.copy$default$5();
        Metadata x$15 = qual$1.copy$default$6();
        Protocol x$16 = qual$1.copy$default$7();
        Snapshot x$17 = qual$1.copy$default$9();
        Option<CommitInfo> x$18 = qual$1.copy$default$10();
        long x$19 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$20 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Seq<Action>)x$9, x$17, x$18, x$19, x$20));
    }

    private void reassignOverlappingRowIds() {
        if (!RowId$.MODULE$.isSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        long readHighWaterMark = this.currentTransactionInfo().readRowIdHighWatermark();
        long winningHighWaterMark = BoxesRunTime.unboxToLong((Object)this.winningCommitSummary().actions().collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option<RowId.RowTrackingMetadataDomain> option = RowId$RowTrackingMetadataDomain$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    RowId.RowTrackingMetadataDomain domain = (RowId.RowTrackingMetadataDomain)option.get();
                    return (B1)BoxesRunTime.boxToLong((long)domain.rowIdHighWaterMark());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Action x1) {
                Action action = x1;
                Option<RowId.RowTrackingMetadataDomain> option = RowId$RowTrackingMetadataDomain$.MODULE$.unapply(action);
                return !option.isEmpty();
            }
        }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> readHighWaterMark));
        LongRef highWaterMark = LongRef.create((long)winningHighWaterMark);
        Seq actionsWithReassignedRowIds = (Seq)this.currentTransactionInfo().actions().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DomainMetadata domainMetadata;
            AddFile addFile;
            Action action = x0$1;
            if (action instanceof AddFile && !(addFile = (AddFile)action).baseRowId().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$13 -> x$13 <= readHighWaterMark)) {
                long newBaseRowId = highWaterMark$1.elem + 1L;
                highWaterMark$1.elem += BoxesRunTime.unboxToLong((Object)addFile.numPhysicalRecords().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw DeltaErrors$.MODULE$.rowIdAssignmentWithoutStats();
                }));
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)newBaseRowId));
                String x$2 = addFile.copy$default$1();
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                boolean x$6 = addFile.copy$default$5();
                String x$7 = addFile.copy$default$6();
                Map<String, String> x$8 = addFile.copy$default$7();
                DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                Option<Object> x$10 = addFile.copy$default$10();
                Option<String> x$11 = addFile.copy$default$11();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<Object>)x$1, x$10, x$11)));
            }
            if (action instanceof DomainMetadata && RowId$RowTrackingMetadataDomain$.MODULE$.isSameDomain(domainMetadata = (DomainMetadata)action)) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)action));
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        DomainMetadata domainMetadata = new RowId.RowTrackingMetadataDomain(highWaterMark.elem).toDomainMetadata(ManifestFactory$.MODULE$.Nothing());
        Seq x$12 = (Seq)actionsWithReassignedRowIds.$plus$colon((Object)domainMetadata, Seq$.MODULE$.canBuildFrom());
        long x$13 = winningHighWaterMark;
        String x$14 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$15 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$16 = qual$1.copy$default$3();
        boolean x$17 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$18 = qual$1.copy$default$5();
        Metadata x$19 = qual$1.copy$default$6();
        Protocol x$20 = qual$1.copy$default$7();
        Snapshot x$21 = qual$1.copy$default$9();
        Option<CommitInfo> x$22 = qual$1.copy$default$10();
        Seq<DomainMetadata> x$23 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Seq<Action>)x$12, x$21, x$22, x$13, x$23));
    }

    private void reassignRowCommitVersions() {
        if (!RowTracking$.MODULE$.isSupported(this.currentTransactionInfo().protocol()) && !TypeWidening$.MODULE$.isSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        Seq newActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            AddFile addFile = null;
            Action action = x0$1;
            if (action instanceof AddFile) {
                bl = true;
                addFile = (AddFile)action;
                if (addFile.defaultRowCommitVersion().contains((Object)BoxesRunTime.boxToLong((long)this.winningCommitVersion()))) {
                    Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)(this.winningCommitVersion() + 1L)));
                    String x$2 = addFile.copy$default$1();
                    Map<String, String> x$3 = addFile.copy$default$2();
                    long x$4 = addFile.copy$default$3();
                    long x$5 = addFile.copy$default$4();
                    boolean x$6 = addFile.copy$default$5();
                    String x$7 = addFile.copy$default$6();
                    Map<String, String> x$8 = addFile.copy$default$7();
                    DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                    Option<Object> x$10 = addFile.copy$default$9();
                    Option<String> x$11 = addFile.copy$default$11();
                    return addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, (Option<Object>)x$1, x$11);
                }
            }
            if (bl && addFile.defaultRowCommitVersion().isEmpty()) {
                Some x$12 = new Some((Object)BoxesRunTime.boxToLong((long)(this.winningCommitVersion() + 1L)));
                String x$13 = addFile.copy$default$1();
                Map<String, String> x$14 = addFile.copy$default$2();
                long x$15 = addFile.copy$default$3();
                long x$16 = addFile.copy$default$4();
                boolean x$17 = addFile.copy$default$5();
                String x$18 = addFile.copy$default$6();
                Map<String, String> x$19 = addFile.copy$default$7();
                DeletionVectorDescriptor x$20 = addFile.copy$default$8();
                Option<Object> x$21 = addFile.copy$default$9();
                Option<String> x$22 = addFile.copy$default$11();
                return addFile.copy(x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, (Option<Object>)x$12, x$22);
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$23 = newActions;
        String x$24 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$25 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$26 = qual$1.copy$default$3();
        boolean x$27 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$28 = qual$1.copy$default$5();
        Metadata x$29 = qual$1.copy$default$6();
        Protocol x$30 = qual$1.copy$default$7();
        Snapshot x$31 = qual$1.copy$default$9();
        Option<CommitInfo> x$32 = qual$1.copy$default$10();
        long x$33 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$34 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$30, (Seq<Action>)x$23, x$31, x$32, x$33, x$34));
    }

    private void resolveTimestampOrderingConflicts() {
        if (!BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMPS_ENABLED().fromMetaData(this.currentTransactionInfo().metadata()))) {
            return;
        }
        long winningCommitTimestamp = InCommitTimestampUtils$.MODULE$.didCurrentTransactionEnableICT(this.currentTransactionInfo().metadata(), this.currentTransactionInfo().readSnapshot()) ? this.winningCommitFileStatus.getModificationTime() : CommitInfo$.MODULE$.getRequiredInCommitTimestamp(this.winningCommitSummary().commitInfo(), Long.toString(this.winningCommitVersion()));
        long currentTransactionTimestamp = CommitInfo$.MODULE$.getRequiredInCommitTimestamp(this.currentTransactionInfo().commitInfo(), "NEW_COMMIT");
        CommitInfo currentTransactionCommitInfo = (CommitInfo)this.currentTransactionInfo().commitInfo().get();
        long updatedCommitTimestamp = Math.max(currentTransactionTimestamp, winningCommitTimestamp + 1L);
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)updatedCommitTimestamp));
        Option<Object> x$2 = currentTransactionCommitInfo.copy$default$1();
        Timestamp x$3 = currentTransactionCommitInfo.copy$default$3();
        Option<String> x$4 = currentTransactionCommitInfo.copy$default$4();
        Option<String> x$5 = currentTransactionCommitInfo.copy$default$5();
        String x$6 = currentTransactionCommitInfo.copy$default$6();
        Map<String, String> x$7 = currentTransactionCommitInfo.copy$default$7();
        Option<JobInfo> x$8 = currentTransactionCommitInfo.copy$default$8();
        Option<NotebookInfo> x$9 = currentTransactionCommitInfo.copy$default$9();
        Option<String> x$10 = currentTransactionCommitInfo.copy$default$10();
        Option<Object> x$11 = currentTransactionCommitInfo.copy$default$11();
        Option<String> x$12 = currentTransactionCommitInfo.copy$default$12();
        Option<Object> x$13 = currentTransactionCommitInfo.copy$default$13();
        Option<Map<String, String>> x$14 = currentTransactionCommitInfo.copy$default$14();
        Option<String> x$15 = currentTransactionCommitInfo.copy$default$15();
        Option<Map<String, String>> x$16 = currentTransactionCommitInfo.copy$default$16();
        Option<String> x$17 = currentTransactionCommitInfo.copy$default$17();
        Option<String> x$18 = currentTransactionCommitInfo.copy$default$18();
        CommitInfo updatedCommitInfo = currentTransactionCommitInfo.copy(x$2, (Option<Object>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Some x$19 = new Some((Object)updatedCommitInfo);
        String x$20 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$21 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$22 = qual$1.copy$default$3();
        boolean x$23 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$24 = qual$1.copy$default$5();
        Metadata x$25 = qual$1.copy$default$6();
        Protocol x$26 = qual$1.copy$default$7();
        Seq<Action> x$27 = qual$1.copy$default$8();
        Snapshot x$28 = qual$1.copy$default$9();
        long x$29 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$30 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, (Option<CommitInfo>)x$19, x$29, x$30));
        long nextAvailableVersion = this.winningCommitVersion() + 1L;
        Option<Metadata> updatedMetadata2 = InCommitTimestampUtils$.MODULE$.getUpdatedMetadataWithICTEnablementInfo(updatedCommitTimestamp, this.currentTransactionInfo().readSnapshot(), this.currentTransactionInfo().metadata(), nextAvailableVersion);
        updatedMetadata2.foreach((Function1 & Serializable & scala.Serializable)updatedMetadata -> {
            ConflictChecker.$anonfun$resolveTimestampOrderingConflicts$1(this, updatedMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public String getPrettyPartitionMessage(Map<String, String> partitionValues) {
        StructType partitionColumns = this.currentTransactionInfo().partitionSchemaAtReadTime();
        if (partitionColumns.isEmpty()) {
            return "the root of the table";
        }
        String partition = ((TraversableOnce)partitionColumns.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(1).append(field.name()).append("=").append(partitionValues.apply((Object)DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)field))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        return new StringBuilder(10).append("partition ").append(partition).toString();
    }

    public <T> T recordTime(String phase, Function0<T> f) {
        long startTimeNs = System.nanoTime();
        Object ret = f.apply();
        long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
        this.timingStats().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase), (Object)BoxesRunTime.boxToLong((long)timeTakenMs)));
        return (T)ret;
    }

    public void logMetrics() {
        long totalTimeTakenMs = System.currentTimeMillis() - this.startTimeMs();
        String timingStr = ((TraversableOnce)((TraversableLike)this.timingStats().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(1).append((String)k).append("=").append(this.timingStats().apply(k)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("[").append(this.logPrefix()).append("] Timing stats against ").append(this.winningCommitVersion()).append(" ").append("[").append(timingStr).append(", totalTimeTakenMs: ").append(totalTimeTakenMs).append("]").toString());
    }

    private String logPrefix$lzycompute() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.readSnapshot().metadata().id())).append(",").append("txnId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.txnId())).append("] ").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logPrefix;
    }

    public String logPrefix() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logPrefix$lzycompute();
        }
        return this.logPrefix;
    }

    private final void PredicateElimination$lzycompute$1() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if (this.PredicateElimination$module == null) {
                this.PredicateElimination$module = new ConflictCheckerPredicateElimination$PredicateElimination$(this);
            }
        }
    }

    private final void SubqueryExpression$lzycompute$1() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if (this.SubqueryExpression$module == null) {
                this.SubqueryExpression$module = new DeltaSparkPlanUtils$SubqueryExpression$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$checkProtocolCompatibility$1(ConflictChecker $this, Protocol p) {
        $this.deltaLog().protocolRead(p);
        $this.deltaLog().protocolWrite(p);
        CurrentTransactionInfo qual$1 = $this.currentTransactionInfo();
        Protocol x$1 = p;
        String x$2 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$3 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$4 = qual$1.copy$default$3();
        boolean x$5 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$6 = qual$1.copy$default$5();
        Metadata x$7 = qual$1.copy$default$6();
        Seq<Action> x$8 = qual$1.copy$default$8();
        Snapshot x$9 = qual$1.copy$default$9();
        Option<CommitInfo> x$10 = qual$1.copy$default$10();
        long x$11 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$12 = qual$1.copy$default$12();
        $this.currentTransactionInfo_$eq(qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8, x$9, x$10, x$11, x$12));
    }

    public static final /* synthetic */ boolean $anonfun$checkProtocolCompatibility$2(Action x$4) {
        return x$4 instanceof Protocol;
    }

    private final DeltaTableReadPredicate rewritePredicateFn$1(Expression predicate, boolean shouldRewriteFilter, boolean shouldWidenNonDeterministicPredicates$1, boolean shouldWidenAllUdf$1) {
        Seq<Expression> rewrittenPredicate;
        Seq<Expression> seq;
        if (shouldWidenNonDeterministicPredicates$1) {
            DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions = new DeltaSparkPlanUtils.CheckDeterministicOptions(!shouldWidenAllUdf$1);
            seq = this.eliminateNonDeterministicPredicates((Seq<Expression>)((Seq)new .colon.colon((Object)predicate, (List)Nil$.MODULE$)), checkDeterministicOptions).newPredicates();
        } else {
            seq = (Seq<Expression>)new .colon.colon((Object)predicate, (List)Nil$.MODULE$);
        }
        Seq<Expression> x$1 = rewrittenPredicate = seq;
        boolean x$2 = shouldRewriteFilter;
        Seq<Expression> x$3 = DeltaTableReadPredicate$.MODULE$.apply$default$2();
        return new DeltaTableReadPredicate(x$1, x$3, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn$1(ConflictChecker $this, SetTransaction x$12) {
        return $this.currentTransactionInfo().isConflict(x$12);
    }

    private static final DomainMetadata resolveConflict$1(DomainMetadata domainMetadataFromCurrentTransaction, Map winningDomainMetadataMap$1) {
        Option option;
        DomainMetadata domain;
        Tuple2 tuple2 = new Tuple2((Object)domainMetadataFromCurrentTransaction, (Object)winningDomainMetadataMap$1.get((Object)domainMetadataFromCurrentTransaction.domain()));
        if (tuple2 != null) {
            DomainMetadata domain2 = (DomainMetadata)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option2)) {
                return domain2;
            }
        }
        if (tuple2 != null && RowId$RowTrackingMetadataDomain$.MODULE$.isSameDomain(domain = (DomainMetadata)tuple2._1())) {
            return domain;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            throw new ConcurrentTransactionException(new StringBuilder(40).append("A conflicting metadata domain ").append(domainMetadataFromCurrentTransaction.domain()).append(" is ").append("added.").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$resolveTimestampOrderingConflicts$1(ConflictChecker $this, Metadata updatedMetadata) {
        CurrentTransactionInfo qual$2 = $this.currentTransactionInfo();
        Metadata x$31 = updatedMetadata;
        Seq x$32 = (Seq)$this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Action action = x0$1;
            if (action instanceof Metadata) {
                return updatedMetadata;
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        String x$33 = qual$2.copy$default$1();
        Seq<DeltaTableReadPredicate> x$34 = qual$2.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$35 = qual$2.copy$default$3();
        boolean x$36 = qual$2.copy$default$4();
        scala.collection.immutable.Set<String> x$37 = qual$2.copy$default$5();
        Protocol x$38 = qual$2.copy$default$7();
        Snapshot x$39 = qual$2.copy$default$9();
        Option<CommitInfo> x$40 = qual$2.copy$default$10();
        long x$41 = qual$2.copy$default$11();
        Seq<DomainMetadata> x$42 = qual$2.copy$default$12();
        $this.currentTransactionInfo_$eq(qual$2.copy(x$33, x$34, x$35, x$36, x$37, x$31, x$38, (Seq<Action>)x$32, x$39, x$40, x$41, x$42));
    }

    private static final String truncate$1(String uuid) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-"))).head();
    }

    public ConflictChecker(SparkSession spark, CurrentTransactionInfo initialCurrentTransactionInfo, FileStatus winningCommitFileStatus, IsolationLevel isolationLevel) {
        this.spark = spark;
        this.initialCurrentTransactionInfo = initialCurrentTransactionInfo;
        this.winningCommitFileStatus = winningCommitFileStatus;
        this.isolationLevel = isolationLevel;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaSparkPlanUtils.$init$(this);
        ConflictCheckerPredicateElimination.$init$(this);
        this.winningCommitVersion = FileNames$.MODULE$.deltaVersion(winningCommitFileStatus);
        this.startTimeMs = System.currentTimeMillis();
        this.timingStats = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deltaLog = initialCurrentTransactionInfo.readSnapshot().deltaLog();
        this.currentTransactionInfo = initialCurrentTransactionInfo;
    }
}

