/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.io.IOException;

interface StorageReadChannel
extends ReadChannel {
    public StorageReadChannel setByteRangeSpec(ByteRangeSpec var1);

    public ApiFuture<BlobInfo> getObject();

    default public ByteRangeSpec getByteRangeSpec() {
        return ByteRangeSpec.nullRange();
    }

    @Override
    @Deprecated
    default public void seek(long position) throws IOException {
        try {
            this.setByteRangeSpec(this.getByteRangeSpec().withNewBeginOffset(position));
        }
        catch (StorageException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @Override
    @Deprecated
    default public ReadChannel limit(long limit) {
        Preconditions.checkArgument(limit >= 0L, "limit must be >= 0");
        this.setByteRangeSpec(this.getByteRangeSpec().withNewEndOffset(limit));
        return this;
    }

    @Override
    @Deprecated
    default public long limit() {
        return this.getByteRangeSpec().endOffset();
    }
}

