/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.contrib.resource.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Splitter;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.contrib.resource.util.GcpMetadataConfig;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.resource.Resource;
import java.util.LinkedHashMap;
import java.util.List;

public class K8sResource {
    public static final String TYPE = "k8s";
    public static final String CLUSTER_NAME_KEY = "k8s.cluster.name";
    public static final String NAMESPACE_NAME_KEY = "k8s.namespace.name";
    public static final String POD_NAME_KEY = "k8s.pod.name";
    public static final String DEPLOYMENT_NAME_KEY = "k8s.deployment.name";
    private static final Splitter splitter = Splitter.on('-');

    @Deprecated
    public static Resource create(String clusterName, String namespace, String podName) {
        return K8sResource.create(clusterName, namespace, podName, "");
    }

    public static Resource create(String clusterName, String namespace, String podName, String deploymentName) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(CLUSTER_NAME_KEY, Preconditions.checkNotNull(clusterName, "clusterName"));
        labels.put(NAMESPACE_NAME_KEY, Preconditions.checkNotNull(namespace, "namespace"));
        labels.put(POD_NAME_KEY, Preconditions.checkNotNull(podName, "podName"));
        labels.put(DEPLOYMENT_NAME_KEY, Preconditions.checkNotNull(deploymentName, "deploymentName"));
        return Resource.create(TYPE, labels);
    }

    static Resource detect() {
        String podName = MoreObjects.firstNonNull(System.getenv("HOSTNAME"), "");
        String deploymentName = K8sResource.getDeploymentNameFromPodName(podName);
        return K8sResource.create(GcpMetadataConfig.getClusterName(), MoreObjects.firstNonNull(System.getenv("NAMESPACE"), ""), podName, deploymentName);
    }

    @VisibleForTesting
    static String getDeploymentNameFromPodName(String podName) {
        StringBuilder deploymentName = new StringBuilder();
        List<String> parts = splitter.splitToList(podName);
        if (parts.size() == 3) {
            deploymentName.append(parts.get(0));
        } else if (parts.size() > 3) {
            for (int i = 0; i < parts.size() - 2; ++i) {
                if (deploymentName.length() > 0) {
                    deploymentName.append('-');
                }
                deploymentName.append(parts.get(i));
            }
        }
        return deploymentName.toString();
    }

    private K8sResource() {
    }
}

