/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeVpcsRequestMarshaller
implements Marshaller<Request<DescribeVpcsRequest>, DescribeVpcsRequest> {
    @Override
    public Request<DescribeVpcsRequest> marshall(DescribeVpcsRequest describeVpcsRequest) {
        SdkInternalList describeVpcsRequestVpcIdsList;
        if (describeVpcsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVpcsRequest> request = new DefaultRequest<DescribeVpcsRequest>(describeVpcsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcsRequestFiltersList = (SdkInternalList)describeVpcsRequest.getFilters();
        if (!describeVpcsRequestFiltersList.isEmpty() || !describeVpcsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcsRequestFiltersListValue : describeVpcsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeVpcsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpcsRequestVpcIdsList = (SdkInternalList)describeVpcsRequest.getVpcIds()).isEmpty() || !describeVpcsRequestVpcIdsList.isAutoConstruct()) {
            int vpcIdsListIndex = 1;
            for (String describeVpcsRequestVpcIdsListValue : describeVpcsRequestVpcIdsList) {
                if (describeVpcsRequestVpcIdsListValue != null) {
                    request.addParameter("VpcId." + vpcIdsListIndex, StringUtils.fromString(describeVpcsRequestVpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        if (describeVpcsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVpcsRequest.getNextToken()));
        }
        if (describeVpcsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVpcsRequest.getMaxResults()));
        }
        return request;
    }
}

