/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class RegisterImageRequestMarshaller
implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {
    @Override
    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {
        SdkInternalList registerImageRequestTagSpecificationsList;
        SdkInternalList registerImageRequestBillingProductsList;
        SdkInternalList registerImageRequestBlockDeviceMappingsList;
        if (registerImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterImageRequest> request = new DefaultRequest<RegisterImageRequest>(registerImageRequest, "AmazonEC2");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerImageRequest.getImageLocation() != null) {
            request.addParameter("ImageLocation", StringUtils.fromString(registerImageRequest.getImageLocation()));
        }
        if (registerImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString(registerImageRequest.getArchitecture()));
        }
        if (!(registerImageRequestBlockDeviceMappingsList = (SdkInternalList)registerImageRequest.getBlockDeviceMappings()).isEmpty() || !registerImageRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (Object registerImageRequestBlockDeviceMappingsListValue : registerImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getDeviceName()));
                }
                if (((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getVirtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getEbs()) != null) {
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                    }
                    if (ebs.getKmsKeyId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString(ebs.getKmsKeyId()));
                    }
                    if (ebs.getThroughput() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger(ebs.getThroughput()));
                    }
                    if (ebs.getOutpostArn() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.OutpostArn", StringUtils.fromString(ebs.getOutpostArn()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                    }
                }
                if (((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (registerImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(registerImageRequest.getDescription()));
        }
        if (registerImageRequest.getEnaSupport() != null) {
            request.addParameter("EnaSupport", StringUtils.fromBoolean(registerImageRequest.getEnaSupport()));
        }
        if (registerImageRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(registerImageRequest.getKernelId()));
        }
        if (registerImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(registerImageRequest.getName()));
        }
        if (!(registerImageRequestBillingProductsList = (SdkInternalList)registerImageRequest.getBillingProducts()).isEmpty() || !registerImageRequestBillingProductsList.isAutoConstruct()) {
            int billingProductsListIndex = 1;
            for (String registerImageRequestBillingProductsListValue : registerImageRequestBillingProductsList) {
                if (registerImageRequestBillingProductsListValue != null) {
                    request.addParameter("BillingProduct." + billingProductsListIndex, StringUtils.fromString(registerImageRequestBillingProductsListValue));
                }
                ++billingProductsListIndex;
            }
        }
        if (registerImageRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(registerImageRequest.getRamdiskId()));
        }
        if (registerImageRequest.getRootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringUtils.fromString(registerImageRequest.getRootDeviceName()));
        }
        if (registerImageRequest.getSriovNetSupport() != null) {
            request.addParameter("SriovNetSupport", StringUtils.fromString(registerImageRequest.getSriovNetSupport()));
        }
        if (registerImageRequest.getVirtualizationType() != null) {
            request.addParameter("VirtualizationType", StringUtils.fromString(registerImageRequest.getVirtualizationType()));
        }
        if (registerImageRequest.getBootMode() != null) {
            request.addParameter("BootMode", StringUtils.fromString(registerImageRequest.getBootMode()));
        }
        if (registerImageRequest.getTpmSupport() != null) {
            request.addParameter("TpmSupport", StringUtils.fromString(registerImageRequest.getTpmSupport()));
        }
        if (registerImageRequest.getUefiData() != null) {
            request.addParameter("UefiData", StringUtils.fromString(registerImageRequest.getUefiData()));
        }
        if (registerImageRequest.getImdsSupport() != null) {
            request.addParameter("ImdsSupport", StringUtils.fromString(registerImageRequest.getImdsSupport()));
        }
        if (!(registerImageRequestTagSpecificationsList = (SdkInternalList)registerImageRequest.getTagSpecifications()).isEmpty() || !registerImageRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification registerImageRequestTagSpecificationsListValue : registerImageRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (registerImageRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(registerImageRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)registerImageRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

