/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class StopInstancesRequestMarshaller
implements Marshaller<Request<StopInstancesRequest>, StopInstancesRequest> {
    @Override
    public Request<StopInstancesRequest> marshall(StopInstancesRequest stopInstancesRequest) {
        if (stopInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopInstancesRequest> request = new DefaultRequest<StopInstancesRequest>(stopInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "StopInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList stopInstancesRequestInstanceIdsList = (SdkInternalList)stopInstancesRequest.getInstanceIds();
        if (!stopInstancesRequestInstanceIdsList.isEmpty() || !stopInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String stopInstancesRequestInstanceIdsListValue : stopInstancesRequestInstanceIdsList) {
                if (stopInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(stopInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (stopInstancesRequest.getHibernate() != null) {
            request.addParameter("Hibernate", StringUtils.fromBoolean(stopInstancesRequest.getHibernate()));
        }
        if (stopInstancesRequest.getForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean(stopInstancesRequest.getForce()));
        }
        return request;
    }
}

