/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.util;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonFactory;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.BeanDescription;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationFeature;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonSerializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.Module;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.SerializationConfig;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.SerializationFeature;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.module.SimpleModule;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.dataiku.dss.shadelib.io.swagger.jackson.ModelSerializer;
import com.dataiku.dss.shadelib.io.swagger.jackson.PropertySerializer;
import com.dataiku.dss.shadelib.io.swagger.jackson.mixin.OperationResponseMixin;
import com.dataiku.dss.shadelib.io.swagger.jackson.mixin.ResponseSchemaMixin;
import com.dataiku.dss.shadelib.io.swagger.models.Model;
import com.dataiku.dss.shadelib.io.swagger.models.Operation;
import com.dataiku.dss.shadelib.io.swagger.models.Response;
import com.dataiku.dss.shadelib.io.swagger.models.properties.Property;
import com.dataiku.dss.shadelib.io.swagger.util.DeserializationModule;
import com.dataiku.dss.shadelib.io.swagger.util.ReferenceSerializationConfigurer;

public class ObjectMapperFactory {
    public static ObjectMapper createJson(JsonFactory jsonFactory) {
        return ObjectMapperFactory.create(jsonFactory, true, true);
    }

    public static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    public static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(null, includePathDeserializer, includeResponseDeserializer);
    }

    public static ObjectMapper createYaml(YAMLFactory yamlFactory) {
        return ObjectMapperFactory.create(yamlFactory, true, true);
    }

    public static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    public static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(new YAMLFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    public static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = jsonFactory == null ? new ObjectMapper() : new ObjectMapper(jsonFactory);
        mapper.registerModule(new SimpleModule(){

            @Override
            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    @Override
                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                        if (Property.class.isAssignableFrom(desc.getBeanClass())) {
                            return new PropertySerializer(serializer);
                        }
                        if (Model.class.isAssignableFrom(desc.getBeanClass())) {
                            return new ModelSerializer(serializer);
                        }
                        return serializer;
                    }
                });
            }
        });
        DeserializationModule deserializerModule = new DeserializationModule(includePathDeserializer, includeResponseDeserializer);
        mapper.registerModule(deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixIn(Response.class, ResponseSchemaMixin.class);
        mapper.addMixIn(Operation.class, OperationResponseMixin.class);
        ReferenceSerializationConfigurer.serializeAsComputedRef(mapper);
        return mapper;
    }
}

