/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.server.jmx;

import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.handler.ContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.jmx.Handler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedObject;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

@ManagedObject
public class ServerMBean
extends Handler.AbstractMBean {
    private final Instant startup = Instant.now();

    public ServerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public Server getManagedObject() {
        return (Server)super.getManagedObject();
    }

    @ManagedAttribute(value="The contexts on this server")
    public List<ContextHandler> getContexts() {
        return this.getManagedObject().getDescendants(ContextHandler.class);
    }

    @ManagedAttribute(value="The UTC startup instant")
    public String getStartupTime() {
        return this.startup.toString();
    }

    @ManagedAttribute(value="The uptime duration in d:HH:mm:ss.SSS")
    public String getUpTime() {
        Duration upTime = Duration.between(this.startup, Instant.now());
        return "%d:%02d:%02d:%02d.%03d".formatted(upTime.toDaysPart(), upTime.toHoursPart(), upTime.toMinutesPart(), upTime.toSecondsPart(), upTime.toMillisPart());
    }
}

