/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.reactor.core.publisher;

import com.dataiku.dss.shadelib.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelib.reactor.core.Scannable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelib.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelib.reactor.core.publisher.SourceProducer;
import com.dataiku.dss.shadelib.reactor.util.context.Context;
import com.dataiku.dss.shadelib.reactor.util.context.ContextView;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;

final class FluxDeferContextual<T>
extends Flux<T>
implements SourceProducer<T> {
    final Function<ContextView, ? extends Publisher<? extends T>> contextualPublisherFactory;

    FluxDeferContextual(Function<ContextView, ? extends Publisher<? extends T>> contextualPublisherFactory) {
        this.contextualPublisherFactory = Objects.requireNonNull(contextualPublisherFactory, "contextualPublisherFactory");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Publisher<? extends T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.contextualPublisherFactory.apply(ctx.readOnly()), "The Publisher returned by the contextualPublisherFactory is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        FluxDeferContextual.from(p).subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

