/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import au.com.objectix.jgridshift.GridShiftFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;

public class NTv2GridShiftFactory
extends ReferencingFactory
implements BufferedFactory {
    private static final int GRID_CACHE_HARD_REFERENCES = 10;
    protected static final Logger LOGGER = Logging.getLogger(NTv2GridShiftFactory.class);
    private SoftValueHashMap<String, GridShiftFile> ntv2GridCache = new SoftValueHashMap(10);

    public NTv2GridShiftFactory() {
    }

    public NTv2GridShiftFactory(int priority) {
        super(priority);
    }

    public boolean isNTv2Grid(URL location) {
        if (location != null) {
            return this.isNTv2GridFileValid(location);
        }
        return false;
    }

    public GridShiftFile createNTv2Grid(URL gridLocation) throws FactoryException {
        if (gridLocation == null) {
            throw new FactoryException("The grid location must be not null");
        }
        SoftValueHashMap<String, GridShiftFile> softValueHashMap = this.ntv2GridCache;
        synchronized (softValueHashMap) {
            GridShiftFile grid = (GridShiftFile)this.ntv2GridCache.get((Object)gridLocation.toExternalForm());
            if (grid != null) {
                return grid;
            }
            if (gridLocation != null && (grid = this.loadNTv2Grid(gridLocation)) != null) {
                this.ntv2GridCache.put((Object)gridLocation.toExternalForm(), (Object)grid);
                return grid;
            }
            throw new FactoryException("NTv2 Grid " + gridLocation + " could not be created.");
        }
    }

    protected boolean isNTv2GridFileValid(URL url) {
        try {
            if (url.getProtocol().equals("file")) {
                File file = URLs.urlToFile((URL)url);
                if (!file.exists() || !file.canRead()) {
                    throw new IOException(Errors.format((int)50, (Object)file));
                }
                try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                    new GridShiftFile().loadGridShiftFile(raf);
                }
            }
            try (BufferedInputStream in = new BufferedInputStream(url.openConnection().getInputStream());){
                new GridShiftFile().loadGridShiftFile((InputStream)in, false);
            }
            return true;
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GridShiftFile loadNTv2Grid(URL location) throws FactoryException {
        try (BufferedInputStream in = new BufferedInputStream(location.openStream());){
            GridShiftFile grid = new GridShiftFile();
            grid.loadGridShiftFile((InputStream)in, false);
            ((InputStream)in).close();
            GridShiftFile gridShiftFile = grid;
            return gridShiftFile;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            throw new FactoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

