/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.DKUApp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class MainUtils {
    private static Logger logger = Logger.getLogger((String)"dku");

    private static String getOSAndStuff() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " - Java: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version");
    }

    public static List<String> getHelloMessages(String what) {
        ArrayList<String> events = new ArrayList<String>();
        events.add("----------------------------------------");
        events.add("DSS startup: " + what + " version:" + DKUApp.getDSSVersion().product_version);
        events.add("DSS home: " + DKUApp.getBaseFolderF().getAbsolutePath());
        events.add("OS: " + MainUtils.getOSAndStuff());
        return events;
    }

    public static void printHello(String what) {
        for (String line : MainUtils.getHelloMessages(what)) {
            logger.info((Object)line);
        }
    }

    public static List<LoggingEvent> getHello(String what) {
        ArrayList<LoggingEvent> events = new ArrayList<LoggingEvent>();
        for (String line : MainUtils.getHelloMessages(what)) {
            events.add(new LoggingEvent("dku", (Category)logger, Priority.INFO, (Object)line, null));
        }
        return events;
    }

    public static void printLambdaHello() {
        logger.info((Object)"----------------------------------------");
        logger.info((Object)"DSS startup: API Node");
        logger.info((Object)("API node home: " + System.getenv("DKU_LAMBDA_HOME")));
        logger.info((Object)("Base DSS home: " + System.getenv("DIP_HOME")));
        logger.info((Object)("OS: " + MainUtils.getOSAndStuff()));
    }
}

