/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelibgcp.org.threeten.bp.OffsetDateTime;
import com.dataiku.dss.shadelibgcp.org.threeten.bp.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FilterOperatorValidator {
    private static Map<String, OperatorOutputs> getTypeToNumberOperatorMap() {
        return ImmutableMap.builder().put((Object)"STRICTLY_LESS_THAN", (Object)new OperatorOutputs("<  [number]", "<  [column]")).put((Object)"LESS_THAN", (Object)new OperatorOutputs("<= [number]", "<= [column]")).put((Object)"STRICTLY_GREATER_THAN", (Object)new OperatorOutputs(">  [number]", ">  [column]")).put((Object)"GREATER_THAN", (Object)new OperatorOutputs(">= [number]", ">= [column]")).put((Object)"EQUALS", (Object)new OperatorOutputs("== [number]", "== [column]")).put((Object)"IS_DEFINED", (Object)new OperatorOutputs("not empty string", null)).put((Object)"IS_DIFFERENT", (Object)new OperatorOutputs("!= [number]", "!= [column]")).build();
    }

    private static FilterDesc.FilterUiCondition makeDefaultFilterUICondition(Map<String, SchemaColumn> columnNameToSchemaColumnMap, OperatorOutputs operator, AIRecipe.FilterCondition condition) {
        String op = columnNameToSchemaColumnMap.containsKey(condition.value) && operator.columnOperator != null ? operator.columnOperator : operator.valueOperator;
        FilterDesc.FilterUiCondition uiCond = new FilterDesc.FilterUiCondition();
        uiCond.operator = op;
        uiCond.input = condition.column;
        uiCond.col = condition.value;
        return uiCond;
    }

    private static FilterDesc.FilterUiCondition buildNumberConditionOperator(Map<String, SchemaColumn> columnNameToSchemaColumnMap, OperatorOutputs operator, AIRecipe.FilterCondition condition) {
        FilterDesc.FilterUiCondition uiCond = FilterOperatorValidator.makeDefaultFilterUICondition(columnNameToSchemaColumnMap, operator, condition);
        if (StringUtils.isNotBlank((String)condition.value)) {
            uiCond.num = Double.parseDouble(condition.value);
        }
        return uiCond;
    }

    private static Map<String, OperatorOutputs> getTypeToBooleanOperatorMap() {
        return ImmutableMap.builder().put((Object)"IS_DEFINED", (Object)new OperatorOutputs("not empty string", null)).put((Object)"EQUALS", (Object)new OperatorOutputs(null, "== [NaNcolumn]")).put((Object)"IS_DIFFERENT", (Object)new OperatorOutputs(null, "!= [NaNcolumn]")).put((Object)"TRUE", (Object)new OperatorOutputs("true", null)).put((Object)"FALSE", (Object)new OperatorOutputs("false", null)).build();
    }

    private static FilterDesc.FilterUiCondition buildBooleanConditionOperator(Map<String, SchemaColumn> columnNameToSchemaColumnMap, OperatorOutputs operator, AIRecipe.FilterCondition condition, Map<String, OperatorOutputs> typeToBooleanOperatorMap) {
        String op;
        String string = op = columnNameToSchemaColumnMap.containsKey(condition.value) && operator.columnOperator != null ? operator.columnOperator : operator.valueOperator;
        if (op == null) {
            java.lang.Boolean isConditionValueTrue = FilterOperatorValidator.isTrue(condition.value);
            if (isConditionValueTrue == null) {
                return null;
            }
            op = isConditionValueTrue != false ? (condition.type.equals("EQUALS") ? typeToBooleanOperatorMap.get((Object)"TRUE").valueOperator : typeToBooleanOperatorMap.get((Object)"FALSE").valueOperator) : (condition.type.equals("EQUALS") ? typeToBooleanOperatorMap.get((Object)"FALSE").valueOperator : typeToBooleanOperatorMap.get((Object)"TRUE").valueOperator);
        }
        FilterDesc.FilterUiCondition uiCond = new FilterDesc.FilterUiCondition();
        uiCond.operator = op;
        uiCond.input = condition.column;
        uiCond.col = condition.value;
        return uiCond;
    }

    private static java.lang.Boolean isTrue(String value) {
        Boolean booleanDSSType = new Boolean();
        return booleanDSSType.parseNoFail(value);
    }

    private static Map<String, OperatorOutputs> getTypeToStringOperatorMap() {
        return ImmutableMap.builder().put((Object)"IS_DEFINED", (Object)new OperatorOutputs("not empty", null)).put((Object)"EQUALS", (Object)new OperatorOutputs("== [string]", "== [NaNcolumn]")).put((Object)"CONTAINS", (Object)new OperatorOutputs("contains", null)).put((Object)"IS_DIFFERENT", (Object)new OperatorOutputs("!= [string]", "!= [NaNcolumn]")).build();
    }

    private static FilterDesc.FilterUiCondition buildStringConditionOperator(Map<String, SchemaColumn> columnNameToSchemaColumnMap, OperatorOutputs operator, AIRecipe.FilterCondition condition) {
        FilterDesc.FilterUiCondition uiCond = FilterOperatorValidator.makeDefaultFilterUICondition(columnNameToSchemaColumnMap, operator, condition);
        uiCond.string = condition.value;
        return uiCond;
    }

    private static Map<String, OperatorOutputs> getTypeToDateOperatorMap() {
        return ImmutableMap.builder().put((Object)"IS_DEFINED", (Object)new OperatorOutputs("not empty string", null)).put((Object)"EQUALS", (Object)new OperatorOutputs("== [date]", "== [NaNcolumn]")).put((Object)"STRICTLY_LESS_THAN", (Object)new OperatorOutputs("<  [date]", null)).put((Object)"LESS_THAN", (Object)new OperatorOutputs("<  [date]", null)).put((Object)"STRICTLY_GREATER_THAN", (Object)new OperatorOutputs(">= [date]", null)).put((Object)"GREATER_THAN", (Object)new OperatorOutputs(">= [date]", null)).put((Object)"IS_DIFFERENT", (Object)new OperatorOutputs("not in [date]", "!= [NaNcolumn]")).build();
    }

    private static FilterDesc.FilterUiCondition buildDateConditionOperator(Map<String, SchemaColumn> columnNameToSchemaColumnMap, OperatorOutputs operator, AIRecipe.FilterCondition condition, DKULogger logger) {
        String time;
        FilterDesc.FilterUiCondition uiCond = FilterOperatorValidator.makeDefaultFilterUICondition(columnNameToSchemaColumnMap, operator, condition);
        if (StringUtils.isBlank((String)condition.value)) {
            return uiCond;
        }
        OffsetDateTime dateTime = OffsetDateTime.parse((CharSequence)condition.value);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)"yyyy-MM-dd");
        uiCond.date = dateTime.format(formatter);
        try {
            time = condition.value.substring(11, 16);
        }
        catch (Exception e) {
            logger.warn((Object)"Could not find an appropriate time of day from the recipe generation request you made to create your date filter condition", (Throwable)e);
            time = "00:00";
        }
        uiCond.time = time;
        if (operator.valueOperator.equals("not in [date]")) {
            FilterDesc.FilterUiListConditionValue uiConditionValue = new FilterDesc.FilterUiListConditionValue();
            uiConditionValue.date = condition.value;
            uiConditionValue.time = time;
            uiCond.items = List.of(uiConditionValue);
        }
        return uiCond;
    }

    public static void validateFilterConditions(List<Dataset> datasets, String contextProjectKey, List<AIRecipeGenerationService.CreationMessage> creationMessages, String inputDataset, List<? extends AIRecipe.FilterCondition> conditions, String lang) {
        Map<String, SchemaColumn> datasetColumnNamesToSchemaColumn = AIRecipe.AIRecipeParams.getDataset(datasets, (String)inputDataset, (String)contextProjectKey).getSchema().columns.stream().collect(Collectors.toMap(SchemaColumn::getName, sc -> sc));
        Map<Type, Set<String>> supportedOperatorPerColumnType = FilterOperatorValidator.getSupportedOperatorPerColumnType();
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        for (AIRecipe.FilterCondition filterCondition : conditions) {
            if (!datasetColumnNamesToSchemaColumn.containsKey(filterCondition.column)) {
                creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.FILTER.COLUMN_DOES_NOT_EXIST", String.format("The filtering column %s does not exist on the provided input dataset", filterCondition.column), "column", filterCondition.column)));
                continue;
            }
            Type columnType = datasetColumnNamesToSchemaColumn.get(filterCondition.column).getType();
            if (supportedOperatorPerColumnType.containsKey(columnType) && supportedOperatorPerColumnType.get(columnType).contains(filterCondition.type)) continue;
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.FILTER.UNSUPPORTED_OPERATOR", String.format("The operator %s is not supported on column %s with column type %s", filterCondition.type, filterCondition.column, columnType), "type", filterCondition.type, "column", filterCondition.column, "columnType", columnType)));
        }
    }

    private static Map<Type, Set<String>> getSupportedOperatorPerColumnType() {
        Set<String> numberKeySet = FilterOperatorValidator.getTypeToNumberOperatorMap().keySet();
        return ImmutableMap.builder().put((Object)Type.BOOLEAN, FilterOperatorValidator.getTypeToBooleanOperatorMap().keySet()).put((Object)Type.STRING, FilterOperatorValidator.getTypeToStringOperatorMap().keySet()).put((Object)Type.DATE, FilterOperatorValidator.getTypeToDateOperatorMap().keySet()).put((Object)Type.BIGINT, numberKeySet).put((Object)Type.DOUBLE, numberKeySet).put((Object)Type.FLOAT, numberKeySet).put((Object)Type.INT, numberKeySet).put((Object)Type.TINYINT, numberKeySet).put((Object)Type.SMALLINT, numberKeySet).build();
    }

    public static <T extends AIRecipe.FilterCondition> List<FilterDesc.FilterUiCondition> getConditionsOperators(List<Dataset> datasets, String inputDataset, List<T> conditions, String contextProjectKey, DKULogger logger) {
        ArrayList<FilterDesc.FilterUiCondition> ret = new ArrayList<FilterDesc.FilterUiCondition>();
        Map<String, OperatorOutputs> typeToNumberOperatorMap = FilterOperatorValidator.getTypeToNumberOperatorMap();
        Map<String, OperatorOutputs> typeToStringOperatorMap = FilterOperatorValidator.getTypeToStringOperatorMap();
        Map<String, OperatorOutputs> typeToDateOperatorMap = FilterOperatorValidator.getTypeToDateOperatorMap();
        Map<String, OperatorOutputs> typeToBooleanOperatorMap = FilterOperatorValidator.getTypeToBooleanOperatorMap();
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, inputDataset, contextProjectKey);
        if (dataset == null) {
            return ret;
        }
        Map<String, SchemaColumn> columnNameToSchemaColumnMap = dataset.getSchema().columns.stream().collect(Collectors.toMap(SchemaColumn::getName, sc -> sc));
        for (AIRecipe.FilterCondition condition : conditions) {
            FilterDesc.FilterUiCondition booleanFilter;
            OperatorOutputs booleanOp;
            SchemaColumn schemaColumn = columnNameToSchemaColumnMap.get(condition.column);
            if (schemaColumn == null) continue;
            Type columnType = schemaColumn.getType();
            if (columnType.equals((Object)Type.STRING)) {
                OperatorOutputs strOp = typeToStringOperatorMap.get(condition.type);
                if (strOp == null) continue;
                ret.add(FilterOperatorValidator.buildStringConditionOperator(columnNameToSchemaColumnMap, strOp, condition));
                continue;
            }
            if (columnType.isNumeric()) {
                OperatorOutputs numOp = typeToNumberOperatorMap.get(condition.type);
                if (numOp == null) continue;
                ret.add(FilterOperatorValidator.buildNumberConditionOperator(columnNameToSchemaColumnMap, numOp, condition));
                continue;
            }
            if (columnType.isTemporal()) {
                OperatorOutputs dateOp = typeToDateOperatorMap.get(condition.type);
                if (dateOp == null) continue;
                ret.add(FilterOperatorValidator.buildDateConditionOperator(columnNameToSchemaColumnMap, dateOp, condition, logger));
                continue;
            }
            if (!columnType.equals((Object)Type.BOOLEAN) || (booleanOp = typeToBooleanOperatorMap.get(condition.type)) == null || (booleanFilter = FilterOperatorValidator.buildBooleanConditionOperator(columnNameToSchemaColumnMap, booleanOp, condition, typeToBooleanOperatorMap)) == null) continue;
            ret.add(booleanFilter);
        }
        return ret;
    }

    private static class OperatorOutputs {
        public String valueOperator;
        public String columnOperator;

        public OperatorOutputs(String vo, String co2) {
            this.valueOperator = vo;
            this.columnOperator = co2;
        }
    }
}

