/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.validator.ModelValidator;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class RegressionCoeffStatusExtractor
implements ModelExtractor<String>,
ModelValidator {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        return this.isCompatible(model) ? "Yes" : "No";
    }

    @Override
    public void validate(ModelDetailsBase model) throws IOException {
        if (!this.isCompatible(model)) {
            throw new IOException("the model is not compatible with a regression coefficient");
        }
    }

    private boolean isCompatible(ModelDetailsBase model) {
        if (model instanceof ClassicalPredictionModelDetails) {
            ClassicalPredictionModelDetails predictionModel = (ClassicalPredictionModelDetails)model;
            if (predictionModel.coreParams != null && predictionModel.coreParams.partitionedModel != null && predictionModel.coreParams.partitionedModel.enabled) {
                return false;
            }
            return predictionModel.coreParams != null && !PredictionMLTask.PredictionType.MULTICLASS.equals((Object)predictionModel.coreParams.prediction_type) && predictionModel.iperf != null && predictionModel.iperf.lmCoefficients != null;
        }
        return false;
    }
}

