/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.helpers.TimeSeriesUtil;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class TimeseriesScoringDataLengthExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        if (timeseriesModelDetails.iperf.minTimeseriesSizeForScoring == 0) {
            return "the past data";
        }
        Object output = String.format("at least %s of past data", TimeSeriesUtil.prettyTimeStep(timeseriesModelDetails.iperf.minTimeseriesSizeForScoring, timeseriesModelDetails.coreParams.timestepParams.timeunit));
        if (timeseriesModelDetails.iperf.maxUsedTimestepsForScoring > timeseriesModelDetails.iperf.minTimeseriesSizeForScoring) {
            output = (String)output + String.format(" (for every evaluation window, up to %s will be used for forecasting)", TimeSeriesUtil.prettyTimeStep(timeseriesModelDetails.iperf.maxUsedTimestepsForScoring, timeseriesModelDetails.coreParams.timestepParams.timeunit));
        }
        return output;
    }
}

