/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.ScoringRecipeUtils;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.ClassicalPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipeCreator;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipeSchemaComputer;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionEvaluationRecipeProxyRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesBasicService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionScoringRecipeCreator;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionScoringRecipeProxyRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionScoringRecipeSchemaComputer;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionTrainingRecipeProxyRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipeCreator;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipeParams;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.pipeline.PredictionScoringRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MLRecipeDataLineage;
import com.dataiku.dip.recipes.MetaWithFixedCodeEnv;
import com.dataiku.dip.recipes.MetaWithModelCodeEnv;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithFixedCodeEnv;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class PredictionRecipesMeta {
    public static final TrainingRecipeMeta TRAINING_META = new TrainingRecipeMeta();
    public static final ScoringRecipeMeta SCORING_META = new ScoringRecipeMeta();
    public static final EvaluationRecipeMeta EVALUATION_META = new EvaluationRecipeMeta();
    public static final StandaloneEvaluationRecipeMeta STANDALONE_EVALUATION_META = new StandaloneEvaluationRecipeMeta();

    private PredictionRecipesMeta() {
    }

    public static class TrainingRecipeMeta
    extends RecipeMeta
    implements MetaWithFixedCodeEnv {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return ContainerRecipeParams.class;
        }

        @Override
        public String getType() {
            return "prediction_training";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new PredictionTrainingRecipeProxyRunner(activity);
        }

        @Override
        public boolean isInputRoleAvailableForPayload(RecipeDesc.IORoleDef role, String payload) {
            assert (payload != null);
            AbstractPredictionTrainingRecipePayloadParams trainingRecipePayload = (AbstractPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, AbstractPredictionTrainingRecipePayloadParams.class);
            switch (role.name) {
                case "data": {
                    return trainingRecipePayload.needsInputDataFolder;
                }
                case "test": {
                    return SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_TWO_DATASETS.equals((Object)trainingRecipePayload.splitParams.ttPolicy);
                }
            }
            throw new IllegalArgumentException(String.format("Rules for availability of input role %s not implemented", role.name));
        }

        @Override
        public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
            return RecipeMeta.OutputSchemaComputability.NONE;
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) throws Exception {
            return new MLFlowUtils.PredictionTrainingRecipeStatusComputer(recipe, payload);
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            RecipeDesc desc = RecipeDesc.newSisoDesc("prediction training", null);
            RecipeDesc.IORoleDef dataRole = RecipeDesc.IORoleDef.newUnaryRequiredFolder("data", "Data");
            dataRole.availabilityDependsOnPayload = true;
            desc.inputRoles.add(dataRole);
            RecipeDesc.IORoleDef testDatasetInput = RecipeDesc.IORoleDef.newUnaryRequiredDataset("test", "Test");
            testDatasetInput.availabilityDependsOnPayload = true;
            desc.inputRoles.add(testDatasetInput);
            RecipeDesc.IORoleDef model = desc.outputRoles.get(0).withEditable(false, false);
            model.acceptsDataset = false;
            model.acceptsSavedModel = true;
            desc.copiable = false;
            return desc;
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            ClassicalPredictionTrainingRecipePayloadParams params = (ClassicalPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, ClassicalPredictionTrainingRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            ClassicalPredictionTrainingRecipePayloadParams params = (ClassicalPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, ClassicalPredictionTrainingRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            ClassicalPredictionTrainingRecipePayloadParams params = (ClassicalPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, ClassicalPredictionTrainingRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }

        @Override
        public Class<? extends ParamsWithFixedCodeEnv> getCodeEnvBearingParamsClass() {
            return AbstractPredictionTrainingRecipePayloadParams.class;
        }

        @Override
        public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, @Nullable String payload) {
            ClassicalPredictionTrainingRecipePayloadParams params = (ClassicalPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, ClassicalPredictionTrainingRecipePayloadParams.class);
            return params.preprocessing.getUsedConnections();
        }

        @Override
        public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, @Nullable String payload, Map<String, String> replacements) {
            ClassicalPredictionTrainingRecipePayloadParams params = (ClassicalPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, ClassicalPredictionTrainingRecipePayloadParams.class);
            params.preprocessing.remapConnections(replacements);
            return params;
        }
    }

    public static class ScoringRecipeMeta
    extends RecipeMeta
    implements MetaWithModelCodeEnv,
    MLRecipeDataLineage {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return ContainerRecipeParams.class;
        }

        @Override
        public String getType() {
            return "prediction_scoring";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new PredictionScoringRecipeProxyRunner(activity);
        }

        @Override
        public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
            return RecipeMeta.OutputSchemaComputability.RELIABLE_DYNAMIC;
        }

        @Override
        public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
            return new PredictionScoringRecipeSchemaComputer(authCtx, activity);
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String paylod) throws Exception {
            return new MLFlowUtils.PredictionScoringRecipeStatusComputer(recipe, paylod);
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            RecipeDesc desc = RecipeDesc.newSisoDesc("prediction scoring", null);
            desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredModel("model", "Model"));
            RecipeDesc.IORoleDef dataRole = RecipeDesc.IORoleDef.newUnaryRequiredFolder("data", "Data");
            dataRole.availabilityDependsOnPayload = true;
            desc.inputRoles.add(dataRole);
            desc.isMultiEngine = true;
            return desc;
        }

        @Override
        public boolean isInputRoleAvailableForPayload(RecipeDesc.IORoleDef role, String payload) {
            assert (payload != null);
            AbstractPredictionScoringRecipePayloadParams scoringRecipePayload = (AbstractPredictionScoringRecipePayloadParams)JSON.parse((String)payload, AbstractPredictionScoringRecipePayloadParams.class);
            switch (role.name) {
                case "data": {
                    return scoringRecipePayload.needsInputDataFolder;
                }
            }
            throw new IllegalArgumentException(String.format("Rules for availability of input role %s not implemented", role.name));
        }

        @Override
        public RecipeCreator buildCreator(AuthCtx authCtx) {
            return new PredictionScoringRecipeCreator(authCtx, this);
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            TabularPredictionScoringRecipePayloadParams params = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            TabularPredictionScoringRecipePayloadParams params = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setEngine(SerializedRecipe sr, String payload, String engine) {
            TabularPredictionScoringRecipePayloadParams params = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
            params.engineType = engine;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            TabularPredictionScoringRecipePayloadParams params = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
            return new PredictionScoringRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
        }

        @Override
        public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
            ResolvedPreprocessingParams preprocessingParams;
            Schema predictionOutputColumns;
            PredictionModelDetails details;
            if (predecessors.datasets.isEmpty() || successors.datasets.isEmpty() || predecessors.savedModels.isEmpty()) {
                return new RecipeLineage();
            }
            this.checkInputArguments(predecessors, "Scoring");
            Preconditions.checkArgument((successors.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Scoring recipe can have only one output dataset");
            SavedModel savedModel = predecessors.savedModels.get(0);
            FullModelId fmid = new FullModelId(savedModel.projectKey, savedModel.id, savedModel.activeVersion);
            SerializedDataset inputDataset = predecessors.datasets.get(0);
            SerializedDataset outputDataset = successors.datasets.get(0);
            PredictionRecipesBasicService predictionService = new PredictionRecipesBasicService();
            try {
                details = PredictionResultsReader.makeModelDetails(fmid);
                TabularPredictionScoringRecipePayloadParams params = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
                predictionOutputColumns = predictionService.getColumnsToAddForPrediction(params, details, savedModel);
                preprocessingParams = fmid.getResolvedPreprocessingParams();
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Scoring Recipe: Failed to fetch model params and details", (Throwable)e);
            }
            return this.getRecipeLineage(inputDataset, outputDataset, predictionOutputColumns, details, preprocessingParams);
        }

        public RecipeLineage getRecipeLineage(SerializedDataset inputDataset, SerializedDataset outputDataset, Schema predictionOutputColumns, PredictionModelDetails details, ResolvedPreprocessingParams preprocessingParams) {
            String inputDatasetName = inputDataset.getFullName();
            String outputDatasetName = outputDataset.getFullName();
            DatasetPairLineage datasetPairLineage = new DatasetPairLineage(inputDatasetName, inputDataset.getSchema(), outputDatasetName, outputDataset.getSchema());
            datasetPairLineage.initializeDirectColumnRelations();
            RecipeLineage recipeLineage = new RecipeLineage(inputDatasetName, outputDatasetName, datasetPairLineage);
            ShakerRecipeMeta shakerMeta = new ShakerRecipeMeta();
            try {
                recipeLineage = shakerMeta.getRecipeLineageFromSteps(details.trainedWithScript.steps, recipeLineage);
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Scoring Recipe: Failed to compute script lineage", (Throwable)e);
            }
            List<SchemaColumn> metadataColumns = ScoringRecipeUtils.ModelMetadataUtils.getModelMetadataSchemaColumns();
            for (SchemaColumn column : metadataColumns) {
                predictionOutputColumns.removeColumn(column.getName());
            }
            DatasetPairLineage finalDatasetPairLineage = recipeLineage.getDatasetPairLineage(inputDatasetName, outputDatasetName);
            for (Map.Entry<String, FeaturePreprocessingParams> entry : preprocessingParams.per_feature.entrySet()) {
                String featureName = entry.getKey();
                FeaturePreprocessingParams featurePreprocessingParams = entry.getValue();
                if (!this.shouldIncludeInLineage(featurePreprocessingParams, details) || !recipeLineage.getDatasetPairLineage(inputDatasetName, outputDatasetName).getOutputColumns().contains(featureName)) continue;
                predictionOutputColumns.columns.forEach(col -> finalDatasetPairLineage.addFactorizedColumnRelations(featureName, col.getName()));
            }
            recipeLineage.keepValidRelations();
            return recipeLineage;
        }
    }

    public static class EvaluationRecipeMeta
    extends RecipeMeta
    implements MetaWithModelCodeEnv,
    MLRecipeDataLineage {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return ContainerRecipeParams.class;
        }

        @Override
        public String getType() {
            return "evaluation";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new PredictionEvaluationRecipeProxyRunner(activity);
        }

        @Override
        public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
            return RecipeMeta.OutputSchemaComputability.RELIABLE_DYNAMIC;
        }

        @Override
        public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
            return new EvaluationRecipeSchemaComputer(authCtx, activity);
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) throws Exception {
            return new MLFlowUtils.EvaluationRecipeStatusComputer(recipe, payload);
        }

        @Override
        public boolean isInputRoleAvailableForPayload(RecipeDesc.IORoleDef role, String payload) {
            assert (payload != null);
            AbstractPredictionScoringRecipePayloadParams evaluationRecipePayload = (AbstractPredictionScoringRecipePayloadParams)JSON.parse((String)payload, AbstractPredictionScoringRecipePayloadParams.class);
            if ("data".equals(role.name)) {
                return evaluationRecipePayload.needsInputDataFolder;
            }
            return true;
        }

        @Override
        public boolean isOutputRoleAvailableForPayload(RecipeDesc.IORoleDef role, String payload) {
            assert (payload != null);
            AbstractPredictionScoringRecipePayloadParams evaluationRecipePayload = (AbstractPredictionScoringRecipePayloadParams)JSON.parse((String)payload, AbstractPredictionScoringRecipePayloadParams.class);
            switch (role.name) {
                case "evaluationStore": {
                    if (evaluationRecipePayload.predictionType == null) {
                        return true;
                    }
                    HashSet predTypesSupportingMES = Sets.newHashSet((Object[])new PredictionMLTask.PredictionType[]{PredictionMLTask.PredictionType.BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.REGRESSION, PredictionMLTask.PredictionType.MULTICLASS, PredictionMLTask.PredictionType.TIMESERIES_FORECAST});
                    return predTypesSupportingMES.contains((Object)evaluationRecipePayload.predictionType);
                }
            }
            throw new IllegalArgumentException(String.format("Rules for availability of output role %s not implemented", role.name));
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            RecipeDesc desc = new RecipeDesc("evaluation", null);
            desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredDataset("main", "Evaluation Dataset"));
            desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredModel("model", "Model"));
            RecipeDesc.IORoleDef dataRole = RecipeDesc.IORoleDef.newUnaryRequiredFolder("data", "Data");
            dataRole.availabilityDependsOnPayload = true;
            desc.inputRoles.add(dataRole);
            desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("main", "Output Dataset"));
            desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("metrics", "Metrics"));
            RecipeDesc.IORoleDef mes = RecipeDesc.IORoleDef.newUnaryModelEvaluationStore("evaluationStore", "Evaluation store");
            mes.availabilityDependsOnPayload = true;
            desc.outputRoles.add(mes);
            return desc;
        }

        @Override
        public RecipeCreator buildCreator(AuthCtx authCtx) {
            return new EvaluationRecipeCreator(authCtx, this);
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            EvaluationRecipePayloadParams params = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            EvaluationRecipePayloadParams params = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            EvaluationRecipePayloadParams params = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
            ResolvedPreprocessingParams preprocessingParams;
            Schema predictionOutputColumns;
            PredictionModelDetails details;
            if (predecessors.datasets.isEmpty() || successors.datasets.isEmpty() || predecessors.savedModels.isEmpty()) {
                return new RecipeLineage();
            }
            this.checkInputArguments(predecessors, "Evaluation");
            Preconditions.checkArgument((serializedRecipe.getOutputsForRole("main").size() <= 1 ? 1 : 0) != 0, (Object)"Evaluation recipe can have only one output main dataset");
            Preconditions.checkArgument((serializedRecipe.getOutputsForRole("metrics").size() <= 1 ? 1 : 0) != 0, (Object)"Evaluation recipe can have only one output metrics dataset");
            SavedModel savedModel = predecessors.savedModels.get(0);
            FullModelId fmid = new FullModelId(savedModel.projectKey, savedModel.id, savedModel.activeVersion);
            SerializedDataset inputDataset = predecessors.datasets.get(0);
            EvaluationRecipePayloadParams params = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            SerializedDataset outputMainDataset = null;
            SerializedDataset outputMetricsDataset = null;
            PredictionRecipesBasicService predictionService = new PredictionRecipesBasicService();
            try {
                details = PredictionResultsReader.makeModelDetails(fmid);
                predictionOutputColumns = predictionService.getColumnsToAddForPrediction(params, details, savedModel);
                preprocessingParams = fmid.getResolvedPreprocessingParams();
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Evaluation Recipe: Failed to fetch prediction columns", (Throwable)e);
            }
            List<SerializedRecipe.RecipeOutput> metricsOutput = serializedRecipe.getOutputsForRole("metrics");
            List<SerializedRecipe.RecipeOutput> mainOutput = serializedRecipe.getOutputsForRole("main");
            for (SerializedDataset sd : successors.datasets) {
                if (mainOutput.size() == 1 && sd.name.equals(mainOutput.get((int)0).ref)) {
                    outputMainDataset = sd;
                    continue;
                }
                if (metricsOutput.size() != 1 || !sd.name.equals(metricsOutput.get((int)0).ref)) continue;
                outputMetricsDataset = sd;
            }
            if (outputMainDataset != null) {
                Schema mainDatasetSchema = outputMainDataset.getSchema();
                HashSet<String> outputMainMLColumns = new HashSet<String>(params.outputs);
                for (SchemaColumn schemaColumn : mainDatasetSchema.getColumns()) {
                    if (!outputMainMLColumns.contains(schemaColumn.getName()) || predictionOutputColumns.hasColumn(schemaColumn.getName())) continue;
                    predictionOutputColumns.addColumn(schemaColumn);
                }
            }
            return this.getRecipeLineage(inputDataset, params, outputMainDataset, outputMetricsDataset, predictionOutputColumns, details, preprocessingParams);
        }

        public RecipeLineage getRecipeLineage(SerializedDataset inputDataset, EvaluationRecipePayloadParams params, SerializedDataset outputMainDataset, SerializedDataset outputMetricsDataset, Schema predictionOutputColumns, PredictionModelDetails details, ResolvedPreprocessingParams preprocessingParams) {
            String inputDatasetName = inputDataset.getFullName();
            DatasetPairLineage datasetPairLineage = new DatasetPairLineage(inputDatasetName, inputDataset.getSchema(), null, null);
            datasetPairLineage.initializeDirectColumnRelations();
            RecipeLineage recipeLineage = new RecipeLineage(inputDatasetName, null, datasetPairLineage);
            ShakerRecipeMeta shakerMeta = new ShakerRecipeMeta();
            try {
                recipeLineage = shakerMeta.getRecipeLineageFromSteps(details.trainedWithScript.steps, recipeLineage);
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Evaluation Recipe: Failed to compute script lineage", (Throwable)e);
            }
            DatasetPairLineage intermediateDatasetPairLineage = recipeLineage.getDatasetPairLineage(inputDatasetName, null);
            recipeLineage.deleteDatasetPairLineage(inputDatasetName, null);
            this.updateOutputMainDatasetLineage(outputMainDataset, preprocessingParams, predictionOutputColumns, details, intermediateDatasetPairLineage, recipeLineage, inputDatasetName);
            this.updateOutputMetricsDatasetLineage(outputMetricsDataset, preprocessingParams, inputDatasetName, details, intermediateDatasetPairLineage, recipeLineage, params);
            recipeLineage.keepValidRelations();
            return recipeLineage;
        }

        private void updateOutputMainDatasetLineage(SerializedDataset outputMainDataset, ResolvedPreprocessingParams preprocessingParams, Schema predictionOutputColumns, PredictionModelDetails details, DatasetPairLineage intermediateDatasetPairLineage, RecipeLineage recipeLineage, String inputDatasetName) {
            if (outputMainDataset == null) {
                return;
            }
            String outputMainDatasetName = outputMainDataset.getFullName();
            DatasetPairLineage datasetPairLineage = new DatasetPairLineage(intermediateDatasetPairLineage);
            datasetPairLineage.setOutputDataset(outputMainDatasetName, outputMainDataset.getSchema());
            recipeLineage.setDatasetPairLineage(inputDatasetName, outputMainDatasetName, datasetPairLineage);
            for (Map.Entry<String, FeaturePreprocessingParams> entry : preprocessingParams.per_feature.entrySet()) {
                String featureName = entry.getKey();
                FeaturePreprocessingParams featurePreprocessingParams = entry.getValue();
                if (!this.shouldIncludeInLineage(featurePreprocessingParams, details) || !datasetPairLineage.getOutputColumns().contains(featureName)) continue;
                predictionOutputColumns.columns.forEach(col -> datasetPairLineage.addFactorizedColumnRelations(featureName, col.getName()));
            }
        }

        private void updateOutputMetricsDatasetLineage(SerializedDataset outputMetricsDataset, ResolvedPreprocessingParams preprocessingParams, String inputDatasetName, PredictionModelDetails details, DatasetPairLineage intermediateDatasetPairLineage, RecipeLineage recipeLineage, EvaluationRecipePayloadParams params) {
            if (outputMetricsDataset == null) {
                return;
            }
            String outputMetricsDatasetName = outputMetricsDataset.getFullName();
            DatasetPairLineage datasetPairLineage = new DatasetPairLineage(intermediateDatasetPairLineage);
            datasetPairLineage.setOutputDataset(outputMetricsDatasetName, outputMetricsDataset.getSchema());
            recipeLineage.setDatasetPairLineage(inputDatasetName, outputMetricsDatasetName, datasetPairLineage);
            for (Map.Entry<String, FeaturePreprocessingParams> entry : preprocessingParams.per_feature.entrySet()) {
                String featureName = entry.getKey();
                FeaturePreprocessingParams featurePreprocessingParams = entry.getValue();
                boolean includeFeature = this.shouldIncludeInLineage(featurePreprocessingParams, details) || details instanceof CausalPredictionModelDetails && featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TREATMENT) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TARGET);
                if (!includeFeature) continue;
                for (String metric : params.metrics) {
                    if (!outputMetricsDataset.getSchema().hasColumn(metric)) continue;
                    datasetPairLineage.addFactorizedColumnRelations(featureName, metric);
                }
            }
        }
    }

    public static class StandaloneEvaluationRecipeMeta
    extends RecipeMeta
    implements MetaWithSelectableCodeEnv {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return StandaloneEvaluationRecipeParams.class;
        }

        @Override
        public String getType() {
            return "standalone_evaluation";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new StandaloneEvaluationRecipeRunner(activity);
        }

        @Override
        public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
            return RecipeMeta.OutputSchemaComputability.NONE;
        }

        @Override
        public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
            return null;
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String paylod) throws Exception {
            return new MLFlowUtils.StandaloneEvaluationRecipeStatusComputer(recipe, paylod);
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            RecipeDesc desc = RecipeDesc.newSisoDesc("standalone_evaluation", null);
            RecipeDesc.IORoleDef evaluationDataset = desc.inputRoles.get(0);
            evaluationDataset.label = "Evaluation Dataset";
            desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("reference", "Reference Dataset"));
            RecipeDesc.IORoleDef evaluationDataRole = RecipeDesc.IORoleDef.newUnaryFolder("data", "Evaluation Data");
            desc.inputRoles.add(evaluationDataRole);
            RecipeDesc.IORoleDef referenceDataRole = RecipeDesc.IORoleDef.newUnaryFolder("referenceData", "Reference Data");
            desc.inputRoles.add(referenceDataRole);
            RecipeDesc.IORoleDef mes = desc.outputRoles.get(0);
            mes.acceptsDataset = false;
            mes.acceptsModelEvaluationStore = true;
            mes.label = "Evaluation Store";
            return desc;
        }

        @Override
        public RecipeCreator buildCreator(AuthCtx authCtx) {
            return new StandaloneEvaluationRecipeCreator(authCtx, this);
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            StandaloneEvaluationRecipePayloadParams params = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)payload, StandaloneEvaluationRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            StandaloneEvaluationRecipePayloadParams params = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)payload, StandaloneEvaluationRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            StandaloneEvaluationRecipePayloadParams params = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)payload, StandaloneEvaluationRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }
    }
}

