/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.spark;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.spark.SparklingAlgorithmMeta;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import java.util.ArrayList;
import java.util.List;

public class SparklingNBMeta
extends SparklingAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Naive Bayes (H2O)";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        return new ModelTrainInfo.PreSearchDescription(rpmp).withSVParam("smoothing", Float.valueOf(rpmp.nb_sparkling_grid.laplace)).withSVParam("min_std", Float.valueOf(rpmp.nb_sparkling_grid.min_std_dev));
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        return new ModelTrainInfo.PostSearchDescription().withSVParam("smoothing", Float.valueOf(before.nb_sparkling_grid.laplace)).withSVParam("min_std", Float.valueOf(before.nb_sparkling_grid.min_std_dev));
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        if (pmp.nb_sparkling == null || !pmp.nb_sparkling.enabled) {
            return;
        }
        pmp.nb_sparkling.validate();
        checks.addWarningSparse("Naive Bayes (H2O)");
        for (FeaturePreprocessingParams par : task.getPreprocessingParams().per_feature.values()) {
            if (par.role != FeaturePreprocessingParams.Role.INPUT || par.type == FeaturePreprocessingParams.FeatureType.CATEGORY && ((CatFeaturePreprocessingParams)par).category_handling == CatFeaturePreprocessingParams.CategoryHandlingMethod.NONE) continue;
            checks.addWarning("Non-categorical in Naive Bayes", "You have selected non-categorical features, or have chosen a method other than 'Let H2O handle the feature' for a categorical feature. This is not supported for Naive Bayes and may lead to errors.");
            break;
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (pmp.nb_sparkling == null || !pmp.nb_sparkling.enabled) {
            return ret;
        }
        PreTrainPredictionModelingParams rcmp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.SPARKLING_NB, pmp);
        rcmp.nb_sparkling_grid = pmp.nb_sparkling;
        ret.add(new WorkSet.ModelingSet(rcmp));
        return ret;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        return this.getCopyWithGridStrategy(usedToTrain);
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.nb_sparkling = preTrain.nb_sparkling_grid;
        target.nb_sparkling.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.nb_sparkling = usedToTrain.nb_sparkling_grid;
        target.nb_sparkling.enabled = true;
    }
}

