/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterParams;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.HadoopOverrideMask;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveOverrideMask;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaOverrideMask;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.SparkOverrideMask;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class Cluster {
    @JSON.FileTransient
    public String id;
    public String type;
    public String name;
    public ClusterArchitecture architecture = ClusterArchitecture.HADOOP;
    public ClusterParams params;
    public ClusterState state = ClusterState.NONE;
    public JsonObject data;
    public String owner;
    public boolean usableByAll;
    public List<PermissionItem> permissions = new ArrayList<PermissionItem>();
    public ClusterOrigin origin;
    public HadoopOverrideMask overrideHadoopSettings = new HadoopOverrideMask();
    public HiveOverrideMask overrideHiveSettings = new HiveOverrideMask();
    public ImpalaOverrideMask overrideImpalaSettings = new ImpalaOverrideMask();
    public SparkOverrideMask overrideSparkSettings = new SparkOverrideMask();
    public ContainerOverrideMask overrideContainerSettings = new ContainerOverrideMask();
    public HadoopSettings hadoopSettings = new HadoopSettings();
    public HiveSettings hiveSettings = new HiveSettings();
    public ImpalaSettings impalaSettings = new ImpalaSettings();
    public SparkSettings sparkSettings = new SparkSettings();
    public ContainerSettings containerSettings = new ContainerSettings();

    public Cluster() {
    }

    public Cluster(Cluster other) {
        this.id = other.id;
        this.type = other.type;
        this.name = other.name;
        this.architecture = other.architecture;
        this.params = other.params;
        this.state = other.state;
        this.data = other.data;
        this.owner = other.owner;
        this.usableByAll = other.usableByAll;
        this.permissions = other.permissions;
        this.origin = other.origin;
        this.overrideHadoopSettings = other.overrideHadoopSettings;
        this.overrideHiveSettings = other.overrideHiveSettings;
        this.overrideImpalaSettings = other.overrideImpalaSettings;
        this.overrideSparkSettings = other.overrideSparkSettings;
        this.overrideContainerSettings = other.overrideContainerSettings;
        this.hadoopSettings = other.hadoopSettings;
        this.hiveSettings = other.hiveSettings;
        this.impalaSettings = other.impalaSettings;
        this.sparkSettings = other.sparkSettings;
        this.containerSettings = other.containerSettings;
    }

    public <T extends ClusterParams> T getParamsAs(Class<T> clazz) {
        return (T)((ClusterParams)clazz.cast(this.params));
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        this.hadoopSettings.encryptFields(cryptoService);
        this.hiveSettings.encryptFields(cryptoService);
        this.impalaSettings.encryptFields(cryptoService);
        this.sparkSettings.encryptFields(cryptoService);
        this.containerSettings.encryptFields(cryptoService);
    }

    public static void registerAdapter() {
        JSON.registerAdapter(Cluster.class, (Object)new JsonDeserializer<Cluster>(){

            public Cluster deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonType;
                JsonElement jsonData;
                JsonElement jsonState;
                JsonElement jsonContainerSettings;
                JsonElement jsonSparkSettings;
                JsonElement jsonImpalaSettings;
                JsonElement jsonHiveSettings;
                JsonElement jsonHadoopSettings;
                JsonElement jsonOverrideContainerSettings;
                JsonElement jsonOverrideSparkSettings;
                JsonElement jsonOverrideImpalaSettings;
                JsonElement jsonOverrideHiveSettings;
                JsonElement jsonOverrideHadoopSettings;
                JsonElement jsonOrigin;
                JsonElement jsonPermissions;
                JsonElement jsonUsableByAll;
                JsonElement jsonOwner;
                JsonElement jsonArchitecture;
                JsonElement jsonName;
                JsonObject jsonObj = json.getAsJsonObject();
                Cluster cluster = new Cluster();
                JsonElement jsonId = jsonObj.get("id");
                if (jsonId != null && !jsonId.isJsonNull()) {
                    cluster.id = jsonId.getAsString();
                }
                if ((jsonName = jsonObj.get("name")) != null && !jsonName.isJsonNull()) {
                    cluster.name = jsonName.getAsString();
                }
                if ((jsonArchitecture = jsonObj.get("architecture")) != null && !jsonArchitecture.isJsonNull()) {
                    cluster.architecture = (ClusterArchitecture)((Object)ctx.deserialize(jsonArchitecture, ClusterArchitecture.class));
                }
                if ((jsonOwner = jsonObj.get("owner")) != null && !jsonOwner.isJsonNull()) {
                    cluster.owner = jsonOwner.getAsString();
                }
                if ((jsonUsableByAll = jsonObj.get("usableByAll")) != null && !jsonUsableByAll.isJsonNull()) {
                    cluster.usableByAll = jsonUsableByAll.getAsBoolean();
                }
                if ((jsonPermissions = jsonObj.get("permissions")) != null && !jsonPermissions.isJsonNull()) {
                    cluster.permissions = (List)ctx.deserialize(jsonPermissions, new TypeToken<List<PermissionItem>>(){}.getType());
                }
                if ((jsonOrigin = jsonObj.get("origin")) != null && !jsonOrigin.isJsonNull()) {
                    cluster.origin = (ClusterOrigin)ctx.deserialize(jsonOrigin, new TypeToken<ClusterOrigin>(){}.getType());
                }
                if ((jsonOverrideHadoopSettings = jsonObj.get("overrideHadoopSettings")) != null && !jsonOverrideHadoopSettings.isJsonNull()) {
                    cluster.overrideHadoopSettings = (HadoopOverrideMask)ctx.deserialize(jsonOverrideHadoopSettings, new TypeToken<HadoopOverrideMask>(){}.getType());
                }
                if ((jsonOverrideHiveSettings = jsonObj.get("overrideHiveSettings")) != null && !jsonOverrideHiveSettings.isJsonNull()) {
                    cluster.overrideHiveSettings = (HiveOverrideMask)ctx.deserialize(jsonOverrideHiveSettings, new TypeToken<HiveOverrideMask>(){}.getType());
                }
                if ((jsonOverrideImpalaSettings = jsonObj.get("overrideImpalaSettings")) != null && !jsonOverrideImpalaSettings.isJsonNull()) {
                    cluster.overrideImpalaSettings = (ImpalaOverrideMask)ctx.deserialize(jsonOverrideImpalaSettings, new TypeToken<ImpalaOverrideMask>(){}.getType());
                }
                if ((jsonOverrideSparkSettings = jsonObj.get("overrideSparkSettings")) != null && !jsonOverrideSparkSettings.isJsonNull()) {
                    cluster.overrideSparkSettings = (SparkOverrideMask)ctx.deserialize(jsonOverrideSparkSettings, new TypeToken<SparkOverrideMask>(){}.getType());
                }
                if ((jsonOverrideContainerSettings = jsonObj.get("overrideContainerSettings")) != null && !jsonOverrideContainerSettings.isJsonNull()) {
                    cluster.overrideContainerSettings = (ContainerOverrideMask)ctx.deserialize(jsonOverrideContainerSettings, new TypeToken<ContainerOverrideMask>(){}.getType());
                }
                if ((jsonHadoopSettings = jsonObj.get("hadoopSettings")) != null && !jsonHadoopSettings.isJsonNull()) {
                    cluster.hadoopSettings = (HadoopSettings)ctx.deserialize(jsonHadoopSettings, new TypeToken<HadoopSettings>(){}.getType());
                }
                if ((jsonHiveSettings = jsonObj.get("hiveSettings")) != null && !jsonHiveSettings.isJsonNull()) {
                    cluster.hiveSettings = (HiveSettings)ctx.deserialize(jsonHiveSettings, new TypeToken<HiveSettings>(){}.getType());
                }
                if ((jsonImpalaSettings = jsonObj.get("impalaSettings")) != null && !jsonImpalaSettings.isJsonNull()) {
                    cluster.impalaSettings = (ImpalaSettings)ctx.deserialize(jsonImpalaSettings, new TypeToken<ImpalaSettings>(){}.getType());
                }
                if ((jsonSparkSettings = jsonObj.get("sparkSettings")) != null && !jsonSparkSettings.isJsonNull()) {
                    cluster.sparkSettings = (SparkSettings)ctx.deserialize(jsonSparkSettings, new TypeToken<SparkSettings>(){}.getType());
                }
                if ((jsonContainerSettings = jsonObj.get("containerSettings")) != null && !jsonContainerSettings.isJsonNull()) {
                    cluster.containerSettings = (ContainerSettings)ctx.deserialize(jsonContainerSettings, new TypeToken<ContainerSettings>(){}.getType());
                }
                if ((jsonState = jsonObj.get("state")) != null && !jsonState.isJsonNull()) {
                    cluster.state = ClusterState.valueOf(jsonState.getAsString());
                }
                if ((jsonData = jsonObj.get("data")) != null && !jsonData.isJsonNull()) {
                    cluster.data = jsonData.getAsJsonObject();
                }
                cluster.type = (jsonType = jsonObj.get("type")) != null && !jsonType.isJsonNull() ? jsonType.getAsString() : "manual";
                JsonElement jsonParams = jsonObj.get("params");
                if (jsonParams != null) {
                    cluster.params = (ClusterParams)ctx.deserialize(jsonParams, ClusterRegistry.getMeta(cluster).paramsClass());
                }
                return cluster;
            }
        });
    }

    public static enum ClusterArchitecture {
        HADOOP,
        KUBERNETES;

    }

    public static enum ClusterState {
        NONE,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static class ClusterOrigin {
        public ClusterOriginType type;
        public String identifier;
        public String scenarioProjectKey;
        public String scenarioId;
        public String scenarioRunId;
        public boolean ownedByScenario;

        public static ClusterOrigin makeManual(AuthCtx authCtx) {
            ClusterOrigin origin = new ClusterOrigin();
            origin.type = ClusterOriginType.MANUAL;
            origin.identifier = authCtx.getIdentifier();
            return origin;
        }

        public static ClusterOrigin makeScenarioRun(ScenarioRun scenarioRun, boolean ownedByScenario) {
            ClusterOrigin origin = new ClusterOrigin();
            origin.type = ClusterOriginType.SCENARIO;
            origin.scenarioProjectKey = scenarioRun.getScenario().getProjectKey();
            origin.scenarioId = scenarioRun.getScenario().getId();
            origin.scenarioRunId = scenarioRun.getRunId();
            origin.ownedByScenario = ownedByScenario;
            return origin;
        }
    }

    public static enum ClusterOriginType {
        MANUAL,
        SCENARIO;

    }

    public static class PermissionItem {
        public String group;
        public boolean use;
        public boolean manageUsers;
        public boolean update;

        public PermissionItem() {
        }

        public PermissionItem(PermissionItem key) {
            this.group = key.group;
            this.update = key.update;
            this.use = key.use;
            this.manageUsers = key.manageUsers;
        }

        public PermissionItem deepCopy() {
            return new PermissionItem(this);
        }

        public boolean hasSamePrivilegesAs(PermissionItem other) {
            return other.use == this.use && other.manageUsers == this.manageUsers && other.update == this.update;
        }
    }
}

