/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks.component;

import com.dataiku.dip.codestudio.blocks.CodeStudioBlockRegistry;
import com.dataiku.dip.codestudio.blocks.component.LoadedPythonPluginCodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockDesc;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockMeta;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class PythonPluginCodeStudioBlockService
extends CustomPythonElementService<PythonPluginCodeStudioBlockDesc, LoadedPythonPluginCodeStudioBlock> {
    public static final String TYPE_PREFIX = "pycdstdioblk_";

    @Override
    public String getFolderName() {
        return "python-code-studio-blocks";
    }

    @Override
    public String getPrefix() {
        return "codeStudioBlock";
    }

    @Override
    protected String getCodeExtension(LoadedPythonPluginCodeStudioBlock desc) {
        return ".py";
    }

    @Override
    public Class<PythonPluginCodeStudioBlockDesc> getDescClass() {
        return PythonPluginCodeStudioBlockDesc.class;
    }

    @Override
    public Class<LoadedPythonPluginCodeStudioBlock> getLoadedDescClass() {
        return LoadedPythonPluginCodeStudioBlock.class;
    }

    @Override
    protected void removeElement(LoadedPythonPluginCodeStudioBlock desc) {
        CodeStudioBlockRegistry.deregister(desc.elementType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return TYPE_PREFIX + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedPythonPluginCodeStudioBlock load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonPluginCodeStudioBlock loaded = new LoadedPythonPluginCodeStudioBlock(elementId, pluginId, elementType, (PythonPluginCodeStudioBlockDesc)JSON.parseFile((File)file, PythonPluginCodeStudioBlockDesc.class));
        PythonPluginCodeStudioBlockMeta codeStudioMeta = new PythonPluginCodeStudioBlockMeta(pluginId, loaded);
        CodeStudioBlockRegistry.register(codeStudioMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final PythonPluginCodeStudioBlockDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, PythonPluginCodeStudioBlockService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

