/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.auth.oauth2.TokenResponse;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.AccessToken;
import java.io.IOException;
import java.util.Date;

public class GoogleCredentialCache {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawTokenResponse getTokenFromMetadataServer() throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        try {
            RawTokenResponse rawTokenResponse;
            HttpGet get = new HttpGet(OAuth2Utils.getMetadataServerUrl() + "/computeMetadata/v1/instance/service-accounts/default/token");
            get.setHeader("Metadata-Flavor", "Google");
            CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
            try {
                rawTokenResponse = (RawTokenResponse)HTTPClientUtils.handleJSONResp((HttpResponse)resp, RawTokenResponse.class, HTTPClientUtils::handleAPIError);
            }
            catch (Throwable throwable) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return rawTokenResponse;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private GoogleCredentialCache() {
    }

    public static class RawTokenResponse {
        public String access_token;
        public String refresh_token;
        public long expires_in;
        public String token_type;

        public TokenResponse toTokenResponse() {
            return new TokenResponse().setAccessToken(this.access_token).setRefreshToken(this.refresh_token).setTokenType(this.token_type).setExpiresInSeconds(Long.valueOf(this.expires_in));
        }

        public AccessToken toAccessToken() {
            long expiresAtMilliseconds = System.currentTimeMillis() + this.expires_in * 1000L;
            return new AccessToken(this.access_token, new Date(expiresAtMilliseconds));
        }
    }
}

