/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.license.TrialToken;
import com.dataiku.dip.onboarding.OnboardingQuestionnaire;
import com.dataiku.dip.onboarding.PageSpecificTourSettings;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.ATSurveyService;
import com.dataiku.dip.server.services.NPSSurveyService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.util.PasswordUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public interface UsersDAO {
    public List<User> listUsers() throws IOException;

    public List<User> listUsersUnsafe() throws IOException;

    public List<Group> listGroups() throws IOException;

    public List<Group> listGroupsUnsafe() throws IOException;

    public User getOrNull(String var1) throws IOException;

    public User getOrNullUnsafe(String var1) throws IOException;

    public User getMandatory(String var1) throws IOException;

    public User getMandatoryUnsafe(String var1) throws IOException;

    public User getUserIgnoreCaseOrNull(String var1) throws IOException;

    public Group getGroup(String var1) throws IOException;

    public Group getGroupUnsafe(String var1) throws IOException;

    public Group getGroupMandatory(String var1) throws IOException;

    public Group getGroupMandatoryUnsafe(String var1) throws IOException;

    public Group getDefaultAdminGroup(boolean var1) throws IOException, CodedException;

    public Group addGroup(String var1, UserSourceType var2) throws IOException, CodedException;

    public Group addGroup(Group var1) throws IOException, CodedException;

    public GroupDiff saveGroup(Group var1) throws IOException;

    public void deleteGroup(String var1) throws IOException;

    public boolean checkLogin(String var1, String var2) throws IOException, CodedException;

    public boolean checkLoginIgnoreCase(String var1, String var2) throws IOException, CodedException;

    default public User addUser(String login, String password) throws IOException, CodedException {
        if (this.getOrNull(login) != null) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_USER_EXISTS, "User '" + login + "' already exists");
        }
        User user = new User(login, password);
        user.creationDate = System.currentTimeMillis();
        this.saveUser(user);
        return user;
    }

    default public void addForeignUser(User user) throws IOException, CodedException {
        if (this.getOrNull(user.login) != null) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_USER_EXISTS, "User '" + user.login + "' already exists");
        }
        user.creationDate = System.currentTimeMillis();
        this.saveUser(user);
    }

    public UserDiff saveUser(User var1) throws IOException;

    public void deleteUser(String var1) throws IOException;

    public void forceDeleteUser(String var1) throws IOException;

    public List<PublicUser> getPublicUsers(Collection<String> var1) throws IOException;

    public PublicUser getPublicUser(String var1) throws IOException;

    public InputStream getUserPicture(String var1, String var2) throws IOException;

    public void setUserPicture(String var1, InputStream var2, String var3) throws IOException;

    public void clearUserPictures(String var1) throws IOException;

    public static class User
    implements DkuUser {
        static final int PASSWORD_MIN_LENGTH = 5;
        public String login;
        public String displayName;
        public String email;
        public Long creationDate;
        public List<String> groups = new ArrayList<String>();
        public UserSourceType sourceType = UserSourceType.LOCAL;
        public String userProfile;
        public boolean enabled = true;
        public boolean welcomeEmailSent = false;
        private String password;
        public Map<String, ICredentialsService.StoredCredential> credentials = new HashMap<String, ICredentialsService.StoredCredential>();
        public JsonObject adminProperties = new JsonObject();
        public JsonObject userProperties = new JsonObject();
        public NPSSurveyService.NPSSurveySettings npsSurveySettings = new NPSSurveyService.NPSSurveySettings();
        public ATSurveyService.ATSurveySettings atSurveySettings = new ATSurveyService.ATSurveySettings();
        public OnboardingQuestionnaire questionnaire = new OnboardingQuestionnaire();
        public PageSpecificTourSettings pageSpecificTourSettings = new PageSpecificTourSettings();
        public List<AbstractSQLConnection.CustomDatabaseProperty> secrets = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public TrialToken trialToken;

        public void setSecurePassword(String pwd) throws CodedException {
            if (this.sourceType != UserSourceType.LOCAL) {
                throw ErrorContext.iae((String)("User is not local: " + this.login));
            }
            this.checkPasswordSecurity(pwd);
            this.password = PasswordUtils.encryptPassword((String)pwd);
        }

        public void checkPasswordSecurity(String pwd) throws CodedException {
            if (StringUtils.isBlank((String)pwd)) {
                throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_NEW_PASSWORD, "Password is required");
            }
            if (pwd.length() < 5) {
                throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_NEW_PASSWORD, "Password is too short. It must be at least 5 characters long");
            }
        }

        public boolean checkPassword(String pwd) throws CodedException {
            return PasswordUtils.verifyPassword((String)pwd, (String)this.password);
        }

        public void setWelcomeEmailSent() {
            this.welcomeEmailSent = true;
        }

        public boolean isWelcomeEmailSent() {
            return this.welcomeEmailSent;
        }

        public boolean onboardingPending() {
            return this.questionnaire.onboardingPending();
        }

        public User() {
        }

        public User(String login, UserSourceType sourceType) {
            this.login = login;
            this.sourceType = sourceType;
        }

        public User(String login, String password) throws CodedException {
            this.login = login;
            this.displayName = login;
            if (password != null) {
                this.setSecurePassword(password);
            }
        }

        public User(UsersService.UIUser u) {
            this.login = u.login;
            this.sourceType = u.sourceType;
            this.displayName = u.displayName;
            this.groups = u.groups;
            this.email = u.email;
            this.npsSurveySettings = u.npsSurveySettings;
            this.atSurveySettings = u.atSurveySettings;
            this.enabled = u.enabled;
            this.creationDate = u.creationDate;
            this.userProfile = u.userProfile;
        }

        public String getLogin() {
            return this.login;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getUserProfile() {
            return this.userProfile;
        }

        public void setUserProfile(String userProfile) {
            this.userProfile = userProfile;
        }

        public UserSourceType getUserSourceType() {
            return this.sourceType;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public void addGroupMembership(String group) {
            if (!this.groups.contains(group)) {
                this.groups.add(group);
            }
        }

        public void removeGroupMembership(String group) {
            this.groups.remove(group);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @VisibleForTesting
        public User(User toClone) {
            this.login = toClone.login;
            this.email = toClone.email;
            this.displayName = toClone.displayName;
            this.creationDate = toClone.creationDate;
            this.groups = new ArrayList<String>(toClone.groups);
            this.sourceType = toClone.sourceType;
            this.userProfile = toClone.userProfile;
            this.enabled = toClone.enabled;
            this.password = toClone.password;
            this.credentials = new HashMap<String, ICredentialsService.StoredCredential>(toClone.credentials);
            this.adminProperties = toClone.adminProperties.deepCopy();
            this.userProperties = toClone.userProperties.deepCopy();
            this.npsSurveySettings = new NPSSurveyService.NPSSurveySettings(toClone.npsSurveySettings.state, toClone.npsSurveySettings.nextAction);
            this.atSurveySettings = toClone.atSurveySettings;
            this.secrets = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>(toClone.secrets);
        }

        public String toString() {
            return "User{login='" + this.login + "', displayName='" + this.displayName + "', email='" + this.email + "', groups=" + String.valueOf(this.groups) + ", sourceType=" + String.valueOf(this.sourceType) + ", userProfile='" + this.userProfile + "', enabled=" + this.enabled + "}";
        }
    }

    public static class Group
    extends GroupPermissions
    implements DkuGroup {
        public String name;
        public String description = "";
        public List<String> ldapGroupNames = new ArrayList<String>();
        public List<String> azureADGroupNames = new ArrayList<String>();
        public List<String> ssoGroupNames = new ArrayList<String>();
        public List<String> customGroupNames = new ArrayList<String>();
        public UserSourceType sourceType = UserSourceType.LOCAL;

        public Set<String> getExternalGroupNames() {
            switch (this.sourceType) {
                case LOCAL: 
                case SAAS: 
                case PAM: {
                    return Collections.emptySet();
                }
                case LOCAL_NO_AUTH: {
                    return new HashSet<String>(this.ssoGroupNames);
                }
                case LDAP: {
                    return new HashSet<String>(this.ldapGroupNames);
                }
                case AZURE_AD: {
                    return new HashSet<String>(this.azureADGroupNames);
                }
                case CUSTOM: {
                    return new HashSet<String>(this.customGroupNames);
                }
            }
            return Collections.emptySet();
        }

        public UserSourceType getUserSourceType() {
            return this.sourceType;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Group() {
        }

        public Group(Group group) {
            super(group);
            this.name = group.name;
            this.description = group.description;
            this.sourceType = group.sourceType;
            this.ldapGroupNames = group.ldapGroupNames;
            this.azureADGroupNames = group.azureADGroupNames;
            this.ssoGroupNames = group.ssoGroupNames;
            this.customGroupNames = group.customGroupNames;
        }

        @Override
        public Group deepCopy() {
            return new Group(this);
        }
    }

    @UIModel
    public static class GroupPermissions {
        protected boolean admin;
        protected boolean mayManageUDM;
        protected boolean mayCreateProjects = true;
        protected boolean mayCreateProjectsFromMacros;
        protected boolean mayCreateProjectsFromTemplates;
        protected boolean mayCreateProjectsFromDataikuApps;
        protected boolean mayWriteUnsafeCode;
        protected boolean mayWriteSafeCode;
        protected boolean mayCreateAuthenticatedConnections;
        protected boolean mayCreateCodeEnvs;
        protected boolean mayCreateClusters;
        protected boolean mayCreateCodeStudioTemplates;
        protected boolean mayDevelopPlugins;
        protected boolean mayEditLibFolders;
        protected boolean mayManageCodeEnvs;
        protected boolean mayManageClusters;
        protected boolean mayManageCodeStudioTemplates;
        protected boolean mayViewIndexedHiveConnections;
        protected boolean mayCreatePublishedAPIServices;
        protected boolean mayCreatePublishedProjects;
        protected boolean mayWriteInRootProjectFolder = true;
        protected boolean mayCreateActiveWebContent = true;
        protected boolean mayCreateWorkspaces;
        protected boolean mayShareToWorkspaces = true;
        protected boolean mayCreateDataCollections = true;
        protected boolean mayPublishToDataCollections = true;
        protected boolean mayManageFeatureStore;
        public Boolean dataikerAdmin;
        protected String canObtainAPITicketFromCookiesForGroupsRegex = "";

        public GroupPermissions() {
        }

        public GroupPermissions(GroupPermissions groupPermissions) {
            this.admin = groupPermissions.admin;
            this.mayManageUDM = groupPermissions.mayManageUDM;
            this.mayCreateProjects = groupPermissions.mayCreateProjects;
            this.mayCreateProjectsFromMacros = groupPermissions.mayCreateProjectsFromMacros;
            this.mayCreateProjectsFromTemplates = groupPermissions.mayCreateProjectsFromTemplates;
            this.mayCreateProjectsFromDataikuApps = groupPermissions.mayCreateProjectsFromDataikuApps;
            this.mayWriteUnsafeCode = groupPermissions.mayWriteUnsafeCode;
            this.mayWriteSafeCode = groupPermissions.mayWriteSafeCode;
            this.mayCreateAuthenticatedConnections = groupPermissions.mayCreateAuthenticatedConnections;
            this.mayCreateCodeEnvs = groupPermissions.mayCreateCodeEnvs;
            this.mayCreateClusters = groupPermissions.mayCreateClusters;
            this.mayCreateCodeStudioTemplates = groupPermissions.mayCreateCodeStudioTemplates;
            this.mayDevelopPlugins = groupPermissions.mayDevelopPlugins;
            this.mayEditLibFolders = groupPermissions.mayEditLibFolders;
            this.mayManageCodeEnvs = groupPermissions.mayManageCodeEnvs;
            this.mayManageClusters = groupPermissions.mayManageClusters;
            this.mayManageCodeStudioTemplates = groupPermissions.mayManageCodeStudioTemplates;
            this.mayViewIndexedHiveConnections = groupPermissions.mayViewIndexedHiveConnections;
            this.mayCreatePublishedAPIServices = groupPermissions.mayCreatePublishedAPIServices;
            this.mayCreatePublishedProjects = groupPermissions.mayCreatePublishedProjects;
            this.mayWriteInRootProjectFolder = groupPermissions.mayWriteInRootProjectFolder;
            this.mayCreateActiveWebContent = groupPermissions.mayCreateActiveWebContent;
            this.mayCreateWorkspaces = groupPermissions.mayCreateWorkspaces;
            this.mayShareToWorkspaces = groupPermissions.mayShareToWorkspaces;
            this.mayManageFeatureStore = groupPermissions.mayManageFeatureStore;
            this.mayCreateDataCollections = groupPermissions.mayCreateDataCollections;
            this.mayPublishToDataCollections = groupPermissions.mayPublishToDataCollections;
            this.canObtainAPITicketFromCookiesForGroupsRegex = groupPermissions.canObtainAPITicketFromCookiesForGroupsRegex;
            this.dataikerAdmin = groupPermissions.dataikerAdmin;
        }

        public GroupPermissions deepCopy() {
            return new GroupPermissions(this);
        }

        public GroupPermissions withAdmin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public GroupPermissions getResolved() {
            GroupPermissions resolved = new GroupPermissions();
            resolved.admin = this.isAdmin();
            resolved.mayManageUDM = this.mayManageUDM();
            resolved.mayCreateProjects = this.mayCreateProjects();
            resolved.mayCreateProjectsFromMacros = this.mayCreateProjectsFromMacros();
            resolved.mayCreateProjectsFromTemplates = this.mayCreateProjectsFromTemplates();
            resolved.mayCreateProjectsFromDataikuApps = this.mayCreateProjectsFromDataikuApps();
            resolved.mayManageFeatureStore = this.mayManageFeatureStore();
            resolved.mayWriteUnsafeCode = this.mayWriteUnsafeCode();
            resolved.mayWriteSafeCode = this.mayWriteSafeCode();
            resolved.mayCreateAuthenticatedConnections = this.mayCreateAuthenticatedConnections();
            resolved.mayCreateCodeEnvs = this.mayCreateCodeEnvs();
            resolved.mayCreateClusters = this.mayCreateClusters();
            resolved.mayCreateCodeStudioTemplates = this.mayCreateCodeStudioTemplates();
            resolved.mayDevelopPlugins = this.mayDevelopPlugins();
            resolved.mayEditLibFolders = this.mayEditLibFolders();
            resolved.mayManageCodeEnvs = this.mayManageCodeEnvs();
            resolved.mayManageClusters = this.mayManageClusters();
            resolved.mayManageCodeStudioTemplates = this.mayManageCodeStudioTemplates();
            resolved.mayViewIndexedHiveConnections = this.mayViewIndexedHiveConnections();
            resolved.mayCreatePublishedAPIServices = this.mayCreatePublishedAPIServices();
            resolved.mayCreatePublishedProjects = this.mayCreatePublishedProjects();
            resolved.mayWriteInRootProjectFolder = this.mayWriteInRootProjectFolder();
            resolved.mayCreateActiveWebContent = this.mayCreateActiveWebContent();
            resolved.mayCreateWorkspaces = this.mayCreateWorkspaces();
            resolved.mayShareToWorkspaces = this.mayShareToWorkspaces();
            resolved.mayCreateDataCollections = this.mayCreateDataCollections();
            resolved.mayPublishToDataCollections = this.mayPublishToDataCollections();
            resolved.dataikerAdmin = this.dataikerAdmin;
            resolved.canObtainAPITicketFromCookiesForGroupsRegex = this.canObtainAPITicketFromCookiesForGroupsRegex;
            return resolved;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public boolean mayManageUDM() {
            return this.mayManageUDM || this.admin;
        }

        public boolean mayCreateProjects() {
            return this.mayCreateProjects || this.admin;
        }

        public boolean mayCreateProjectsFromMacros() {
            return this.mayCreateProjectsFromMacros || this.mayCreateProjects || this.admin;
        }

        public boolean mayCreateProjectsFromTemplates() {
            return this.mayCreateProjectsFromTemplates || this.mayCreateProjects || this.admin;
        }

        public boolean mayCreateProjectsFromDataikuApps() {
            return this.mayCreateProjectsFromDataikuApps || this.mayCreateProjects || this.admin;
        }

        public boolean mayMoveProjects() {
            return this.admin;
        }

        public boolean mayManageFeatureStore() {
            return this.mayManageFeatureStore || this.admin;
        }

        public boolean mayCreateCodeEnvs() {
            return this.mayCreateCodeEnvs || this.mayManageCodeEnvs || this.admin;
        }

        public boolean mayCreateClusters() {
            return this.mayCreateClusters || this.mayManageClusters || this.admin;
        }

        public boolean mayCreateCodeStudioTemplates() {
            return this.mayCreateCodeStudioTemplates || this.mayManageCodeStudioTemplates || this.admin;
        }

        public boolean mayWriteUnsafeCode() {
            return this.mayWriteUnsafeCode || this.admin;
        }

        public boolean mayWriteSafeCode() {
            return this.mayWriteSafeCode || this.mayWriteUnsafeCode || this.admin;
        }

        public boolean mayCreateAuthenticatedConnections() {
            return this.mayCreateAuthenticatedConnections || this.admin;
        }

        public boolean mayDevelopPlugins() {
            return this.mayDevelopPlugins || this.admin;
        }

        public boolean mayEditLibFolders() {
            return this.mayEditLibFolders || this.admin;
        }

        public boolean mayManageCodeEnvs() {
            return this.mayManageCodeEnvs || this.admin;
        }

        public boolean mayManageClusters() {
            return this.mayManageClusters || this.admin;
        }

        public boolean mayManageCodeStudioTemplates() {
            return this.mayManageCodeStudioTemplates || this.admin;
        }

        public boolean mayViewIndexedHiveConnections() {
            return this.mayViewIndexedHiveConnections || this.admin;
        }

        public boolean mayCreatePublishedAPIServices() {
            return this.mayCreatePublishedAPIServices || this.admin;
        }

        public boolean mayCreatePublishedProjects() {
            return this.mayCreatePublishedProjects || this.admin;
        }

        public boolean mayWriteInRootProjectFolder() {
            return this.mayWriteInRootProjectFolder || this.admin;
        }

        public boolean mayCreateActiveWebContent() {
            return this.mayCreateActiveWebContent || this.admin;
        }

        public boolean mayCreateWorkspaces() {
            return this.mayCreateWorkspaces || this.admin;
        }

        public boolean mayShareToWorkspaces() {
            return this.mayShareToWorkspaces || this.admin;
        }

        public boolean mayCreateDataCollections() {
            return this.mayCreateDataCollections || this.admin;
        }

        public boolean mayPublishToDataCollections() {
            return this.mayPublishToDataCollections || this.admin;
        }

        public String canObtainAPITicketFromCookiesForGroupsRegex() {
            return this.canObtainAPITicketFromCookiesForGroupsRegex;
        }

        public void setMayWriteUnsafeCode(boolean may) {
            this.mayWriteUnsafeCode = may;
        }

        public void setMayWriteSafeCode(boolean may) {
            this.mayWriteSafeCode = may;
        }

        public void setMayCreateAuthenticatedConnections(boolean may) {
            this.mayCreateAuthenticatedConnections = may;
        }

        public void setMayViewIndexedHiveConnections(boolean may) {
            this.mayViewIndexedHiveConnections = may;
        }

        public void setAdmin(boolean admin) {
            this.admin = admin;
        }

        public GroupPermissions union(GroupPermissions permissions) {
            GroupPermissions result = new GroupPermissions();
            result.admin = this.admin || permissions.admin;
            result.mayManageUDM = this.mayManageUDM() || permissions.mayManageUDM();
            result.mayCreateProjects = this.mayCreateProjects() || permissions.mayCreateProjects();
            result.mayCreateProjectsFromMacros = this.mayCreateProjectsFromMacros() || permissions.mayCreateProjectsFromMacros();
            result.mayCreateProjectsFromTemplates = this.mayCreateProjectsFromTemplates() || permissions.mayCreateProjectsFromTemplates();
            result.mayCreateProjectsFromDataikuApps = this.mayCreateProjectsFromDataikuApps() || permissions.mayCreateProjectsFromDataikuApps();
            result.mayManageFeatureStore = this.mayManageFeatureStore() || permissions.mayManageFeatureStore();
            result.mayCreateCodeEnvs = this.mayCreateCodeEnvs() || permissions.mayCreateCodeEnvs();
            result.mayCreateClusters = this.mayCreateClusters() || permissions.mayCreateClusters();
            result.mayCreateCodeStudioTemplates = this.mayCreateCodeStudioTemplates() || permissions.mayCreateCodeStudioTemplates();
            result.mayWriteUnsafeCode = this.mayWriteUnsafeCode() || permissions.mayWriteUnsafeCode();
            result.mayWriteSafeCode = this.mayWriteSafeCode() || permissions.mayWriteSafeCode();
            result.mayDevelopPlugins = this.mayDevelopPlugins() || permissions.mayDevelopPlugins();
            result.mayEditLibFolders = this.mayEditLibFolders() || permissions.mayEditLibFolders();
            result.mayManageCodeEnvs = this.mayManageCodeEnvs() || permissions.mayManageCodeEnvs();
            result.mayManageClusters = this.mayManageClusters() || permissions.mayManageClusters();
            result.mayManageCodeStudioTemplates = this.mayManageCodeStudioTemplates() || permissions.mayManageCodeStudioTemplates();
            result.mayCreateAuthenticatedConnections = this.mayCreateAuthenticatedConnections() || permissions.mayCreateAuthenticatedConnections();
            result.mayViewIndexedHiveConnections = this.mayViewIndexedHiveConnections() || permissions.mayViewIndexedHiveConnections();
            result.mayCreatePublishedAPIServices = this.mayCreatePublishedAPIServices() || permissions.mayCreatePublishedAPIServices();
            result.mayCreatePublishedProjects = this.mayCreatePublishedProjects() || permissions.mayCreatePublishedProjects();
            result.mayWriteInRootProjectFolder = this.mayWriteInRootProjectFolder() || permissions.mayWriteInRootProjectFolder();
            result.mayCreateActiveWebContent = this.mayCreateActiveWebContent() || permissions.mayCreateActiveWebContent();
            result.mayCreateWorkspaces = this.mayCreateWorkspaces() || permissions.mayCreateWorkspaces();
            result.mayShareToWorkspaces = this.mayShareToWorkspaces() || permissions.mayShareToWorkspaces();
            result.mayCreateDataCollections = this.mayCreateDataCollections() || permissions.mayCreateDataCollections();
            boolean bl = result.mayPublishToDataCollections = this.mayPublishToDataCollections() || permissions.mayPublishToDataCollections();
            result.canObtainAPITicketFromCookiesForGroupsRegex = StringUtils.isNotBlank((String)permissions.canObtainAPITicketFromCookiesForGroupsRegex) ? (StringUtils.isNotBlank((String)this.canObtainAPITicketFromCookiesForGroupsRegex) ? String.format("(%s)|(%s)", this.canObtainAPITicketFromCookiesForGroupsRegex, permissions.canObtainAPITicketFromCookiesForGroupsRegex) : permissions.canObtainAPITicketFromCookiesForGroupsRegex) : this.canObtainAPITicketFromCookiesForGroupsRegex;
            result.dataikerAdmin = this.dataikerAdmin == null && permissions.dataikerAdmin == null ? null : Boolean.valueOf(this.dataikerAdmin != null && this.dataikerAdmin != false || permissions.dataikerAdmin != null && permissions.dataikerAdmin != false);
            return result;
        }

        public static GroupPermissions baseGroupPermissionsForUnion() {
            GroupPermissions gp = new GroupPermissions();
            gp.admin = false;
            gp.mayManageUDM = false;
            gp.mayCreateProjects = false;
            gp.mayCreateProjectsFromMacros = false;
            gp.mayCreateProjectsFromTemplates = false;
            gp.mayCreateProjectsFromDataikuApps = false;
            gp.mayManageFeatureStore = false;
            gp.mayWriteUnsafeCode = false;
            gp.mayWriteSafeCode = false;
            gp.mayCreateAuthenticatedConnections = false;
            gp.mayCreateCodeEnvs = false;
            gp.mayCreateClusters = false;
            gp.mayCreateCodeStudioTemplates = false;
            gp.mayDevelopPlugins = false;
            gp.mayEditLibFolders = false;
            gp.mayManageCodeEnvs = false;
            gp.mayManageClusters = false;
            gp.mayManageCodeStudioTemplates = false;
            gp.mayViewIndexedHiveConnections = false;
            gp.mayCreatePublishedAPIServices = false;
            gp.mayCreatePublishedProjects = false;
            gp.mayWriteInRootProjectFolder = false;
            gp.mayCreateActiveWebContent = false;
            gp.mayCreateWorkspaces = false;
            gp.mayShareToWorkspaces = false;
            gp.mayCreateDataCollections = false;
            gp.mayPublishToDataCollections = false;
            gp.canObtainAPITicketFromCookiesForGroupsRegex = null;
            gp.dataikerAdmin = null;
            return gp;
        }

        public final boolean hasSameResolvedPermissionsAs(GroupPermissions other) {
            GroupPermissions resolvedThis = this.getResolved();
            GroupPermissions resolvedOther = other.getResolved();
            return resolvedThis.admin == resolvedOther.admin && resolvedThis.mayManageUDM == resolvedOther.mayManageUDM && resolvedThis.mayCreateProjects == resolvedOther.mayCreateProjects && resolvedThis.mayCreateProjectsFromMacros == resolvedOther.mayCreateProjectsFromMacros && resolvedThis.mayCreateProjectsFromTemplates == resolvedOther.mayCreateProjectsFromTemplates && resolvedThis.mayCreateProjectsFromDataikuApps == resolvedOther.mayCreateProjectsFromDataikuApps && resolvedThis.mayWriteUnsafeCode == resolvedOther.mayWriteUnsafeCode && resolvedThis.mayWriteSafeCode == resolvedOther.mayWriteSafeCode && resolvedThis.mayCreateAuthenticatedConnections == resolvedOther.mayCreateAuthenticatedConnections && resolvedThis.mayCreateCodeEnvs == resolvedOther.mayCreateCodeEnvs && resolvedThis.mayCreateClusters == resolvedOther.mayCreateClusters && resolvedThis.mayCreateCodeStudioTemplates == resolvedOther.mayCreateCodeStudioTemplates && resolvedThis.mayDevelopPlugins == resolvedOther.mayDevelopPlugins && resolvedThis.mayEditLibFolders == resolvedOther.mayEditLibFolders && resolvedThis.mayManageCodeEnvs == resolvedOther.mayManageCodeEnvs && resolvedThis.mayManageClusters == resolvedOther.mayManageClusters && resolvedThis.mayManageCodeStudioTemplates == resolvedOther.mayManageCodeStudioTemplates && resolvedThis.mayViewIndexedHiveConnections == resolvedOther.mayViewIndexedHiveConnections && resolvedThis.mayCreatePublishedAPIServices == resolvedOther.mayCreatePublishedAPIServices && resolvedThis.mayCreatePublishedProjects == resolvedOther.mayCreatePublishedProjects && resolvedThis.mayWriteInRootProjectFolder == resolvedOther.mayWriteInRootProjectFolder && resolvedThis.mayCreateActiveWebContent == resolvedOther.mayCreateActiveWebContent && resolvedThis.mayCreateWorkspaces == resolvedOther.mayCreateWorkspaces && resolvedThis.mayShareToWorkspaces == resolvedOther.mayShareToWorkspaces && resolvedThis.mayCreateDataCollections == resolvedOther.mayCreateDataCollections && resolvedThis.mayPublishToDataCollections == resolvedOther.mayPublishToDataCollections && resolvedThis.mayManageFeatureStore == resolvedOther.mayManageFeatureStore && Objects.equals(resolvedThis.dataikerAdmin, resolvedOther.dataikerAdmin) && Objects.equals(this.canObtainAPITicketFromCookiesForGroupsRegex, resolvedOther.canObtainAPITicketFromCookiesForGroupsRegex);
        }
    }
}

