/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.CloudFileListingSupport;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class CloudToSnowflake<T extends BlobLikeDatasetHandler<?>>
extends SISORecipeExecutor
implements AutoFastPathConnector {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.cloudtosnowflake");
    private static final int MAX_SPECIFIED_FILES_PER_COPY = 1000;

    protected abstract String getRootPath(T var1) throws DKUSecurityException, CodedException, IOException;

    protected abstract String generateCopyStatementFromCloud(String var1, String var2, String var3, CopyMode var4, T var5, boolean var6, StringBuilder var7) throws IOException, DKUSecurityException;

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void run() throws Exception {
        CopyMode mode = SnowflakeToCloud.getCopyMode(this.inputDS, true);
        try (AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             BlobLikeDatasetHandler blobDShandler = (BlobLikeDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            CloudFileListingSupport.InputFSPaths inputFSPaths = CloudFileListingSupport.createInputFSPaths(blobDShandler, this.getRootPath(blobDShandler), this.inputDS, this.inputPartitions, this.authCtx, 1000);
            SQLConnectionProvider.SQLConnectionData connData = dsh.getConnectionData();
            SQLUtils.SQLTable outputTable = dsh.getResolvedTable();
            SnowflakeSQLDialect dialect = (SnowflakeSQLDialect)connData.getDialect();
            boolean isAppendMode = this.writeMode == Output.WriteMode.APPEND;
            SQLConnectionProvider.SQLConnectionWrapper connWrapper = dsh.newConnection();
            try {
                SQLUtils.executePreWriteStatements(connData, connWrapper, this.outputDS);
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                dialect.dropIfNeededAndCreateTableOrPartition(this.authCtx, connData, connWrapper, this.outputDS, this.outputPartition, this.writeMode, messages);
                if (!messages.isEmpty()) {
                    this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
                this.executeCopy(connData, connWrapper, inputFSPaths, blobDShandler, mode, this.outputDS, outputTable, isAppendMode);
                SQLUtils.executePostWriteStatements(connData, connWrapper, this.outputDS);
                connWrapper.commit();
                connWrapper.close();
            }
            catch (Exception e) {
                logger.error((Object)"Snowflake load failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connWrapper);
                throw e;
            }
        }
    }

    private boolean hasOriginalDateType(SchemaColumn sc) {
        return sc.getType() == Type.DATE && (sc.hasOriginalType("date_day") || sc.hasOriginalType("date_milli") || sc.hasOriginalType("date_micro"));
    }

    private boolean needsIntermediateTable(CopyMode mode) {
        boolean hasPartition = this.outputPartition != null && !this.outputPartition.isAll() && !this.outputPartition.isNP() && this.outputDS.getPartitioningSchema().isPartitioned();
        boolean hasParquetDateColumn = mode.type == CopyMode.CopyModeType.PARQUET && this.inputDS.getSchema().columns.stream().anyMatch(this::hasOriginalDateType);
        boolean hasCsvDateOnlyColumn = mode.type == CopyMode.CopyModeType.CSV && FastpathUtils.inputDatasetHasDateOnlyColumn(this.inputDS);
        return hasPartition || hasParquetDateColumn || hasCsvDateOnlyColumn;
    }

    private void executeCopy(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, CloudFileListingSupport.InputFSPaths inputFSPaths, T blobDShandler, CopyMode mode, Dataset outputDS, SQLUtils.SQLTable outputTable, boolean appendInsteadOfOverwrite) throws SQLException, IOException, DKUSecurityException {
        SnowflakeSQLDialect dialect = (SnowflakeSQLDialect)connData.getDialect();
        String outputTableFullName = dialect.getQuotedTableFullName(outputTable);
        try (Statement stmt = connWrapper.createStatement();){
            if (this.needsIntermediateTable(mode)) {
                String tempTableName = SQLUtils.generateSqlTempTableName(outputTable.getTable(), this.outputPartition, dialect);
                String tempTableFullName = dialect.getQuotedTableFullName(outputTable.getCatalog(), outputTable.getSchemaNullIfBlank(), tempTableName);
                Schema temporaryTableSchema = FastpathUtils.getTemporaryTableSchemaForDBSync(this.inputDS, outputDS);
                if (mode.type == CopyMode.CopyModeType.CSV) {
                    FastpathUtils.adjustTemporaryTableSchemaForCsvInput(temporaryTableSchema);
                }
                String createTempTableStatement = dialect.generateTempTableStatementSQL(tempTableName, outputDS, temporaryTableSchema, false);
                String insertFromTempTableStatement = this.getInsertFromTempTable(outputTableFullName, tempTableFullName, temporaryTableSchema);
                logger.info((Object)("Creating temp table :" + createTempTableStatement));
                SQLUtils.execute(connWrapper, stmt, createTempTableStatement, false);
                logger.info((Object)("Copying " + inputFSPaths.chunkedFilePaths.size() + " file path chunk(s) to temp table"));
                this.executeCopyStatement(connWrapper, inputFSPaths, blobDShandler, mode, appendInsteadOfOverwrite, stmt, tempTableFullName);
                logger.info((Object)("Inserting from temp table: " + insertFromTempTableStatement));
                SQLUtils.execute(connWrapper, stmt, insertFromTempTableStatement, false);
            } else {
                this.executeCopyStatement(connWrapper, inputFSPaths, blobDShandler, mode, appendInsteadOfOverwrite, stmt, outputTableFullName);
            }
            ResultSet rs2 = stmt.getResultSet();
            if (rs2 != null) {
                ResultSetMetaData rsmd = rs2.getMetaData();
                logger.info((Object)"Copy command returned statement");
                int i = 0;
                while (rs2.next() && i++ < 10) {
                    StringBuilder rsRawRow = new StringBuilder();
                    for (int j = 1; j <= rsmd.getColumnCount(); ++j) {
                        rsRawRow.append(rs2.getString(j));
                        rsRawRow.append(" ");
                    }
                    logger.info((Object)rsRawRow);
                }
                rs2.close();
            } else {
                logger.info((Object)"Copy statement returned no value");
            }
        }
    }

    private void emptyStagePathSanityCheck(String inputRootPath, Statement stmt, String connectionName) throws SQLException {
        if (!DKUApp.getProperty((String)"dku.snowflake.fastpath.emptyStageLocationLoadCheck", (boolean)true)) {
            return;
        }
        logger.infoV("Checking if '%s' contains files", new Object[]{inputRootPath});
        ResultSet resultSet = null;
        boolean checkFailed = false;
        try {
            stmt.execute("LIST " + inputRootPath);
            resultSet = stmt.getResultSet();
            if (resultSet == null || !resultSet.next()) {
                checkFailed = true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Unable to check if '%s' actually contains any data", inputRootPath));
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (checkFailed) {
            throw new IllegalArgumentException(String.format("Unable to load '%s' into Snowflake, the location contains no files. Is the external stage path correct in the '%s' connection settings?", inputRootPath, connectionName));
        }
    }

    private void executeCopyStatement(SQLConnectionProvider.SQLConnectionWrapper connWrapper, CloudFileListingSupport.InputFSPaths inputFSPaths, T blobDShandler, CopyMode mode, boolean appendInsteadOfOverwrite, Statement stmt, String destinationTableFullName) throws IOException, DKUSecurityException, SQLException {
        StringBuilder displayableSql = new StringBuilder();
        if (mode.type == CopyMode.CopyModeType.PARQUET) {
            try {
                stmt.execute("ALTER SESSION SET TIMEZONE = 'UTC'");
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to force timezone to UTC before loading parquet, date types may be shifted");
            }
        }
        if (inputFSPaths.rootPath.startsWith("@")) {
            this.emptyStagePathSanityCheck(inputFSPaths.rootPath, stmt, ((BlobLikeDatasetHandler)blobDShandler).getConnection().name);
        }
        try {
            if (inputFSPaths.chunkedFilePaths.isEmpty()) {
                String copyStatement = this.generateCopyStatementFromCloud(destinationTableFullName, inputFSPaths.rootPath, "", mode, blobDShandler, appendInsteadOfOverwrite, displayableSql);
                SQLUtils.execute(connWrapper, stmt, copyStatement, displayableSql.toString(), true, true);
            } else {
                for (List<String> filePaths : inputFSPaths.chunkedFilePaths) {
                    String copyStatement = this.generateCopyStatementFromCloud(destinationTableFullName, inputFSPaths.rootPath, CloudFileListingSupport.createSpecifiedFilesList(filePaths), mode, blobDShandler, appendInsteadOfOverwrite, displayableSql);
                    SQLUtils.execute(connWrapper, stmt, copyStatement, displayableSql.toString(), true, true);
                }
            }
        }
        catch (SQLException exc) {
            SQLException sqlExc = FastpathUtils.sanitizeSnowflakeExceptions(exc);
            throw sqlExc != null ? sqlExc : exc;
        }
    }

    private String getInsertFromTempTable(String outputTable, String tempTable, Schema temporaryTableSchema) {
        return String.format("INSERT INTO %s SELECT %s FROM %s", outputTable, this.getSelectColumnNames(temporaryTableSchema), tempTable);
    }

    private String getSelectColumnNames(Schema temporaryTableSchema) {
        List inputColumnNames = this.inputDS.getSchema().columns;
        ArrayList<Object> selectColumnNamesL = new ArrayList<Object>();
        for (SchemaColumn col : this.outputDS.getSchema().columns) {
            if (this.outputPartition != null && this.outputPartition.getDimensionValues().containsKey(col.getName())) {
                if (col.getType().isTemporal()) {
                    String dateValue = ExpressionUtils.getStringForDimensionValue((DimensionValue)this.outputPartition.getDimensionValues().get(col.getName()), col.getType());
                    String sqlType = col.getType() == Type.DATEONLY ? "DATE" : (col.getType() == Type.DATETIMENOTZ ? "TIMESTAMP_NTZ" : "TIMESTAMP_TZ");
                    selectColumnNamesL.add("'" + dateValue + "'::" + sqlType + " as \"" + col.getName() + "\"");
                    continue;
                }
                selectColumnNamesL.add("'" + FastpathUtils.getPartitionValue(col.getName(), this.outputPartition) + "' as \"" + col.getName() + "\"");
                continue;
            }
            if (FastpathUtils.containsColumn(inputColumnNames, col.getName())) {
                SchemaColumn temporaryTableColumn = temporaryTableSchema.getColumn(col.getName());
                if (temporaryTableColumn == null) {
                    throw new IllegalStateException("Missing column: " + col.getName() + " in input dataset");
                }
                if (col.getType() == Type.DATE && "date_day".equals(col.originalType) || "date_milli".equals(col.originalType) || "date_micro".equals(col.originalType)) {
                    selectColumnNamesL.add("TO_TIMESTAMP_TZ(TO_TIMESTAMP_NTZ(\"" + col.getName() + "\") || ' +00:00')");
                    continue;
                }
                if (col.getType() == Type.DATEONLY && temporaryTableColumn.getType() == Type.STRING) {
                    String caseToSupportBothDateOnlyFormats = String.format("CASE WHEN CONTAINS(\"%1$s\", '/') THEN TO_DATE(\"%1$s\", 'YYYY/MM/DD') ELSE \"%1$s\" END AS \"%1$s\"", col.getName());
                    selectColumnNamesL.add(caseToSupportBothDateOnlyFormats);
                    continue;
                }
                selectColumnNamesL.add("\"" + col.getName() + "\"");
                continue;
            }
            throw new IllegalStateException("Missing column: " + col.getName() + " in input dataset");
        }
        return String.join((CharSequence)",", selectColumnNamesL);
    }

    @Override
    public void initForAutoFastPath(AuthCtx authCtx, WarningsContext warnContext, Dataset cloudDataset, Partition cloudPartition, Dataset snowflakeDataset, Output.WriteMode writeMode) throws Exception {
        this.outputDS = snowflakeDataset;
        this.inputDS = cloudDataset;
        this.contextProjectKey = snowflakeDataset.getProjectKey();
        this.inputPartitions = Lists.newArrayList((Object[])new Partition[]{cloudPartition});
        this.outputPartition = cloudPartition;
        this.writeMode = writeMode;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.clearOutputPartitionsIfNeeded();
    }

    public static class CopyMode {
        public char delimiter;
        public CopyModeType type;
        public char quote;
        public boolean escape;
        ParquetFormatConfig.CompressionMethod parquetCompressionMethod;
        public int ignoreHeader;

        public static String quoteChar(char c2) {
            if (c2 == '\t') {
                return "\\t";
            }
            if (c2 >= ' ' && c2 < '\u007f' && c2 != '\'') {
                return Character.toString(c2);
            }
            return String.format("\\%03o", c2);
        }

        public String generateFormatOptions() {
            logger.info((Object)String.format("Generating options for CopyMode: %s", this));
            if (CopyModeType.CSV.equals((Object)this.type)) {
                Object opt = " TYPE=csv NULL_IF=()";
                if (this.delimiter != '\u0000') {
                    opt = (String)opt + " FIELD_DELIMITER='" + CopyMode.quoteChar(this.delimiter) + "'";
                }
                if (this.ignoreHeader != 0) {
                    opt = (String)opt + " SKIP_HEADER=" + this.ignoreHeader;
                }
                if (this.quote != '\u0000') {
                    opt = (String)opt + " FIELD_OPTIONALLY_ENCLOSED_BY='" + CopyMode.quoteChar(this.quote) + "'";
                }
                opt = !this.escape ? (String)opt + " ESCAPE_UNENCLOSED_FIELD=NONE" : (String)opt + " ESCAPE='\\\\'";
                return opt;
            }
            if (CopyModeType.PARQUET.equals((Object)this.type)) {
                Object opt = " TYPE=PARQUET";
                opt = ParquetFormatConfig.CompressionMethod.UNCOMPRESSED.equals((Object)this.parquetCompressionMethod) ? (String)opt + " COMPRESSION=NONE" : (String)opt + " COMPRESSION=AUTO";
                return opt;
            }
            throw new UnsupportedOperationException("Unsupported copy mode for Snowflake: " + String.valueOf((Object)this.type));
        }

        public String generateSnowflakeParquetLogicalTypes() {
            return CopyModeType.PARQUET.equals((Object)this.type) ? "USE_LOGICAL_TYPE=true" : "";
        }

        public String generateToSnowflakeCommonOptions() {
            return CopyModeType.PARQUET.equals((Object)this.type) ? " PATTERN='.*.parquet' MATCH_BY_COLUMN_NAME=CASE_INSENSITIVE" : "";
        }

        public String generateFromSnowflakeCommonOptions() {
            return CopyModeType.PARQUET.equals((Object)this.type) ? " HEADER = TRUE" : "";
        }

        public String toString() {
            return "CopyMode{delimiter=" + this.delimiter + ", type=" + String.valueOf((Object)this.type) + ", quote=" + this.quote + ", escape=" + this.escape + ", ignoreHeader=" + this.ignoreHeader + ", parquetCompressionMethod=" + String.valueOf((Object)this.parquetCompressionMethod) + "}";
        }

        static enum CopyModeType {
            CSV,
            PARQUET;

        }
    }
}

