/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SnowflakeToGcs
extends SnowflakeToCloud<GCSDatasetHandler> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.snowflaketogcs");

    public static void setCompatible(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        status.isSelectable = true;
        try {
            SnowflakeToGcs.checkCompatible(inputDS, outputDS, "GCS");
            GCSConnection gcsConnection = (GCSConnection)new FastPathDatasetTypeStraightener().getMandatoryConnectionUnsafeUnexpanded(authCtx, outputDS, "GCS");
            SnowflakeToGcs.checkGcsConnectionParams(gcsConnection);
        }
        catch (SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    static void checkGcsConnectionParams(GCSConnection gcsConnection) {
        if (StringUtils.isBlank((String)gcsConnection.params.snowflakeStorageIntegration) && StringUtils.isBlank((String)gcsConnection.params.snowflakeExternalStageName)) {
            throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException("Snowflake external stage or storage integration is not defined for GCS connection: " + gcsConnection.name);
        }
    }

    @Override
    protected String getTemporaryTablePrefix() {
        return "synctogcs";
    }

    @Override
    protected String createDestinationRootUri(GCSDatasetHandler gcsDatasetHandler) throws IOException, DKUSecurityException, CodedException {
        return PathUtils.slashes((String)gcsDatasetHandler.getRootPathForSnowflakeFastPath(), null, (Boolean)true, (boolean)false, null);
    }

    @Override
    protected String generateCopyStatementToCloud(String inputTableFullName, String outputFSPath, CloudToSnowflake.CopyMode mode, GCSDatasetHandler blobDSHandler, StringBuilder displayableSql) {
        GCSConnection connection = (GCSConnection)blobDSHandler.getConnection();
        SnowflakeToGcs.checkGcsConnectionParams(connection);
        SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
        Object storageIntegrationSql = "";
        if (!outputFSPath.startsWith("@")) {
            if (StringUtils.isBlank((String)connection.params.snowflakeStorageIntegration)) {
                throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException("Snowflake storage integration is not defined for GCS connection: " + connection.name);
            }
            storageIntegrationSql = "   STORAGE_INTEGRATION = " + dialect.quoteIdentifier(connection.params.snowflakeStorageIntegration);
        }
        String copyIntoStatement = "COPY INTO '" + outputFSPath + "' FROM " + inputTableFullName + " " + mode.generateFromSnowflakeCommonOptions() + (String)storageIntegrationSql + "   FILE_FORMAT = (" + mode.generateFormatOptions() + ")   OVERWRITE = TRUE ";
        logger.info((Object)("Fastpath statement: " + copyIntoStatement));
        return copyIntoStatement;
    }
}

