/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class AgentDiagramBuilder {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;
    @Autowired
    private ProjectsService projectsService;
    private final String projectKey;
    private final String savedModelId;
    private final String versionId;
    Map<String, AgentTool> agentToolsMap = new HashMap<String, AgentTool>();
    Map<String, SavedModel> savedModelsMap = new HashMap<String, SavedModel>();
    Map<String, Integer> instanceCountMap = new HashMap<String, Integer>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.diagram");

    public AgentDiagramBuilder(String projectKey, String savedModelId, String versionId) {
        SpringUtils.getInstance().autowire((Object)this);
        this.projectKey = projectKey;
        this.savedModelId = savedModelId;
        this.versionId = versionId;
    }

    public TreeNode buildTree_NT(AuthCtx authCtx) throws Exception {
        List<SavedModel> agents;
        List<AgentTool> agentTools;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            agentTools = this.accessibleObjectsService.listAccessibleObjectsUnsafe(authCtx, this.projectKey, ITaggingService.TaggableType.AGENT_TOOL, SerializedProject.ReaderAuthorization.Mode.READ).stream().map(o -> (AgentTool)o.object).toList();
            agents = this.accessibleObjectsService.listAccessibleObjectsUnsafe(authCtx, this.projectKey, ITaggingService.TaggableType.SAVED_MODEL, SerializedProject.ReaderAuthorization.Mode.READ).stream().map(o -> (SavedModel)o.object).toList();
        }
        this.agentToolsMap = agentTools.stream().collect(Collectors.toMap(TaggableObjectsService.TaggableObject::getFullId, Function.identity()));
        this.savedModelsMap = agents.stream().collect(Collectors.toMap(TaggableObjectsService.TaggableObject::getFullId, Function.identity()));
        return this.createTreeNode(NodeType.AGENT, this.projectKey, this.savedModelId, true, new HashSet<String>());
    }

    private TreeNode createTreeNode(NodeType nodeType, String objectProjectKey, String objectId, boolean isRootNode, Set<String> currentPath) throws Exception {
        String currentPathKey = String.valueOf((Object)nodeType) + "_" + objectProjectKey + "_" + objectId;
        boolean isCycle = currentPath.contains(currentPathKey);
        currentPath.add(currentPathKey);
        TreeNode node = switch (nodeType) {
            case NodeType.AGENT -> {
                AgentTreeNode agentNode = new AgentTreeNode();
                SavedModel agent = this.savedModelsMap.get(objectProjectKey + "." + objectId);
                if (agent != null) {
                    agentNode.projectKey = agent.projectKey;
                    agentNode.name = agent.name;
                    agentNode.savedModelType = agent.savedModelType;
                    SavedModel.SavedModelInlineVersion agentVersion = isRootNode ? agent.getVersion(this.versionId).orElseThrow(() -> new IllegalArgumentException("Can't find model version: " + this.versionId)) : agent.getActiveSaveModelInlineVersion();
                    if (agent.savedModelType == SavedModel.SavedModelType.PLUGIN_AGENT) {
                        agentNode.pluginAgentType = agentVersion.pluginAgentType;
                    }
                    if (agent.projectKey.equals(this.projectKey)) {
                        agentNode.dependencies = this.getAgentDependencies(agent);
                        agentNode.agentSettings = agent.getAgentSettings(agentVersion);
                        if (!isCycle && agent.savedModelType.equals((Object)SavedModel.SavedModelType.TOOLS_USING_AGENT)) {
                            agentNode.children.addAll(this.createAgentToolChildrenNodes(agentVersion.toolsUsingAgentSettings.tools, agent.getFullId(), currentPath));
                        }
                    }
                }
                yield agentNode;
            }
            case NodeType.AGENT_TOOL -> {
                AgentToolTreeNode agentToolNode = new AgentToolTreeNode();
                AgentTool agentTool = this.agentToolsMap.get(objectProjectKey + "." + objectId);
                if (agentTool != null) {
                    agentToolNode.projectKey = agentTool.projectKey;
                    agentToolNode.name = agentTool.name;
                    agentToolNode.toolType = agentTool.type;
                    agentToolNode.additionalDescription = agentTool.additionalDescriptionForLLM;
                    if (agentTool.projectKey.equals(this.projectKey)) {
                        agentToolNode.toolParams = agentTool.params;
                        agentToolNode.dependencies = this.getAgentToolDependencies(agentTool);
                        if (!isCycle) {
                            agentToolNode.children.addAll(this.createAgentDependencyNodes(agentToolNode.dependencies, agentTool.getFullId(), currentPath));
                        }
                    }
                }
                yield agentToolNode;
            }
            default -> throw new IOException("Unknown node type: " + String.valueOf((Object)nodeType));
        };
        Integer instanceCount = this.instanceCountMap.merge(String.valueOf((Object)node.nodeType) + "_" + node.objectId, 1, Integer::sum);
        node.objectId = objectId;
        node.id = String.valueOf((Object)node.nodeType) + "_" + node.objectId + "_" + instanceCount;
        if (!isCycle) {
            currentPath.remove(currentPathKey);
        }
        return node;
    }

    private List<AgentToolTreeNode> createAgentToolChildrenNodes(List<SavedModel.UsedTool> tools, String parentObjectId, Set<String> currentPath) {
        return tools.stream().map(usedTool -> {
            if (usedTool.toolRef != null) {
                AnyLoc loc = AnyLoc.resolveSmart(this.projectKey, usedTool.toolRef);
                if (!this.agentToolsMap.containsKey(loc.getFullName())) {
                    return null;
                }
                try {
                    AgentToolTreeNode newNode = (AgentToolTreeNode)this.createTreeNode(NodeType.AGENT_TOOL, loc.getProjectKey(), loc.getId(), false, currentPath);
                    newNode.agentSpecificDescription = usedTool.additionalDescription;
                    return newNode;
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to create graph node under " + parentObjectId + " for tool " + usedTool.toolRef + " with tree path " + String.valueOf(currentPath)), (Throwable)e);
                }
            } else {
                logger.error((Object)("Failed to create graph node under " + parentObjectId + " because tool has no toolRef. Tree path: " + String.valueOf(currentPath)));
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private List<TreeNode> createAgentDependencyNodes(List<TreeNodeDependency> dependencies, String parentObjectId, Set<String> currentPath) {
        return dependencies.stream().filter(dependency -> dependency.type == ITaggingService.TaggableType.SAVED_MODEL).map(dependency -> this.createAgentNode(dependency.fullId, parentObjectId, currentPath)).filter(Objects::nonNull).toList();
    }

    private TreeNode createAgentNode(String smartId, String parentObjectId, Set<String> currentPath) {
        AnyLoc anyLoc = AnyLoc.resolveSmart(this.projectKey, smartId);
        if (this.savedModelsMap.containsKey(anyLoc.getFullName())) {
            SavedModel savedModel = this.savedModelsMap.get(anyLoc.getFullName());
            if (savedModel.savedModelType.isAgent()) {
                try {
                    return this.createTreeNode(NodeType.AGENT, anyLoc.getProjectKey(), anyLoc.getId(), false, currentPath);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to create graph node under " + parentObjectId + " for agent " + smartId + " with tree path " + String.valueOf(currentPath)), (Throwable)e);
                }
            }
        }
        logger.error((Object)("Failed to create graph node under " + parentObjectId + " for agent " + smartId + " because agent is unavailable or inaccessible. Tree path: " + String.valueOf(currentPath)));
        return null;
    }

    private List<TreeNodeDependency> getAgentDependencies(SavedModel agent) {
        if (agent.projectKey.equals(this.projectKey) && agent.savedModelType.equals((Object)SavedModel.SavedModelType.PYTHON_AGENT)) {
            SavedModel.SavedModelInlineVersion agentVersion = agent.getVersion(this.versionId).orElseThrow(() -> new IllegalArgumentException("Can't find model version: " + this.versionId));
            List<SavedModel.AgentDependency> baseDependencies = agentVersion.pythonAgentSettings.dependencies;
            return this.getDependencies(baseDependencies);
        }
        return null;
    }

    private List<TreeNodeDependency> getAgentToolDependencies(AgentTool tool) throws IOException {
        AgentToolMeta meta = AgentToolsRegistry.getMeta(tool.type);
        List<SavedModel.AgentDependency> baseDependencies = meta.getDependencies(tool);
        return this.getDependencies(baseDependencies);
    }

    private List<TreeNodeDependency> getDependencies(List<SavedModel.AgentDependency> baseDependencies) {
        List<TreeNodeDependency> treeNodeDependencies = baseDependencies.stream().map(dependency -> {
            TaggableObjectsService.TaggableObject taggableObject = null;
            TreeNodeDependency treeNodeDependency = new TreeNodeDependency();
            AnyLoc loc = AnyLoc.resolveSmart(this.projectKey, dependency.ref);
            try {
                switch (dependency.type) {
                    case SAVED_MODEL: {
                        taggableObject = this.savedModelsMap.get(loc.getFullName());
                        break;
                    }
                    case DATASET: {
                        try (Transaction t = this.transactionService.beginRead();){
                            if (this.projectsService.isObjectAvailableInProject(new SmartObjectRef(loc.getProjectKey(), dependency.type, loc.getId()), this.projectKey)) {
                                taggableObject = (TaggableObjectsService.TaggableObject)this.datasetsDAO.getOrNullUnsafe(loc);
                            }
                            break;
                        }
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        try (Transaction t = this.transactionService.beginRead();){
                            if (this.projectsService.isObjectAvailableInProject(new SmartObjectRef(loc.getProjectKey(), dependency.type, loc.getId()), this.projectKey)) {
                                taggableObject = (TaggableObjectsService.TaggableObject)this.retrievableKnowledgeDAO.getOrNullUnsafe(loc);
                            }
                            break;
                        }
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to add agent dependency " + String.valueOf(loc) + " of type " + String.valueOf((Object)dependency.type) + " to graph node: "), (Throwable)e);
                return null;
            }
            if (taggableObject != null) {
                treeNodeDependency.id = taggableObject.getId();
                treeNodeDependency.fullId = taggableObject.getFullId();
                treeNodeDependency.name = taggableObject.getDisplayName();
                treeNodeDependency.projectKey = taggableObject.getProjectKey();
                treeNodeDependency.type = taggableObject.getTaggableType();
                treeNodeDependency.subtype = taggableObject instanceof SavedModel ? ((SavedModel)taggableObject).getMLCategory().toUpperCase() : taggableObject.getSubtype();
            }
            return treeNodeDependency;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return treeNodeDependencies;
    }

    @UIModel
    public static enum NodeType {
        AGENT,
        AGENT_TOOL;

    }

    @UIModel
    public static abstract class TreeNode {
        public NodeType nodeType;
        public String id;
        public String objectId;
        public String projectKey;
        public List<TreeNode> children = new ArrayList<TreeNode>();
        public String name;
        @Nullable
        public List<TreeNodeDependency> dependencies;
    }

    @UIModel
    public static class AgentTreeNode
    extends TreeNode {
        public SavedModel.SavedModelType savedModelType;
        public String pluginAgentType;
        @Nullable
        public SavedModel.AgentSettings agentSettings;

        public AgentTreeNode() {
            this.nodeType = NodeType.AGENT;
        }
    }

    @UIModel
    public static class AgentToolTreeNode
    extends TreeNode {
        public String toolType;
        public JsonObject toolParams;
        public String additionalDescription;
        public String agentSpecificDescription;

        public AgentToolTreeNode() {
            this.nodeType = NodeType.AGENT_TOOL;
        }
    }

    @UIModel
    public static class TreeNodeDependency {
        public String id;
        public String fullId;
        public String name;
        public String projectKey;
        public ITaggingService.TaggableType type;
        public String subtype;
    }
}

