/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortingRow;
import com.dataiku.dip.datalayer.sort.SpilledRows;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;

public class SortingChunk {
    private final RowsComparator sorter;
    private final SpilledRowsStorage storage;
    private long firstRowNumber;
    private long used = 0L;
    private List<NumberedRow> rows = Lists.newArrayList();
    private SpilledRows spilledRows;
    private static Logger logger = Logger.getLogger((String)"dip.sorter.chunk");

    SortingChunk(RowsComparator sorter, SpilledRowsStorage storage, long firstRowNumber) {
        this.sorter = sorter;
        this.storage = storage;
        this.firstRowNumber = firstRowNumber;
    }

    public void emitRow(Row row) throws Exception {
        SortingRow sortingRow = this.storage.handle(row);
        this.rows.add(new NumberedRow(sortingRow, this.firstRowNumber + (long)this.rows.size()));
        this.used += sortingRow.getMemoryUsed();
    }

    public void lastRowEmitted() throws Exception {
        if (this.spilledRows == null) {
            this.spill();
        }
    }

    public void cancel() throws Exception {
    }

    public long used() {
        return this.used;
    }

    public void spill() throws Exception {
        logger.info((Object)("Spilling chunk. used=" + this.used));
        this.sorter.sort(this.rows);
        this.spilledRows = this.storage.spill(this.rows);
        this.rows = null;
    }

    public SpilledRows getSpilledRows() {
        return this.spilledRows;
    }
}

