/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.multivariate.FetchValues;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.grouping.SubsampledGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.TrivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithColorBy;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ScatterPlot3DCard
extends TrivariateCard
implements CardWithHighlight,
CardWithColorBy {
    public static final String TYPE = "scatter_plot_3d";
    public int symbolSize = 4;
    public int maxNumberOfPoints = 100000;
    @Nullable
    public Filter highlightFilter;
    @Nullable
    public SplitBySpec colorBy;

    public ScatterPlot3DCard(Variable xColumn, Variable yColumn, Variable zColumn) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.zColumn = zColumn;
    }

    private ScatterPlot3DCard() {
    }

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    @Override
    public void setColorBy(SplitBySpec colorBy) {
        this.colorBy = colorBy;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                List<String> columnNames = Stream.of(ScatterPlot3DCard.this.xColumn, ScatterPlot3DCard.this.yColumn, ScatterPlot3DCard.this.zColumn).map(it -> it.name).collect(Collectors.toList());
                Grouping highlightGrouping = ScatterPlot3DCard.this.highlightFilter == null ? SubsetGrouping.all() : new UnionGrouping(new SubsetGrouping(ScatterPlot3DCard.this.highlightFilter), new SubsetGrouping(new NotFilter(ScatterPlot3DCard.this.highlightFilter)));
                Grouping colorByGrouping = ScatterPlot3DCard.this.colorBy == null ? SubsetGrouping.all() : ScatterPlot3DCard.this.colorBy.asGrouping();
                return new GroupedComputation(new GroupedComputation(new GroupedComputation(new FetchValues(columnNames), new CrossGrouping(highlightGrouping, colorByGrouping)), new SubsampledGrouping(ScatterPlot3DCard.this.maxNumberOfPoints)), GroupingHelpers.groupOverNotMissingNumericalColumns(ScatterPlot3DCard.this.xColumn, ScatterPlot3DCard.this.yColumn, ScatterPlot3DCard.this.zColumn));
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                GroupedComputation.GroupedComputationResult subsetGroupResult = result.results.get(0).asGrouped();
                GroupedComputation.GroupedComputationResult subsampleGroupResult = subsetGroupResult.results.get(0).asGrouped();
                GroupingResult highlightGroups = subsampleGroupResult.groups.asCross().groups.get(0);
                GroupingResult colorByGroups = subsampleGroupResult.groups.asCross().groups.get(1);
                ScatterPlot3DCardResult cardResult = new ScatterPlot3DCardResult();
                cardResult.groups.addAll(colorByGroups.listFilters());
                for (int highlightIndex = 0; highlightIndex < highlightGroups.size(); ++highlightIndex) {
                    for (int groupIndex = 0; groupIndex < colorByGroups.size(); ++groupIndex) {
                        int computationIndex = highlightIndex * colorByGroups.size() + groupIndex;
                        FetchValues.FetchValuesResult fetchResult = subsampleGroupResult.results.get(computationIndex).as(FetchValues.FetchValuesResult.class);
                        ScatterPlot3DSeries series3d = new ScatterPlot3DSeries();
                        series3d.groupIndex = groupIndex;
                        series3d.isHighlighted = highlightGroups.size() > 1 && highlightIndex == 0;
                        series3d.xSeries = fetchResult.series.get(0);
                        series3d.ySeries = fetchResult.series.get(1);
                        series3d.zSeries = fetchResult.series.get(2);
                        cardResult.series3d.add(series3d);
                    }
                }
                return cardResult;
            }
        };
    }

    public static class ScatterPlot3DCardResult
    extends CardResult {
        public List<Filter> groups = new ArrayList<Filter>();
        public List<ScatterPlot3DSeries> series3d = new ArrayList<ScatterPlot3DSeries>();

        private ScatterPlot3DCardResult() {
        }
    }

    public static class ScatterPlot3DSeries
    extends ImmutableValueObject {
        public boolean isHighlighted;
        public int groupIndex;
        public double[] xSeries;
        public double[] ySeries;
        public double[] zSeries;
    }
}

