/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.KsTest2SampCard;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KSSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        SuggestCards.SuggestedCard suggestion;
        if (sniffedVariables.size() != 2) {
            return Collections.emptyList();
        }
        SniffedVariable first = sniffedVariables.get(0);
        SniffedVariable second = sniffedVariables.get(1);
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        if (this.canSuggestKSTest(first, second)) {
            suggestion = this.suggestKSTest(first, second);
            suggestions.add(suggestion);
        }
        if (this.canSuggestKSTest(second, first)) {
            suggestion = this.suggestKSTest(second, first);
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private boolean canSuggestKSTest(SniffedVariable first, SniffedVariable second) {
        return first.isLikelyNumerical() && second.isLikelyCategorical() && second.cardinality > 1L;
    }

    private SuggestCards.SuggestedCard suggestKSTest(SniffedVariable first, SniffedVariable second) {
        String cardName = String.format("Compare distributions of %s among %s", first.name, second.name);
        ArrayList<String> top5Values = new ArrayList<String>(second.top5values.keySet());
        String top1Value = (String)top5Values.get(0);
        String top2Value = (String)top5Values.get(1);
        KsTest2SampCard card = new KsTest2SampCard(Suggester.toContinuousVariable(first), Suggester.toCategoricalVariable(second), new String[]{top1Value}, new String[]{top2Value});
        return new SuggestCards.SuggestedCard(cardName, card);
    }
}

