/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.compute.stats.VarianceAssumption;
import com.dataiku.dip.eda.worksheets.cards.OneWayANOVACard;
import com.dataiku.dip.eda.worksheets.cards.PairwiseMoodTestCard;
import com.dataiku.dip.eda.worksheets.cards.PairwiseTTestCard;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NSampleTestSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 2) {
            return Collections.emptyList();
        }
        SniffedVariable first = sniffedVariables.get(0);
        SniffedVariable second = sniffedVariables.get(1);
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        if (this.holdsNumericalValues(first) && this.isLowCardinalityCategorical(second)) {
            suggestions.addAll(this.suggestCards(first, second));
        }
        if (this.holdsNumericalValues(second) && this.isLowCardinalityCategorical(first)) {
            suggestions.addAll(this.suggestCards(second, first));
        }
        return suggestions;
    }

    private boolean holdsNumericalValues(SniffedVariable sniffedVariable) {
        return sniffedVariable.isLikelyNumerical() || sniffedVariable.isLikelyIndicator();
    }

    private boolean isLowCardinalityCategorical(SniffedVariable sniffedVariable) {
        return sniffedVariable.isLikelyCategorical() && sniffedVariable.hasVeryLowCardinality() && sniffedVariable.cardinality > 1L;
    }

    private List<SuggestCards.SuggestedCard> suggestCards(SniffedVariable numerical, SniffedVariable categorical) {
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        suggestions.add(this.suggestOneWayAnova(numerical, categorical));
        suggestions.add(this.suggestPairwiseTTest(numerical, categorical));
        if (!numerical.isLikelyIndicator()) {
            suggestions.add(this.suggestPairwiseMoodTest(numerical, categorical));
        }
        return suggestions;
    }

    private SuggestCards.SuggestedCard suggestPairwiseTTest(SniffedVariable numerical, SniffedVariable categorical) {
        ArrayList<String> top5Labels = new ArrayList<String>(categorical.top5values.keySet());
        PairwiseTTestCard card = new PairwiseTTestCard(Suggester.toContinuousVariable(numerical), Suggester.toCategoricalVariable(categorical), top5Labels, 10, null, VarianceAssumption.UNEQUAL, PValueAdjustmentMethod.NONE, AlternativeHypothesis.TWO_SIDED);
        String cardName = String.format("Compare mean of %s across %s (pairwise t-test)", numerical.name, categorical.name);
        return new SuggestCards.SuggestedCard(cardName, card);
    }

    private SuggestCards.SuggestedCard suggestPairwiseMoodTest(SniffedVariable numerical, SniffedVariable categorical) {
        ArrayList<String> top5Labels = new ArrayList<String>(categorical.top5values.keySet());
        PairwiseMoodTestCard card = new PairwiseMoodTestCard(Suggester.toContinuousVariable(numerical), Suggester.toCategoricalVariable(categorical), top5Labels, 10, null, PValueAdjustmentMethod.NONE);
        String cardName = String.format("Compare median of %s across %s (pairwise Mood test)", numerical.name, categorical.name);
        return new SuggestCards.SuggestedCard(cardName, card);
    }

    private SuggestCards.SuggestedCard suggestOneWayAnova(SniffedVariable numerical, SniffedVariable categorical) {
        ArrayList<String> top5Labels = new ArrayList<String>(categorical.top5values.keySet());
        OneWayANOVACard card = new OneWayANOVACard(Suggester.toContinuousVariable(numerical), Suggester.toCategoricalVariable(categorical), top5Labels, 10);
        String cardName = String.format("Test mean equality of %s across %s (one-way ANOVA)", numerical.name, categorical.name);
        return new SuggestCards.SuggestedCard(cardName, card);
    }
}

