/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.docgen.helpers.ModelDetailsBaseUtil;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.KerasModelTrainingInfo;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.MetricMapProvider;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.experimenttracking.Experiment;
import com.dataiku.dip.experimenttracking.ExperimentTag;
import com.dataiku.dip.experimenttracking.ExperimentTrackingExportData;
import com.dataiku.dip.experimenttracking.ExperimentTrackingGarbageCollectionReport;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDB;
import com.dataiku.dip.experimenttracking.Model;
import com.dataiku.dip.experimenttracking.Run;
import com.dataiku.dip.experimenttracking.RunMetric;
import com.dataiku.dip.experimenttracking.RunParam;
import com.dataiku.dip.experimenttracking.RunStatus;
import com.dataiku.dip.experimenttracking.RunTag;
import com.dataiku.dip.experimenttracking.ViewType;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExperimentTrackingService {
    public static final String DSS_MANAGED_FOLDER_URI_PREFIX = "dss-managed-folder://";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.experimenttracking.service");
    @Autowired
    private ExperimentTrackingInternalDB experimentTrackingInternalDB;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ProjectsJGitService projectsGitService;

    public String createExperiment(String artifactsRoot, String projectKey, String name, String artifactLocation, List<ExperimentTag> tags) throws SQLException, NotFoundException {
        return this.experimentTrackingInternalDB.createExperiment(artifactsRoot, projectKey, name, artifactLocation, tags);
    }

    public Experiment getExperiment(String projectKey, String experimentId) throws SQLException, NotFoundException {
        return this.experimentTrackingInternalDB.getExperiment(projectKey, experimentId);
    }

    public Experiment getExperimentByName(String projectKey, String experimentName) throws SQLException, NotFoundException {
        return this.experimentTrackingInternalDB.getExperimentByName(projectKey, experimentName);
    }

    public List<Experiment> listExperiments(String projectKey, long maxResults, ViewType viewType, boolean retrieveExtensions) throws SQLException {
        return this.experimentTrackingInternalDB.listExperiments(projectKey, maxResults, viewType, retrieveExtensions);
    }

    public int countAllExperiments() throws SQLException {
        return this.experimentTrackingInternalDB.countAllExperiments();
    }

    public void deleteExperiment(String projectKey, String experimentId) throws SQLException {
        this.experimentTrackingInternalDB.updateExperimentLifecycleSetDeleted(projectKey, experimentId);
    }

    public void restoreExperiment(String projectKey, String experimentId) throws SQLException, NotFoundException {
        this.experimentTrackingInternalDB.updateExperimentLifecycleSetActive(projectKey, experimentId);
    }

    public void setExperimentName(String projectKey, String experimentId, String newName) throws SQLException {
        this.experimentTrackingInternalDB.updateExperimentSetName(projectKey, experimentId, newName);
    }

    public void setExperimentTag(String projectKey, String experimentId, String key, String value) throws SQLException, NotFoundException {
        this.experimentTrackingInternalDB.setExperimentTag(projectKey, experimentId, key, value);
    }

    public Run createRun(String artifactsRoot, String projectKey, String experimentId, String userId, long startTime, List<RunTag> tags) throws SQLException, NotFoundException {
        this.addGitTags(projectKey, tags);
        Run run = this.experimentTrackingInternalDB.createRun(artifactsRoot, projectKey, experimentId, userId, startTime, tags);
        this.mapManagedFolderName(projectKey, Arrays.asList(run));
        return run;
    }

    private void addGitTags(String projectKey, List<RunTag> tags) {
        String DEFAULT_VALUE = "none";
        String branch = "none";
        String commit = "none";
        String message = "none";
        try {
            branch = this.projectsGitService.getCurrentBranch_NT(projectKey);
        }
        catch (Throwable t) {
            logger.warnV(t, "Could not retrieve current git branch for project %s.", new Object[]{projectKey});
        }
        try {
            TaggableObjectsService.TaggableObjectRef projectRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
            DSSGitModel.ObjectLog objectLog = this.projectsGitService.getObjectLogSince(projectRef, null, null, 1);
            if (!CollectionUtils.isEmpty((Collection)objectLog.logEntries)) {
                GitModel.DKULogEntry dkuLogEntry = (GitModel.DKULogEntry)objectLog.logEntries.get(0);
                commit = dkuLogEntry.commitId;
                message = dkuLogEntry.message;
            }
        }
        catch (Throwable t) {
            logger.warnV(t, "Could not retrieve latest commit of project %s.", new Object[]{projectKey});
        }
        tags.add(new RunTag("dku-ext.git.branch", branch));
        tags.add(new RunTag("dku-ext.git.commit", commit));
        tags.add(new RunTag("dku-ext.git.message", message));
    }

    public Run setRunStatusEndTime(String projectKey, String runId, String status, long endTime) throws SQLException, NotFoundException {
        Run run = this.experimentTrackingInternalDB.updateRunStatusEndTime(projectKey, runId, status, endTime);
        this.mapManagedFolderName(projectKey, Arrays.asList(run));
        return run;
    }

    public Run setRunLifecycle(String projectKey, String runId, String lifecycleStage) throws SQLException, NotFoundException {
        Run run = this.experimentTrackingInternalDB.updateRunLifecycle(projectKey, runId, lifecycleStage);
        this.mapManagedFolderName(projectKey, Arrays.asList(run));
        return run;
    }

    public void setRunTag(String projectKey, String runUUID, String runId, String key, String value) throws SQLException, NotFoundException {
        this.experimentTrackingInternalDB.setRunTag(projectKey, runUUID, runId, key, value);
    }

    public void deleteRunTag(String projectKey, String runId, String key) throws SQLException, NotFoundException {
        this.experimentTrackingInternalDB.deleteRunTag(projectKey, runId, key);
    }

    public Run getRun(String projectKey, String runId, boolean includeModels) throws SQLException, NotFoundException {
        Run run = this.experimentTrackingInternalDB.getRun(projectKey, runId, true);
        if (includeModels) {
            run.data.models = this.experimentTrackingInternalDB.listRunModels(projectKey, run.info.runId);
        }
        this.mapManagedFolderName(projectKey, Arrays.asList(run));
        return run;
    }

    public void deleteRun(String projectKey, String runId) throws SQLException, NotFoundException {
        this.experimentTrackingInternalDB.updateRunLifecycle(projectKey, runId, "deleted");
    }

    public void restoreRun(String projectKey, String runId) throws SQLException, NotFoundException {
        this.experimentTrackingInternalDB.updateRunLifecycle(projectKey, runId, "active");
    }

    public List<Run> searchRuns_NT(String projectKey, List<String> experimentIds, ViewType runViewType, String filter, long maxResults, List<String> orderBy, boolean includeModels) throws SQLException, NotFoundException {
        List<Run> runs = this.experimentTrackingInternalDB.searchRuns_NT(projectKey, experimentIds, runViewType, filter, maxResults, orderBy);
        if (includeModels) {
            HashMap<String, List<Model>> runsModels = this.experimentTrackingInternalDB.listRunsModels(projectKey, runs);
            for (Run run : runs) {
                List runModels = (List)runsModels.get(run.info.runId);
                if (runModels == null) continue;
                run.data.models = runModels;
            }
        }
        this.mapManagedFolderName(projectKey, runs);
        return runs;
    }

    public List<Experiment> searchExperiments_NT(String projectKey, ViewType runViewType, String filter, long maxResults, List<String> orderBy) throws SQLException {
        return this.experimentTrackingInternalDB.searchExperiments_NT(projectKey, runViewType, filter, maxResults, orderBy);
    }

    public void insertParameter(String projectKey, String runUUID, String runId, String key, String value) throws SQLException {
        this.experimentTrackingInternalDB.insertParameter(projectKey, runUUID, runId, key, value);
    }

    public void insertUpdateMetric(String projectKey, String runUUID, String runId, String key, Double value, long timestamp, long step) throws SQLException {
        this.experimentTrackingInternalDB.insertUpdateMetric(projectKey, runUUID, runId, key, value, timestamp, step);
    }

    public List<RunMetric> getMetricHistory(String projectKey, String runId, String metricKey) throws SQLException {
        return this.experimentTrackingInternalDB.getMetricHistory(projectKey, runId, metricKey);
    }

    public void logBatch(String projectKey, String runId, List<RunMetric> metrics, List<RunParam> params, List<RunTag> tags) throws SQLException {
        this.experimentTrackingInternalDB.logBatch(projectKey, runId, metrics, params, tags);
    }

    public void logModel(String projectKey, String runUUId, String runId, String artifactPath) throws SQLException {
        this.experimentTrackingInternalDB.logModel(projectKey, runUUId, runId, artifactPath);
    }

    public List<Model> listRunModels(String projectKey, String runId) throws SQLException {
        return this.experimentTrackingInternalDB.listRunModels(projectKey, runId);
    }

    public void cleanProject(String projectKey) throws SQLException {
        this.experimentTrackingInternalDB.cleanProject(projectKey);
    }

    public ExperimentTrackingExportData getExportData(String projectKey) throws SQLException {
        return this.experimentTrackingInternalDB.getExportData(projectKey);
    }

    public void insertExportData(String projectKey, ExperimentTrackingExportData data) throws SQLException {
        this.experimentTrackingInternalDB.insertExportData(projectKey, data);
    }

    public ExperimentTrackingGarbageCollectionReport garbageCollect_NT(AuthCtx authCtx, String projectKey) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        this.garbageCollectManagedFolders(authCtx, projectKey);
        return this.experimentTrackingInternalDB.garbageCollectDB(projectKey);
    }

    private void garbageCollectManagedFolders(AuthCtx authCtx, String projectKey) throws Exception {
        SmartObjectRef smartObjectRef;
        String managedFolderSmartId;
        String[] splitLocation;
        logger.debugV("Garbage collecting experiment files of project %s", new Object[]{projectKey});
        List<Experiment> experimentsToDelete = this.listExperiments(projectKey, 100000L, ViewType.DELETED_ONLY, false);
        Set experimentIdsToDelete = experimentsToDelete.stream().map(ex -> ex.id).collect(Collectors.toSet());
        Set runToDeleteFromMF = this.searchRuns_NT(projectKey, null, ViewType.DELETED_ONLY, null, 100000L, null, false).stream().filter(run -> !experimentIdsToDelete.contains(run.info.experimentId)).collect(Collectors.toSet());
        HashMap mapMFPathsToDelete = new HashMap();
        for (Experiment experiment : experimentsToDelete) {
            logger.debugV("Garbage collecting files of experiment %s of project %s", new Object[]{experiment.id, projectKey});
            if (!StringUtils.startsWith((String)experiment.artifactLocation, (String)DSS_MANAGED_FOLDER_URI_PREFIX)) {
                logger.warnV("Experiment %s has an artifact location not pointing to ta DSS Managed Folder %s. Ignoring.", new Object[]{experiment.id, experiment.artifactLocation});
                continue;
            }
            splitLocation = experiment.artifactLocation.split("/");
            if (splitLocation.length < 4) {
                logger.warnV("Invalid artifact location %s for experiment %s", new Object[]{experiment.artifactLocation, experiment.id});
                continue;
            }
            managedFolderSmartId = splitLocation[2];
            String experimentPath = "/" + splitLocation[3];
            SmartObjectRef smartObjectRef2 = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, managedFolderSmartId);
            String managedFolderFullId = smartObjectRef2.getFullId(projectKey);
            if (!mapMFPathsToDelete.containsKey(managedFolderFullId)) {
                mapMFPathsToDelete.put(managedFolderFullId, new ArrayList());
            }
            logger.debugV("Planning deletion of path %s in managed folder %s for experiment %s", new Object[]{experimentPath, managedFolderFullId, experiment.id});
            ((List)mapMFPathsToDelete.get(managedFolderFullId)).add(experimentPath);
        }
        for (Run run2 : runToDeleteFromMF) {
            logger.debugV("Garbage collecting files of run %s of experiment %s of project %s", new Object[]{run2.info.runId, run2.info.experimentId, projectKey});
            splitLocation = this.splitRunLocation(run2);
            if (splitLocation.length < 6 || StringUtils.isEmpty((String)splitLocation[2])) continue;
            managedFolderSmartId = splitLocation[2];
            smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, managedFolderSmartId);
            String managedFolderFullId = smartObjectRef.getFullId(projectKey);
            String runPath = "/" + splitLocation[3] + "/" + splitLocation[4];
            if (!mapMFPathsToDelete.containsKey(managedFolderFullId)) {
                mapMFPathsToDelete.put(managedFolderFullId, new ArrayList());
            }
            logger.debugV("Planning deletion of path %s in managed folder %s for run %s", new Object[]{runPath, managedFolderFullId, run2.info.runId});
            ((List)mapMFPathsToDelete.get(managedFolderFullId)).add(runPath);
        }
        for (Map.Entry entry : mapMFPathsToDelete.entrySet()) {
            String managedFolderFullId = (String)entry.getKey();
            String[] paths = ((List)entry.getValue()).toArray(new String[0]);
            logger.debugV("Requesting removal of paths from managed folder %s", new Object[]{managedFolderFullId});
            smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, managedFolderFullId);
            Optional<ManagedFolder> mf = this.getManagedFolder(projectKey, smartObjectRef);
            if (!mf.isPresent()) continue;
            Object deletionResponse = this.kernelsManagedFolderService.handleDeleteItemsRequest(smartObjectRef.getProjectKey(projectKey), smartObjectRef.objectId, paths, authCtx);
            if (!deletionResponse.hasResult) {
                deletionResponse = this.futureService.waitForCompletion(deletionResponse.jobId);
            }
            if (deletionResponse.log != null) {
                logger.infoV("Garbage collecting - Deletion from managed folder %s completed with logs: %s", new Object[]{managedFolderFullId, Joiner.on((String)"\n").join((Iterable)deletionResponse.log.lines)});
                continue;
            }
            logger.infoV("Garbage collecting - Deletion from managed folder %s completed with no logs", new Object[]{managedFolderFullId});
        }
        logger.debugV("Garbage collecting experiment DB of project %s", new Object[]{projectKey});
    }

    public void clearProject(String projectKey) throws SQLException {
        this.experimentTrackingInternalDB.cleanProject(projectKey);
    }

    private Optional<ManagedFolder> getManagedFolder(String projectKey, SmartObjectRef smartObjectRef) throws IOException {
        ManagedFolder mf;
        try (Transaction t = this.transactionService.beginRead();){
            mf = this.managedFoldersService.getOrNullUnsafe(smartObjectRef.getProjectKey(projectKey), smartObjectRef.objectId);
            if (null == mf) {
                logger.warnV("Managed Folder %s not found", new Object[]{smartObjectRef.getFullId(projectKey)});
            }
        }
        return Optional.ofNullable(mf);
    }

    private String[] splitRunLocation(Run run) {
        String[] splitLocation = new String[]{};
        if (!StringUtils.startsWith((String)run.info.artifactUri, (String)DSS_MANAGED_FOLDER_URI_PREFIX)) {
            logger.warnV("Run %s has an artifact location not pointing to ta DSS Managed Folder %s. Ignoring.", new Object[]{run.info.runId, run.info.artifactUri});
        } else {
            splitLocation = run.info.artifactUri.split("/");
            if (splitLocation.length < 6) {
                logger.warnV("Invalid artifact URI %s for run %s", new Object[]{run.info.artifactUri, run.info.runId});
            } else {
                String managedFolderSmartId = splitLocation[2];
                if (StringUtils.isEmpty((String)managedFolderSmartId)) {
                    logger.warnV("Invalid artifact URI %s for run %s", new Object[]{run.info.artifactUri, run.info.runId});
                }
            }
        }
        return splitLocation;
    }

    private void mapManagedFolderName(String projectKey, List<Run> runs) {
        HashMap<String, String> managedFolderNamesMap = new HashMap<String, String>();
        for (Run run : runs) {
            String[] splitLocation = this.splitRunLocation(run);
            if (splitLocation.length < 6 || StringUtils.isEmpty((String)splitLocation[2])) continue;
            String managedFolderSmartId = splitLocation[2];
            if (!managedFolderNamesMap.containsKey(managedFolderSmartId)) {
                SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, managedFolderSmartId);
                try {
                    Optional<ManagedFolder> mf = this.getManagedFolder(projectKey, smartObjectRef);
                    managedFolderNamesMap.put(managedFolderSmartId, mf.map(ManagedFolder::getDisplayName).orElse(null));
                }
                catch (IOException e) {
                    logger.warnV("A problem occurred while accessing the Managed Folder %s.\n\t%s", new Object[]{smartObjectRef.getFullId(projectKey), e.toString()});
                    continue;
                }
            }
            run.managedFolderName = (String)managedFolderNamesMap.get(managedFolderSmartId);
        }
    }

    public void createRunsFromAnalyses(AuthCtx user, String projectKey, List<FullModelId> fullModelIds, String experimentId) throws IOException, SQLException {
        for (FullModelId fmi : fullModelIds) {
            if (!fmi.exists()) {
                throw new IllegalArgumentException("Could not find model: " + String.valueOf(fmi) + ". Please make sure this model exists.");
            }
            if (FullModelId.Type.ANALYSIS.equals((Object)fmi.getType())) continue;
            throw new IllegalArgumentException("Invalid model type \"" + String.valueOf((Object)fmi.getType()) + "\" for model \"" + String.valueOf(fmi) + "\". Please make sure this model is from a Visual ML analysis.");
        }
        for (FullModelId analysisFmi : fullModelIds) {
            this.createRunFromAnalysis(user, projectKey, analysisFmi, experimentId);
        }
    }

    private void createRunFromAnalysis(AuthCtx user, String projectKey, FullModelId analysisFmi, String experimentId) throws IOException, SQLException {
        MLTask mlTask = analysisFmi.getHeadMLTask();
        ModelDetailsBase modelDetails = ModelDetailsBaseUtil.getModel(mlTask, analysisFmi);
        ArrayList<RunTag> tags = new ArrayList<RunTag>();
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.dssUser", user.getIdentifier()));
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.origin", "analysis"));
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.displayName", analysisFmi.getUserMeta().name));
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.fullModelId", analysisFmi.toString()));
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.analysisId", analysisFmi.getTaskLoc().analysisId));
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.mlTaskType", mlTask.taskType.toString()));
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.predictionType", analysisFmi.getPredictionType().toString()));
            if (analysisFmi.getPredictionType() == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION || analysisFmi.getPredictionType() == PredictionMLTask.PredictionType.MULTICLASS) {
                ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.targetClasses", JSON.json(analysisFmi.getClasses())));
            }
            ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.target", analysisFmi.getResolvedPredictionPreprocessingParams().getTarget()));
        }
        ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.codeEnv", mlTask.getCodeEnvSelection().envName));
        Run run = this.createRun("", projectKey, experimentId, user.getIdentifier(), modelDetails.trainInfo.startTime, tags);
        MetricParams predictionMetricParams = mlTask.taskType == MLTask.MLTaskType.PREDICTION ? ((ClassicalPredictionModelDetails)modelDetails).modeling.metrics : null;
        Optional<MetricMapProvider> metricMapProvider = mlTask.taskType == MLTask.MLTaskType.PREDICTION ? analysisFmi.getClassicalPredictionPerf() : analysisFmi.getClusteringPerf();
        boolean needsStdMetrics = mlTask instanceof PredictionMLTask && ((PredictionMLTask)mlTask).splitParams != null && ((PredictionMLTask)mlTask).splitParams.kfold;
        List<RunMetric> metrics = metricMapProvider.map(provider -> ExperimentTrackingService.createRunMetricsFromMetricMapWithoutStep(provider, modelDetails.trainInfo.endTime, predictionMetricParams, needsStdMetrics)).orElse(Collections.emptyList());
        if (analysisFmi.getKerasModelTrainingInfoFile().exists()) {
            KerasModelTrainingInfo mti = analysisFmi.parseKerasModelTrainingInfoFile();
            List<RunMetric> stepMetrics = this.getStepMetricsForKerasModels(mti, predictionMetricParams);
            String metricName = this.getPerfMetricName(mti.metric, predictionMetricParams);
            metrics = metrics.stream().filter(m -> !m.key.equals(metricName)).collect(Collectors.toList());
            String bestEpochIndex = Integer.toString(mti.keptModelEpoch);
            ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.keptEpoch", bestEpochIndex));
            ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("Best Epoch", bestEpochIndex));
            long relativeTimeStampMs = mti.epochs.size() <= 1 ? 0L : mti.epochs.stream().limit(mti.keptModelEpoch + 1).mapToLong(it -> it.time).sum() - mti.epochs.get((int)0).time;
            ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("dku-ext.keptEpochTimestamp", Long.toString(relativeTimeStampMs)));
            double relativeTimeStampS = (double)relativeTimeStampMs / 1000.0;
            ExperimentTrackingService.addTagIfValueNotNull(tags, new RunTag("Best Epoch relative time", String.format("%.2f", relativeTimeStampS) + "s"));
            this.logBatch(projectKey, run.info.runId, stepMetrics, Collections.emptyList(), tags);
        }
        this.logBatch(projectKey, run.info.runId, metrics, Collections.emptyList(), tags);
        this.setRunStatusEndTime(projectKey, run.info.runId, RunStatus.FINISHED.toString(), modelDetails.trainInfo.endTime);
    }

    private static void addTagIfValueNotNull(List<RunTag> tags, RunTag tagToAdd) {
        if (tagToAdd.value != null) {
            tags.add(tagToAdd);
        }
    }

    private static List<RunMetric> createRunMetricsFromMetricMapWithoutStep(MetricMapProvider metricMapProvider, long timestamp, MetricParams metricParams, boolean withStdMetrics) {
        return metricMapProvider.getMetricMap(withStdMetrics).entrySet().stream().filter(e -> e.getValue() != null).map(e -> new RunMetric((String)e.getKey(), (Double)e.getValue(), 0L, timestamp)).collect(Collectors.toList());
    }

    private String getPerfMetricName(String metric, MetricParams metricParams) {
        switch (metric) {
            case "COST_MATRIX": {
                return "costMatrix";
            }
            case "LOG_LOSS": {
                return "logLoss";
            }
            case "ROC_AUC": {
                return "auc";
            }
            case "CUMULATIVE_LIFT": {
                return "lift";
            }
            case "CUSTOM": {
                return metricParams.customEvaluationMetricName;
            }
        }
        return metric.toLowerCase();
    }

    private static List<String> getLowerBetterMetrics(boolean customEvaluationMetricGIB) {
        return Arrays.stream(MetricParams.EvaluationMetric.values()).filter(metric -> metric.isLowerIsBetter() || metric == MetricParams.EvaluationMetric.CUSTOM && !customEvaluationMetricGIB).map(Enum::name).collect(Collectors.toList());
    }

    public List<RunMetric> getStepMetricsForKerasModels(KerasModelTrainingInfo mti, MetricParams predictionMetricParams) {
        ArrayList<RunMetric> stepMetrics = new ArrayList<RunMetric>();
        long stepTime = mti.startedAt;
        String metricName = this.getPerfMetricName(mti.metric, predictionMetricParams);
        for (int step = 0; step < mti.epochs.size(); ++step) {
            KerasModelTrainingInfo.EpochScore epochScore = mti.epochs.get(step);
            boolean customScoreGib = predictionMetricParams.evaluationMetric != MetricParams.EvaluationMetric.CUSTOM || predictionMetricParams.getCustomEvaluationMetric().greaterIsBetter;
            double stepMetricValue = ExperimentTrackingService.getLowerBetterMetrics(customScoreGib).stream().anyMatch(x -> x.equals(mti.metric)) ? -epochScore.testScore.doubleValue() : epochScore.testScore;
            RunMetric runMetric = new RunMetric(metricName, stepMetricValue, step, stepTime += epochScore.time);
            stepMetrics.add(runMetric);
        }
        return stepMetrics;
    }
}

