/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.export.ExportDAO;
import com.dataiku.dip.export.ExportFutureThreadBase;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.hooks.FileExportPostprocessingHookHandler;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.ExportStateChangedEvent;
import com.dataiku.dip.server.services.PubSubPrivilegedClient;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

public class RemoteExportFutureThread
extends ExportFutureThreadBase {
    private static final Logger logger = Logger.getLogger((String)"dku.export.thread.remote");
    private final ExportService.RemoteExportJob job;

    public RemoteExportFutureThread(AuthCtx user, ExportService.RemoteExportJob job) {
        super(user, job.input, job.exportId);
        this.job = job;
        logger.info((Object)("Start RemoteFutureExportThread user=" + user.getIdentifier()));
    }

    @Override
    public double getDangerosity() {
        return 1.0;
    }

    public void postRunCleanup() {
        try {
            long fileSize;
            ExportStatus status = ((ExportDAO)SpringUtils.getBean(ExportDAO.class)).getStatus(this.job.status.exportId);
            if (status.targetFile != null) {
                File f = new File(status.targetFile);
                if (!f.isFile()) {
                    logger.warn((Object)String.format("Export file '%s' is missing", status.exportId));
                    return;
                }
                fileSize = f.length();
            } else {
                fileSize = -1L;
            }
            ((AuditTrailService)SpringUtils.getBean(AuditTrailService.class)).generic("export-ready").with("exportId", status.exportId).with("exportMethod", status.exportMethod.name()).with("fileSize", (Number)fileSize).emit();
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to perform export post-run cleanup", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExportFutureThreadBase.ExportResult compute() throws Exception {
        ExportFutureThreadBase.ExportResult exportResult;
        logger.info((Object)("Started export thread [" + this.job.status.exportId + "]"));
        InputThread inputThread = null;
        OutputThread outputThread = null;
        try {
            inputThread = new InputThread();
            outputThread = new OutputThread();
            inputThread.start();
            outputThread.start();
            this.job.status.state = JobState.RUNNING;
            this.job.status.startDate = System.currentTimeMillis();
            this.job.status.inputDescription = this.job.input.describe();
            this.saveStatus(this.job.status);
            long delayMs = 800L;
            do {
                Thread.sleep(delayMs);
                delayMs = (long)Math.min((double)delayMs * 1.1, 15000.0);
                this.state.propagateFailureIfAny();
            } while (!this.state.isExportFinished());
            this.job.status.state = JobState.DONE;
            this.job.status.endDate = System.currentTimeMillis();
            this.job.status.writtenRecords = this.state.getNbRecords();
            this.job.status.totalRecords = this.state.getInputSize();
            if (outputThread.output != null) {
                this.job.status.writtenBytes = outputThread.output.getWrittenBytes();
            }
            if (this.job.status.targetFile != null) {
                FileExportPostprocessingHookHandler.onPostDataExportToFile(this.getOwner(), new File(this.job.status.targetFile), this.job.input);
            }
            exportResult = this.getResultOK();
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                this.job.status.state = JobState.ABORTED;
                this.job.status.endDate = System.currentTimeMillis();
                logger.warn((Object)"Export aborted", (Throwable)e);
                throw e;
                catch (CustomPythonKernelException e2) {
                    this.job.status.state = JobState.FAILED;
                    this.job.status.endDate = System.currentTimeMillis();
                    this.job.status.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e2);
                    this.job.status.logTail = e2.logTail;
                    logger.error((Object)"Export failed", (Throwable)e2);
                    throw e2;
                }
                catch (Exception e3) {
                    this.job.status.state = JobState.FAILED;
                    this.job.status.endDate = System.currentTimeMillis();
                    this.job.status.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e3);
                    logger.error((Object)"Export failed", (Throwable)e3);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                this.terminateSlaveThreads(inputThread, outputThread);
                this.saveStatus(this.job.status);
                PubSubPrivilegedClient client = new PubSubPrivilegedClient();
                client.publish(new ExportStateChangedEvent(this.job.status));
                logger.info((Object)("End of export thread [" + this.job.status.exportId + "] status=" + String.valueOf((Object)this.job.status.state)));
                throw throwable;
            }
        }
        this.terminateSlaveThreads(inputThread, outputThread);
        this.saveStatus(this.job.status);
        PubSubPrivilegedClient client = new PubSubPrivilegedClient();
        client.publish(new ExportStateChangedEvent(this.job.status));
        logger.info((Object)("End of export thread [" + this.job.status.exportId + "] status=" + String.valueOf((Object)this.job.status.state)));
        return exportResult;
    }

    public boolean waitForSource() throws InterruptedException {
        do {
            Thread.sleep(100L);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("wFS state=" + String.valueOf((Object)this.job.status.state) + " iii=" + this.state.isInputInitializedAndStarted()));
            }
            if (this.job.status.state == JobState.RUNNING) continue;
            logger.warn((Object)("Job status is not RUNNING anymore but " + String.valueOf((Object)this.job.status.state) + " with msg:" + this.job.status.errorMessage));
            return false;
        } while (!this.state.isInputInitializedAndStarted());
        return true;
    }

    static {
        JSON.registerAdapter(RemoteExportFutureThread.class, (Object)new JSON.Adapter<RemoteExportFutureThread>(){

            public RemoteExportFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                ExportService.RemoteExportJob exportJob = (ExportService.RemoteExportJob)ctx.deserialize(jsonObj.get("job"), ExportService.RemoteExportJob.class);
                return new RemoteExportFutureThread((AuthCtx)owner, exportJob);
            }

            public JsonElement serialize(RemoteExportFutureThread ft, Type type, JsonSerializationContext ctx) {
                JsonObject ret = new JsonObject();
                ret.add("owner", ctx.serialize((Object)ft.owner));
                ret.add("job", ctx.serialize((Object)ft.job));
                return ret;
            }
        });
    }

    private class InputThread
    extends Thread {
        private InputThread() {
        }

        @Override
        public void run() {
            try {
                try {
                    RemoteExportFutureThread.this.job.input.initialize(null, RemoteExportFutureThread.this.job.status.params.selection, RemoteExportFutureThread.this.state.cf);
                    RemoteExportFutureThread.this.state.setInputInitialized(RemoteExportFutureThread.this.job.input.getInputSize());
                    RemoteExportFutureThread.this.state.setSchema(RemoteExportFutureThread.this.job.input.getSchema());
                    RemoteExportFutureThread.this.job.input.stream(RemoteExportFutureThread.this.state.getOutputStream());
                    if (!RemoteExportFutureThread.this.state.monitoredOutputStream.isLastRowEmitted()) {
                        throw new Exception("lastRowEmitted() has not been called by the ExportInput");
                    }
                    RemoteExportFutureThread.this.state.setInputFinished();
                }
                finally {
                    RemoteExportFutureThread.this.job.input.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                RemoteExportFutureThread.this.state.setOutputFailed(new Exception("Export input thread has been interrupted"));
            }
            catch (Exception e) {
                RemoteExportFutureThread.this.state.setInputFailed(e);
            }
        }
    }

    private class OutputThread
    extends Thread {
        ExportOutput output;

        private OutputThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
            try {
                SerializedDataset serializedDataset;
                RemoteExportFutureThread.this.job.params.user = RemoteExportFutureThread.this.owner;
                this.output = ExportService.buildExportOutput(RemoteExportFutureThread.this.owner, RemoteExportFutureThread.this.job.params, ExportUtils.computeExportMethod(RemoteExportFutureThread.this.job.input, RemoteExportFutureThread.this.job.params), RemoteExportFutureThread.this.job.status, RemoteExportFutureThread.this.job.exportId);
                TableColoring coloring = ExportUtils.computeColoring(RemoteExportFutureThread.this.job.input);
                MemTable table = null;
                if (coloring != null && (serializedDataset = ExportUtils.getSerializedDataset(RemoteExportFutureThread.this.job.input)) != null) {
                    SerializedShakerScript.TableColoring tableColoring;
                    DSSAuthCtx authCtx = ExportUtils.getAuthCtx(RemoteExportFutureThread.this.job.input);
                    Dataset dataset = Dataset.fromSerialized(serializedDataset);
                    SerializedShakerScript script = new SerializedShakerScript();
                    script.contextProjectKey = script.getProjectKey(dataset);
                    if (coloring.scheme == ColoringDefinition.TableColoringScheme.ALL_COLUMNS_VALUES || coloring.scheme == ColoringDefinition.TableColoringScheme.MEANING_AND_STATUS) {
                        if (coloring.coloringGroups != null && coloring.coloringGroups.size() > 0) {
                            coloring.scheme = ColoringDefinition.TableColoringScheme.COLORING_GROUPS;
                        } else if (coloring.individualColumnsRules != null && coloring.individualColumnsRules.size() > 0) {
                            coloring.scheme = ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES;
                        }
                    }
                    script.coloring = tableColoring = ExportUtils.convertColoring(coloring);
                    script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                    MemScriptRunner.TableWithReport tableWithReport = ((DataService)SpringUtils.getBean(DataService.class)).get_NOTRANSACTION(dataset, script, null, null, false, (AuthCtx)authCtx);
                    if (tableWithReport != null && tableWithReport.table != null) {
                        table = tableWithReport.table;
                    }
                }
                APITicketService.Ticket ticket = apiTicketService.createTicket((AuthCtx)RemoteExportFutureThread.this.owner, "export-" + RemoteExportFutureThread.this.job.exportId, null);
                try {
                    Schema schema = RemoteExportFutureThread.this.state.waitForSchema();
                    ExportService.LocalExportJob localJob = new ExportService.LocalExportJob();
                    localJob.ticket = ticket;
                    this.output.setExportContext(new ExportOutput.ExportContext(table, coloring, RemoteExportFutureThread.this.warningsContext));
                    this.output.initialize(localJob, schema, RemoteExportFutureThread.this.state.cf);
                    this.output.stream(RemoteExportFutureThread.this.state.getInputStream());
                    RemoteExportFutureThread.this.state.setOutputFinished();
                }
                finally {
                    apiTicketService.expireTicket(ticket);
                    this.output.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                RemoteExportFutureThread.this.state.setOutputFailed(new Exception("Export output thread has been interrupted"));
            }
            catch (Exception e) {
                RemoteExportFutureThread.this.state.setOutputFailed(e);
            }
        }
    }
}

