/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.cache;

import com.dataiku.dip.llm.cache.ILLMCacheService;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.intercom.p.LLMCachePrivilegedIntercomController;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public class JEKLLMCacheService
implements ILLMCacheService {
    private LocalBackendPrivilegedIntercomAPIClient apiClient;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.cache");

    public JEKLLMCacheService() {
        if (RemoteRunEnvHelper.getEnv("DKU_BACKEND_PORT") == null) {
            logger.info((Object)"Not running in a DSS context - Unit test, ignoring");
            return;
        }
        this.apiClient = new LocalBackendPrivilegedIntercomAPIClient();
    }

    private <TQuery, TSettings, TResponse> ILLMCacheService.QueryCacheResult<TResponse> get(AuthCtx authCtx, String llmId, String contextProjectKey, String apiResource, TQuery query, TSettings settings, Class<TResponse> responseClass) {
        try {
            LLMCachePrivilegedIntercomController.CacheGetRequest cr = new LLMCachePrivilegedIntercomController.CacheGetRequest();
            cr.authCtxIdentifier = authCtx.getIdentifier();
            cr.contextProjectKey = contextProjectKey;
            cr.llmId = llmId;
            cr.query = query;
            cr.settings = settings;
            return (ILLMCacheService.QueryCacheResult)this.apiClient.postFormToJSON("/dip/api/pintercom/llm-cache/" + apiResource + "/get", TypeToken.getParameterized(ILLMCacheService.QueryCacheResult.class, (Type[])new Type[]{responseClass}), new Object[]{"requestObj", JSON.json(cr)});
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to lookup LLM response in cache", (Throwable)e);
            return new ILLMCacheService.QueryCacheResult();
        }
    }

    private <TQuery, TSettings, TResponse> void put(AuthCtx authCtx, String llmId, String contextProjectKey, String apiResource, TQuery query, TSettings settings, TResponse response) {
        try {
            LLMCachePrivilegedIntercomController.CachePutRequest cr = new LLMCachePrivilegedIntercomController.CachePutRequest();
            cr.authCtxIdentifier = authCtx.getIdentifier();
            cr.contextProjectKey = contextProjectKey;
            cr.llmId = llmId;
            cr.query = query;
            cr.settings = settings;
            cr.response = response;
            this.apiClient.postFormToJSON("/dip/api/pintercom/llm-cache/" + apiResource + "/put", Void.class, new Object[]{"requestObj", JSON.json(cr)});
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to put LLM response in cache", (Throwable)e);
        }
    }

    @Override
    public ILLMCacheService.QueryCacheResult<LLMClient.SimpleCompletionResponseOrError> get(AuthCtx authCtx, String llmId, String contextProjectKey, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings) {
        return this.get(authCtx, llmId, contextProjectKey, "completions", query, settings, LLMClient.SimpleCompletionResponseOrError.class);
    }

    @Override
    public void put(AuthCtx authCtx, String llmId, String contextProjectKey, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.SimpleCompletionResponseOrError response) {
        this.put(authCtx, llmId, contextProjectKey, "completions", query, settings, response);
    }

    @Override
    public ILLMCacheService.QueryCacheResult<LLMClient.SimpleEmbeddingResponseOrError> get(AuthCtx authCtx, String llmId, String contextProjectKey, LLMClient.EmbeddingQuery query, LLMClient.EmbeddingSettings settings) {
        return this.get(authCtx, llmId, contextProjectKey, "embeddings", query, settings, LLMClient.SimpleEmbeddingResponseOrError.class);
    }

    @Override
    public void put(AuthCtx authCtx, String llmId, String contextProjectKey, LLMClient.EmbeddingQuery query, LLMClient.EmbeddingSettings settings, LLMClient.SimpleEmbeddingResponseOrError result) {
        this.put(authCtx, llmId, contextProjectKey, "embeddings", query, settings, result);
    }
}

