/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.vertex;

import com.dataiku.dip.connections.VertexAILLMConnection;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang.StringUtils;

public class VertexPricing {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.vertex.pricing");

    private VertexPricing() {
    }

    public static Double getVertexPromptCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_20.id)) {
            return 1.5E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_20.id)) {
            return 7.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_25.id)) {
            return 1.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_25.id)) {
            return 3.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_PRO_25.id)) {
            return 0.00125;
        }
        logger.warn((Object)("Vertex model: " + model + " is unknown to VertexPricing"));
        return 0.0;
    }

    public static Double getVertexAICompletionCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_20.id)) {
            return 6.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_20.id)) {
            return 3.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_25.id)) {
            return 0.0025;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_FLASH_LITE_25.id)) {
            return 4.0E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_PRO_25.id)) {
            return 0.01;
        }
        logger.warn((Object)("Vertex model: " + model + " is unknown to VertexPricing"));
        return 0.0;
    }

    public static double getVertexAIEmbeddingCostPer1KChars(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.GEMINI_EMBEDDING.id)) {
            return 1.5E-4;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.TEXT_EMBEDDING.id)) {
            return 2.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.TEXT_MULTILANG_EMBEDDING.id)) {
            return 2.5E-5;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.MULTIMODAL_EMBEDDING.id)) {
            return 2.0E-4;
        }
        logger.warn((Object)("Unknown text embedding pricing for Vertex model: " + model));
        return 0.0;
    }

    public static double getVertexAIEmbeddingCostPerImage(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(VertexAILLMConnection.HardcodedVertexModel.MULTIMODAL_EMBEDDING.id)) {
            return 1.0E-4;
        }
        logger.warn((Object)("Unknown image embedding pricing for Vertex model: " + model));
        return 0.0;
    }
}

