/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.model;

import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.model.SideResponseKey;
import com.dataiku.dip.pivot.backend.model.SimpleAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.boxplots.PTBoxplotsRequest;
import com.dataiku.dip.pivot.backend.model.density.PT2DDensityRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrAdminRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapRawGeometryRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapScatterRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableFiltersRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableWebappRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterMultiplePairsRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterRequest;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UIModel
public abstract class PivotTableRequest {
    public RequestType type;
    public List<RowFilter> filters = new ArrayList<RowFilter>();
    public boolean computeUsableColumns;
    public Map<SideResponseKey, List<PivotTableRequest>> sideRequests = new HashMap<SideResponseKey, List<PivotTableRequest>>();

    public boolean isFiltered() {
        for (RowFilter rf : this.filters) {
            if (!rf.active) continue;
            switch (rf.filterType) {
                case ALPHANUM: 
                case EXPLICIT: {
                    return true;
                }
                case ALPHANUM_FACET: {
                    if (!rf.excludeOtherValues && (rf.excludedValues == null || rf.excludedValues.isEmpty())) break;
                    return true;
                }
                case INTERACTIVE_DATE_FACET: 
                case DATE_FACET: {
                    if (rf.dateFilterType == ChartFilter.DateFilterType.PART && (rf.excludeOtherValues || rf.excludedValues != null && !rf.excludedValues.isEmpty())) {
                        return true;
                    }
                }
                case NUMERICAL_FACET: {
                    boolean excludeEmptyValues;
                    boolean includeWholeRange = rf.minValue == null && rf.maxValue == null;
                    boolean bl = excludeEmptyValues = !rf.getIncludeEmptyValuesOrDefault();
                    if (includeWholeRange && !excludeEmptyValues) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected static <T> JsonSerializer<T> getSerializer(RequestType requestType) {
        return (task, type, ctx) -> {
            JsonElement jsonElement = new Gson().toJsonTree(task);
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            jsonObj.addProperty("type", requestType.name());
            return jsonObj;
        };
    }

    static {
        JSON.registerAdapter(PivotTableRequest.class, (jsonElement, scriptType, jsonDeserializationContext) -> {
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            RequestType type = RequestType.valueOf(jsonObj.get("type").getAsString());
            switch (type) {
                case AGGREGATED_ND: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PivotTableTensorRequest.class);
                }
                case NO_PIVOT_AGGREGATED: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, SimpleAggregatedRequest.class);
                }
                case AGGREGATED_GEO_ADMIN: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTMapAggrAdminRequest.class);
                }
                case AGGREGATED_GEO_GRID: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTMapAggrGridRequest.class);
                }
                case BOXPLOTS: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTBoxplotsRequest.class);
                }
                case MAP_SCATTER_NON_AGGREGATED: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTMapScatterRequest.class);
                }
                case SCATTER_NON_AGGREGATED: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTScatterRequest.class);
                }
                case SCATTER_MULTIPLE_PAIRS_NON_AGGREGATED: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTScatterMultiplePairsRequest.class);
                }
                case DENSITY_2D: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PT2DDensityRequest.class);
                }
                case RAW_GEOMETRY: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PTMapRawGeometryRequest.class);
                }
                case WEBAPP: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PivotTableWebappRequest.class);
                }
                case FILTERS: {
                    return (PivotTableRequest)jsonDeserializationContext.deserialize(jsonElement, PivotTableFiltersRequest.class);
                }
            }
            throw new Error("unreachable");
        });
    }

    public static enum RequestType {
        AGGREGATED_ND,
        AGGREGATED_GEO_ADMIN,
        AGGREGATED_GEO_GRID,
        BOXPLOTS,
        SCATTER_NON_AGGREGATED,
        MAP_SCATTER_NON_AGGREGATED,
        SCATTER_MULTIPLE_PAIRS_NON_AGGREGATED,
        DENSITY_2D,
        RAW_GEOMETRY,
        NO_PIVOT_AGGREGATED,
        WEBAPP,
        FILTERS;

    }
}

