/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetMeta;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.plugins.LoadedJavaDataset;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaDatasetsService
extends CustomJavaElementService<CustomJavaDatasetDesc, LoadedJavaDataset> {
    @Override
    public String getFolderName() {
        return "java-connectors";
    }

    @Override
    public String getPrefix() {
        return "connector";
    }

    @Override
    protected String getCodeExtension(LoadedJavaDataset desc) {
        return ".java";
    }

    @Override
    public Class<CustomJavaDatasetDesc> getDescClass() {
        return CustomJavaDatasetDesc.class;
    }

    @Override
    public Class<LoadedJavaDataset> getLoadedDescClass() {
        return LoadedJavaDataset.class;
    }

    @Override
    protected void removeElement(LoadedJavaDataset desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "CustomJava_" + elementId;
    }

    @Override
    protected LoadedJavaDataset load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedJavaDataset loaded = new LoadedJavaDataset(elementType, pluginId, elementId, (CustomJavaDatasetDesc)JSON.parseFile((File)file, CustomJavaDatasetDesc.class));
        CustomJavaDatasetMeta meta = new CustomJavaDatasetMeta(loaded);
        DatasetHandlerFactory.checkDuplicateDatasetMeta(pluginId, elementId, elementType, CustomJavaDatasetMeta.class);
        DatasetHandlerFactory.registerDatasetType(meta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomJavaDatasetDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomJavaDatasetsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.datasetClass)) {
                    this.withFatal("Java plugin connectors require a \"datasetClass\" field.");
                }
                return this.messages;
            }
        }.validate();
    }
}

