/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.badges.ProjectBadges;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.futures.FutureHistoryService;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.ActiveBundleState;
import com.dataiku.dip.projects.importexport.model.BundleChangelog;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.ImportedBundleState;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.exceptions.TransactionContextError;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.ZipUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class CommonBundleUtils {
    public static BundleDetails getDetailsFromArchive(File archive) throws ZipException, IOException {
        BundleDetails ret = new BundleDetails();
        ret.bundleId = CommonBundleUtils.bundleIdFromArchiveName(archive);
        try (ZipFile zipFile = new ZipFile(archive);){
            ZipEntry manifestEntry;
            ProjectBadges projectBadges;
            ZipEntry badgesEntry;
            ZipEntry projectStandardsRunReportEntry;
            ZipEntry changelogEntry = zipFile.getEntry("changelog.json");
            if (changelogEntry != null) {
                ret.changelog = (BundleChangelog)JSON.parse((InputStream)zipFile.getInputStream(changelogEntry), BundleChangelog.class);
            }
            if ((projectStandardsRunReportEntry = zipFile.getEntry("project-standards-bundle-report.json")) != null) {
                ret.projectStandardsRunReport = (ProjectStandardsRunReport)JSON.parse((InputStream)zipFile.getInputStream(projectStandardsRunReportEntry), ProjectStandardsRunReport.class);
            }
            if ((badgesEntry = zipFile.getEntry("project_config/badges.json")) != null && (projectBadges = (ProjectBadges)JSON.parse((InputStream)zipFile.getInputStream(badgesEntry), ProjectBadges.class)) != null) {
                ret.typeBadges = projectBadges.typeBadges.list();
            }
            if ((manifestEntry = zipFile.getEntry("export-manifest.json")) != null) {
                ret.exportManifest = (ExportedProject)JSON.parse((InputStream)zipFile.getInputStream(manifestEntry), ExportedProject.class);
                ret.contentSummary = ret.exportManifest.actualContent;
                ret.projectStandardsSkipped = ret.exportManifest.projectStandardsSkipped;
                if (Integer.parseInt(ret.exportManifest.generatedWithDSSConfVersion.substring(0, 3)) < 131) {
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith("project_config/datasets/") || !entryName.endsWith(".data")) continue;
                        BundleContentSummary.IncludedDataset editableDataset = new BundleContentSummary.IncludedDataset();
                        editableDataset.name = FilenameUtils.getBaseName((String)entryName);
                        editableDataset.type = "Inline";
                        editableDataset.usedTransferMethod = ProjectExportOptions.DatasetDataTransferMethod.INLINE;
                        editableDataset.size = entry.getSize();
                        ZipEntry changesEntry = zipFile.getEntry("project_config/datasets/" + editableDataset.name + ".changes");
                        if (changesEntry != null) {
                            editableDataset.size += changesEntry.getSize();
                        }
                        ret.exportManifest.actualContent.includedDatasets.add(editableDataset);
                    }
                }
            }
        }
        return ret;
    }

    public void summarizeFromArchive(File archive, BundleInfoBase ret) throws ZipException, IOException {
        ret.bundleId = CommonBundleUtils.bundleIdFromArchiveName(archive);
        try (ZipFile zipFile = new ZipFile(archive);){
            ProjectBadges projectBadges;
            ZipEntry badgesEntry;
            ZipEntry projectStandardsRunReportEntry;
            ZipEntry manifestEntry = zipFile.getEntry("export-manifest.json");
            if (manifestEntry != null) {
                ret.exportManifest = (ExportedProject)JSON.parse((InputStream)zipFile.getInputStream(manifestEntry), ExportedProject.class);
                ret.contentSummary = ret.exportManifest.actualContent;
            }
            if ((projectStandardsRunReportEntry = zipFile.getEntry("project-standards-bundle-report.json")) != null) {
                ret.projectStandardsRunReport = (ProjectStandardsRunReport)JSON.parse((InputStream)zipFile.getInputStream(projectStandardsRunReportEntry), ProjectStandardsRunReport.class);
            }
            if ((badgesEntry = zipFile.getEntry("project_config/badges.json")) != null && (projectBadges = (ProjectBadges)JSON.parse((InputStream)zipFile.getInputStream(badgesEntry), ProjectBadges.class)) != null) {
                ret.typeBadges = projectBadges.typeBadges.list();
            }
        }
    }

    public static JsonObject getProjectVariablesFromArchive(File archive) throws IOException {
        JsonObject projectVariables = ZipUtils.readFileContentJSON(archive, "project_config/variables.json", JsonObject.class);
        if (projectVariables == null) {
            return new JsonObject();
        }
        return projectVariables;
    }

    public static HashMultimap<String, String> getIncludedSavedModelVersionsInArchive(File bundleArchive) throws IOException {
        HashMultimap smVersionMap = HashMultimap.create();
        try (ZipFile zipFile = new ZipFile(bundleArchive);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String[] entryPart;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entry.isDirectory() || !entryName.startsWith("saved_models/") || (entryPart = entryName.split("/")).length != 4 || !entryPart[2].equals("versions")) continue;
                String smId = entryPart[1];
                String version = entryPart[3];
                smVersionMap.put((Object)smId, (Object)version);
            }
        }
        return smVersionMap;
    }

    public static JsonObject getSavedModelConfigFromArchive(File archive, String smId) throws IOException {
        JsonObject smConfig = ZipUtils.readFileContentJSON(archive, "project_config/saved_models/" + smId + ".json", JsonObject.class);
        if (smConfig == null) {
            return new JsonObject();
        }
        return smConfig;
    }

    public static List<Scenario> getScenariosFromArchive(File archive) throws IOException {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        try (ZipFile zipFile = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith("project_config/scenarios/") || !entryName.endsWith(".json")) continue;
                Scenario scenario = (Scenario)JSON.parse((InputStream)zipFile.getInputStream(entry), Scenario.class);
                scenario.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/scenarios/", (String)".json"));
                scenarios.add(scenario);
            }
        }
        return scenarios;
    }

    public static List<String> getProjectTagsFromArchive(File archive) throws IOException {
        SerializedProject project = ZipUtils.readFileContentJSON(archive, "project_config/params.json", SerializedProject.class);
        if (project == null || project.tags == null) {
            return Collections.emptyList();
        }
        return project.tags;
    }

    public static List<TypeBadge> getTypeBadgesFromArchive(File archive) throws IOException {
        ProjectBadges badges = ZipUtils.readFileContentJSON(archive, "project_config/badges.json", ProjectBadges.class);
        if (badges == null) {
            return Collections.emptyList();
        }
        return badges.typeBadges.list();
    }

    private static String bundleIdFromArchiveName(File archive) throws IOException {
        Object[] fileNameChunks = archive.getName().split("-");
        if (fileNameChunks.length < 4) {
            throw new IOException("Invalid bundle name " + String.valueOf(archive));
        }
        String bundleId = StringUtils.join((Object[])ArrayUtils.subarray((Object[])fileNameChunks, (int)3, (int)fileNameChunks.length), (String)"-");
        return bundleId.replace(".zip", "");
    }

    public static boolean hasActiveBundle(String projectKey) throws TransactionContextError, IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return CommonBundleUtils.hasActiveBundleInternal(TransactionContext.retrieveRead(), projectKey);
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            boolean bl = CommonBundleUtils.hasActiveBundleInternal((TransactionRef)t, projectKey);
            return bl;
        }
    }

    public static boolean hasActiveBundleInternal(TransactionRef t, String projectKey) throws TransactionContextError, IOException {
        RelFile rf = new RelFile(new String[]{"projects", projectKey, "active-bundle.json"});
        return t.isFile(rf);
    }

    public static String getActiveBundleId(String projectKey) throws TransactionContextError, IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return CommonBundleUtils.getActiveBundleIdInternal(TransactionContext.retrieveRead(), projectKey);
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            String string = CommonBundleUtils.getActiveBundleIdInternal((TransactionRef)t, projectKey);
            return string;
        }
    }

    public static String getActiveBundleIdInternal(TransactionRef t, String projectKey) throws TransactionContextError, IOException {
        String bundleId = null;
        RelFile rf = new RelFile(new String[]{"projects", projectKey, "active-bundle.json"});
        if (!t.isFile(rf)) {
            throw new IllegalArgumentException("Could not determine active bundle id for " + projectKey + ": " + String.valueOf(rf));
        }
        bundleId = ((ActiveBundleState)t.readObjectUnsafe((RelFile)rf, ActiveBundleState.class)).bundleId;
        return bundleId;
    }

    public static ActiveBundleState getActiveBundleState(String projectKey) throws TransactionContextError, IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return CommonBundleUtils.getActiveBundleStateInternal(TransactionContext.retrieveRead(), projectKey);
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            ActiveBundleState activeBundleState = CommonBundleUtils.getActiveBundleStateInternal((TransactionRef)t, projectKey);
            return activeBundleState;
        }
    }

    public static ActiveBundleState getActiveBundleStateInternal(TransactionRef t, String projectKey) throws TransactionContextError, IOException {
        ActiveBundleState bundleState = null;
        RelFile rf = new RelFile(new String[]{"projects", projectKey, "active-bundle.json"});
        if (!t.isFile(rf)) {
            throw new IllegalArgumentException("Could not determine active bundle id for " + projectKey + ": " + String.valueOf(rf));
        }
        bundleState = (ActiveBundleState)t.readObjectUnsafe(rf, ActiveBundleState.class);
        return bundleState;
    }

    public static class BundleDetails
    extends BundleInfoBase {
        public BundleChangelog changelog;
    }

    public static class BundleInfoBase {
        public String bundleId;
        public BundleContentSummary contentSummary;
        public ExportedProject exportManifest;
        @Nullable
        public ProjectStandardsRunReport projectStandardsRunReport;
        @Nullable
        public Boolean projectStandardsSkipped;
        public List<TypeBadge> typeBadges = new ArrayList<TypeBadge>();
    }

    public static class BundleInfoList {
        public List<BundleInfoBase> bundles = new ArrayList<BundleInfoBase>();
    }

    static class ImportedBundle
    extends BundleInfoBase {
        ImportedBundleState importState;

        ImportedBundle() {
        }
    }

    public static class ExportedBundleSummary
    extends BundleInfoBase {
        public BundleState state;
        FutureHistoryService.FutureHistoryItem futureItem;
        PublishedBundleState publishedBundleState;
    }

    static class PublishedBundleState {
        long publishedOn;
        String publishedBy;
        String publishedProjectKey;

        PublishedBundleState() {
        }
    }

    public static enum BundleState {
        BUILDING,
        BUILT,
        FAILED,
        ABORTED;

    }
}

