/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.pig;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.AbstractPigRecipeRunner;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.pig.PigSchemaTools;
import com.dataiku.dip.pig.PigScriptPreprocessor;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.hproxy.model.pig.ValidationResult;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PigInternalRunner
extends AbstractPigRecipeRunner
implements AbortableRecipeRunner {
    private boolean overwriteTargetSchema;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    protected DatasetWritingService datasetWritingService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.internal.pig");

    public PigInternalRunner(JobActivity activity, boolean overwriteTargetSchema) {
        super(activity);
        SpringUtils.getInstance().autowire((Object)this);
        this.overwriteTargetSchema = overwriteTargetSchema;
    }

    public void execute(String pigScript) throws Exception {
        this.doInit(pigScript);
        if (this.overwriteTargetSchema) {
            this.handleSchemaOverwrite(pigScript, true);
        } else {
            this.handleSchemaOverwrite(pigScript, false);
        }
        this.doRun();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleSchemaOverwrite(String pigScript, boolean doOverwrite) throws Exception {
        PigScriptPreprocessor preprocessor = new PigScriptPreprocessor(this.authCtxService.getAuthCtx(), this.datasetsDAO, this.variablesService.getForProject(this.recipe.getProjectKey()), this.recipe.getProjectKey(), this.subgraph, pigScript, true);
        preprocessor.preprocess();
        String preprocessedScript = preprocessor.getPreprocessed();
        ValidationResult rawPigResponse = KernelSession.doPigCheck(this.recipe.getProjectKey(), preprocessedScript);
        if (!rawPigResponse.ok) throw ErrorContext.iae((String)("Could not execute script, got error from Pig: " + rawPigResponse.errorMessage + " at line " + rawPigResponse.errorLine + ":" + rawPigResponse.errorOffset));
        List<PigSchemaTools.Suggestion> suggestions = PigSchemaTools.generateSuggestions(this.datasetsDAO, this.subgraph.getTargetsMap(), rawPigResponse.relationSchemas, preprocessor.getDkuStoreMapping());
        if (suggestions.size() <= 0) return;
        if (doOverwrite) {
            for (PigSchemaTools.Suggestion sugg : suggestions) {
                logger.info((Object)("Will update schema of  " + sugg.dataset.name));
                logger.info((Object)("Because:\n " + StringUtils.join(sugg.reasons, (String)"\n")));
                String fullName = sugg.dataset.projectKey + "." + sugg.dataset.name;
                logger.info((Object)"Overriding the schema of the dataset");
                this.datasetWritingService.writeDatasetSchema(TransactionContext.retrieveWrite().getUser(), DatasetLocUtils.resolveFull(fullName), sugg.dataset.getSchema(), false, "pig");
                KernelSession.propagateSchemaToJekOrBackend(fullName, sugg.dataset.getSchema());
                this.datasetsDAO.save(sugg.dataset);
            }
            return;
        } else {
            StringBuilder sb = new StringBuilder();
            for (PigSchemaTools.Suggestion sugg : suggestions) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(sugg.dataset.name);
            }
            throw ErrorContext.iae((String)("Could not execute script, incompatible output schema(s) on dataset(s): " + sb.toString()));
        }
    }

    @Override
    public void run() {
        throw new Error("unreachable");
    }
}

