/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.MergeGrouping;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.recipes.eda.stats.PopulationBoxPlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractMultiSampleTestStat
extends AbstractTestStat {
    public String testColumn;
    public String groupByColumn;

    protected AbstractMultiSampleTestStat(String testColumn, String groupByColumn) {
        this.testColumn = testColumn;
        this.groupByColumn = groupByColumn;
    }

    protected AbstractMultiSampleTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        row.put(cf.column("populations_defined_by"), this.groupByColumn);
        row.put(cf.column("variable"), this.testColumn);
    }

    protected abstract Grouping getPopulationGrouping();

    protected abstract Computation getTestComputation(StatsTestRecipePayloadParams<?> var1);

    @Override
    public MultiComputation getComputationPlan(StatsTestRecipePayloadParams<?> payloadParams) {
        Grouping grouping = this.getPopulationGrouping();
        return new MultiComputation(new GroupedComputation(BoxPlotFragment.getComputationPlan(this.testColumn), grouping), new GroupedComputation(BoxPlotFragment.getComputationPlan(this.testColumn), new MergeGrouping(grouping)), this.getTestComputation(payloadParams));
    }

    @Override
    public List<Row> extractRows(ComputationResult result, StatsTestRecipePayloadParams<?> payloadParams, ColumnFactory cf, RowFactory rf) {
        double significanceLevel = payloadParams.significanceLevel();
        List<String> warnings = result.collectWarnings();
        Collection<String> errors = result.collectErrors();
        if (!result.isAvailable()) {
            Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
            return Collections.singletonList(row);
        }
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        ComputationResult populationBoxPlotResult = mcr.get(0);
        HashSet<String> boxPlotWarnings = new HashSet<String>(populationBoxPlotResult.collectWarnings());
        HashSet<String> boxPlotErrors = new HashSet<String>(populationBoxPlotResult.collectErrors());
        List<PopulationBoxPlot> populationBoxPlots = Collections.emptyList();
        if (populationBoxPlotResult.isAvailable()) {
            populationBoxPlots = this.extractPopulationBoxPlots(populationBoxPlotResult.asAvailable());
        }
        ComputationResult mergedBoxPlotResult = mcr.get(1);
        boxPlotWarnings.addAll(mergedBoxPlotResult.collectWarnings());
        boxPlotErrors.addAll(mergedBoxPlotResult.collectErrors());
        BoxPlotFragment mergedBoxPlot = null;
        if (mergedBoxPlotResult.isAvailable()) {
            List<ComputationResult> results = mergedBoxPlotResult.asGrouped().results;
            if (results.size() > 1) {
                throw new IllegalArgumentException(String.format("Expected exactly one group for the merged population, got %d", results.size()));
            }
            mergedBoxPlot = BoxPlotFragment.build(results.get(0));
        }
        return this.extractTestRows(mcr.get(2), payloadParams, populationBoxPlots, mergedBoxPlot, boxPlotWarnings, boxPlotErrors, cf, rf);
    }

    protected abstract List<Row> extractTestRows(ComputationResult var1, StatsTestRecipePayloadParams<?> var2, List<PopulationBoxPlot> var3, @Nullable BoxPlotFragment var4, Collection<String> var5, Collection<String> var6, ColumnFactory var7, RowFactory var8);

    protected static List<String> extractPopulationValues(Filter filter) {
        if (filter instanceof AnumFilter) {
            AnumFilter anumFilter = (AnumFilter)filter;
            return new ArrayList<String>(anumFilter.values);
        }
        throw new IllegalArgumentException(String.format("Unexpected filter resulting from group-by: %s", ((Object)((Object)filter)).getClass().getSimpleName()));
    }

    protected List<PopulationBoxPlot> extractPopulationBoxPlots(AvailableResult result) {
        ArrayList<PopulationBoxPlot> populationBoxPlots = new ArrayList<PopulationBoxPlot>();
        for (GroupedComputation.GroupResult gr : result.asGrouped()) {
            PopulationBoxPlot boxPlot = new PopulationBoxPlot(AbstractMultiSampleTestStat.extractPopulationValues(gr.filter), BoxPlotFragment.build(gr.result));
            populationBoxPlots.add(boxPlot);
        }
        return populationBoxPlots;
    }
}

