/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportPredictedDataInput;
import com.dataiku.dip.export.input.ExportTimeseriesResiduals;
import com.dataiku.dip.export.input.ExportTrainTestDataInput;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MLCommonController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ExportService exportService;

    @AuditedCall(value={"msgType", "ml-model-save-meta", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/save-model-user-meta"})
    public void setModelMeta(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam ModelUserMeta data) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.mlBaseService.saveModelUserMeta(fmi, data);
        this.pubSubService.publish((DSSEvent)new ModelVersionChangedEvent(fullModelId));
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/delete-models"})
    public void deleteModels(HttpServletRequest req, HttpServletResponse resp, @RequestParam String list) throws Exception {
        List fullModelIds = (List)JSON.parse((String)list, List.class);
        try (Transaction t = this.transactionService.beginRead();){
            for (String fmiStr : fullModelIds) {
                FullModelId fmi = FullModelId.parse(fmiStr);
                this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                this.auditTrailService.generic("ml-model-delete").with("modelId", fmiStr).emit();
            }
            this.mlBaseService.deleteModels(fullModelIds);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/export-model-dataset"})
    @ResponseBody
    public ExportStatus exportModelDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam ExportParams exportParams) throws Exception {
        try {
            AuthCtx authCtx;
            FullModelId parsedFullModelId = FullModelId.parse(fullModelId);
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.failIfNoReadAccess(authCtx, parsedFullModelId.getUnderlyingStore(), parsedFullModelId.getProjectKey());
            }
            ExportTrainTestDataInput input = new ExportTrainTestDataInput(parsedFullModelId);
            ExportStatus ret = this.exportService.handleExportRequest(authCtx, input, exportParams);
            this.auditTrailService.generic("ml-model-export-dataset").with("modelId", fullModelId).with("destinationDatasetName", exportParams.destinationDatasetName).with("destinationDatasetConnection", exportParams.destinationDatasetConnection).with("overwriteDestinationDataset", exportParams.overwriteDestinationDataset).emit();
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-model-export-dataset", (Throwable)e).with("modelId", fullModelId).with("destinationDatasetName", exportParams.destinationDatasetName).with("destinationDatasetConnection", exportParams.destinationDatasetConnection).with("overwriteDestinationDataset", exportParams.overwriteDestinationDataset).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/export-model-predicted-data"})
    @ResponseBody
    public ExportStatus exportModelPredictedData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam ExportParams exportParams) throws Exception {
        try {
            AuthCtx authCtx;
            FullModelId parsedFullModelId = FullModelId.parse(fullModelId);
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.failIfNoReadAccess(authCtx, parsedFullModelId.getUnderlyingStore(), parsedFullModelId.getProjectKey());
            }
            ExportPredictedDataInput input = new ExportPredictedDataInput(parsedFullModelId, authCtx);
            ExportStatus ret = this.exportService.handleExportRequest(authCtx, input, exportParams);
            this.auditTrailService.generic("ml-model-export-predicted-data").with("modelId", fullModelId).with("destinationDatasetName", exportParams.destinationDatasetName).with("destinationDatasetConnection", exportParams.destinationDatasetConnection).with("overwriteDestinationDataset", exportParams.overwriteDestinationDataset).emit();
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-model-export-predicted-data", (Throwable)e).with("modelId", fullModelId).with("destinationDatasetName", exportParams.destinationDatasetName).with("destinationDatasetConnection", exportParams.destinationDatasetConnection).with("overwriteDestinationDataset", exportParams.overwriteDestinationDataset).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/export-timeseries-residuals"})
    @ResponseBody
    public ExportStatus exportTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam ExportParams exportParams) throws Exception {
        try {
            AuthCtx authCtx;
            FullModelId parsedFullModelId = FullModelId.parse(fullModelId);
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.failIfNoReadAccess(authCtx, parsedFullModelId.getUnderlyingStore(), parsedFullModelId.getProjectKey());
            }
            ExportTimeseriesResiduals input = new ExportTimeseriesResiduals(parsedFullModelId);
            exportParams.filenameBase = "residuals_" + fullModelId;
            ExportStatus ret = this.exportService.handleExportRequest(authCtx, input, exportParams);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

