/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.llm;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolUsage;
import com.dataiku.dip.agents.tools.AgentToolsCRUDService;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.agents.tools.mcp.GenericStdioMCPClientTool;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.scheduler.reports.TemplatesDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AgentToolsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private AgentToolsCRUDService crudService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;
    @Autowired
    private PermissionsService permissionsService;

    @AuditedCall(value={"msgType", "agent-tools-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-tools/list"})
    @ResponseBody
    public List<AgentTool> list(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<AgentTool> list = this.listAgentToolsWithForeign(authCtx, projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "agent-tools-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-tools/list-heads"})
    @ResponseBody
    public List<AgentTool.AgentToolListItem> listHeads(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="false") boolean withForeign) throws Exception {
        List<AgentTool.AgentToolListItem> heads;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            heads = this.listAgentToolListItems(authCtx, projectKey, withForeign);
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        return heads;
    }

    @AuditedCall(value={"msgType", "agent-tools-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-tools/list-available"})
    @ResponseBody
    public List<AgentTool.AgentToolListItem> listAvailable(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        List<AgentTool.AgentToolListItem> heads;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            heads = this.listAgentToolListItems(authCtx, projectKey, true);
        }
        return heads;
    }

    private List<AgentTool.AgentToolListItem> listAgentToolListItems(AuthCtx authCtx, String projectKey, boolean withForeign) throws IOException, DKUSecurityException {
        List<AgentTool> list = withForeign ? this.listAgentToolsWithForeign(authCtx, projectKey) : this.agentToolsDAO.listUnsafe(projectKey);
        ArrayList<AgentTool.AgentToolListItem> heads = new ArrayList<AgentTool.AgentToolListItem>();
        for (AgentTool at : list) {
            AgentTool.AgentToolListItem item = new AgentTool.AgentToolListItem(at);
            this.taggableObjectsService.setEditionInfoFromTags(at, item);
            heads.add(item);
        }
        return heads;
    }

    private List<AgentTool> listAgentToolsWithForeign(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        List<AccessibleObjectsService.AccessibleObject> objects = this.accessibleObjectsService.listAccessibleObjectsUnsafe(authCtx, projectKey, ITaggingService.TaggableType.AGENT_TOOL, SerializedProject.ReaderAuthorization.Mode.READ);
        return objects.stream().map(o -> (AgentTool)o.object).toList();
    }

    @AuditedCall(value={"msgType", "agent-tool-get", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/agent-tools/get"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentTool getAgentTool(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AgentTool agentTool = this.crudService.getMandatoryUnsafe(projectKey, id);
            return agentTool;
        }
    }

    @AuditedCall(value={"msgType", "agent-tool-get-descriptor", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/agent-tools/get-descriptor"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentToolMeta.ToolDescriptor getAgentToolDescriptor(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AgentToolMeta meta;
        AgentTool tool;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            tool = this.crudService.getMandatoryUnsafe(projectKey, id);
            meta = AgentToolsRegistry.getMeta(tool.type);
            meta.checkAccessDependency(authCtx, tool);
        }
        AgentToolMeta.ToolDescriptor desc = meta.getResultingDescriptor(authCtx, projectKey, tool);
        return desc;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/agent-tools/has-sample-query"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean hasSampleQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AgentTool tool;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            tool = this.crudService.getMandatoryUnsafe(projectKey, id);
        }
        AgentToolMeta meta = AgentToolsRegistry.getMeta(tool.type);
        return meta.supportsLoadSampleQuery;
    }

    @AuditedCall(value={"projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/agent-tools/load-sample-query"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonObject loadSampleQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AgentToolMeta meta;
        AgentTool tool;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            tool = this.crudService.getMandatoryUnsafe(projectKey, id);
            meta = AgentToolsRegistry.getMeta(tool.type);
            meta.checkAccessDependency(authCtx, tool);
        }
        return meta.loadSampleQuery(authCtx, projectKey, tool);
    }

    @AuditedCall(value={"msgType", "agent-tool-get-metadata", "projectKey", "${projectKey}", "agentToolRef", "${agentToolRef}"})
    @RequestMapping(value={"/api/agent-tools/get-full-info"})
    @ResponseBody
    public NavigatorService.AgentToolFullInfo getFullInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentToolRef) throws Exception {
        NavigatorService.AgentToolFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, agentToolRef);
            this.projectsService.failIfNoAgentToolReadUseAccess(u, loc, projectKey);
            info = this.navigatorService.getAgentToolFullInfo(loc, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditedCall(value={"msgType", "agent-tool-get-usage", "projectKey", "${projectKey}", "agentToolId", "${id}"})
    @RequestMapping(value={"/api/agent-tools/get-usage"})
    @ResponseBody
    public AgentToolUsage getUsage(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        List<SavedModel> visualAgents;
        AgentTool tool;
        AgentToolUsage usage = new AgentToolUsage();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            tool = this.crudService.getMandatory(projectKey, id);
            visualAgents = this.savedModelsDAO.listUnsafe(projectKey).stream().filter(sm -> sm.savedModelType == SavedModel.SavedModelType.TOOLS_USING_AGENT).toList();
        }
        usage.agents = new ArrayList<SavedModel>();
        block5: for (SavedModel sm2 : visualAgents) {
            SavedModel.SavedModelInlineVersion activeVersion = sm2.getActiveSaveModelInlineVersion();
            if (activeVersion == null || activeVersion.toolsUsingAgentSettings == null) continue;
            for (SavedModel.UsedTool toolObj : activeVersion.toolsUsingAgentSettings.tools) {
                if (!StringUtils.equals((String)toolObj.toolRef, (String)tool.id)) continue;
                usage.agents.add(sm2);
                continue block5;
            }
        }
        return usage;
    }

    @AuditedCall(value={"msgType", "agent-tool-test", "projectKey", "${projectKey}", "agentToolId", "${id}"})
    @RequestMapping(value={"/api/agent-tools/test"})
    @ResponseBody
    public AgentToolsCRUDService.ToolQuickTestResponse toolQuickTest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String query) throws Exception {
        AgentTool tool;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            tool = this.crudService.getMandatory(projectKey, id);
            AgentToolsRegistry.getMeta(tool.type).checkAccessDependency(authCtx, tool);
        }
        return this.crudService.test(authCtx, tool, projectKey, query, "DKU_MANAGED_TOOL_CALL", true);
    }

    @AuditedCall(value={"msgType", "agent-tool-stop-dev-kernel", "projectKey", "${projectKey}", "agentToolId", "${id}"})
    @RequestMapping(value={"/api/agent-tools/stop-dev-kernel"}, method={RequestMethod.POST})
    public void toolStopDevKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AgentTool tool;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            tool = this.crudService.getMandatory(projectKey, id);
        }
        if (!this.crudService.stopDevKernel(authCtx, tool, projectKey)) {
            throw new NotFoundException("Dev kernel not running");
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-tools/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Id create(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String proto) throws Exception {
        ProtoAgentTool protoObj = (ProtoAgentTool)JSON.parse((String)proto, ProtoAgentTool.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(user);
            Id newId = new Id(this.crudService.create(user, projectKey, protoObj));
            t.commit("Created agent tool " + newId.id);
            this.auditTrailService.generic("agent-tool-create").with("projectKey", projectKey).with("agentToolId", newId.id).emit();
            Id id = newId;
            return id;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-tools/create-from-kb"}, method={RequestMethod.POST})
    @ResponseBody
    public Id createFromKB(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String proto, @RequestParam String knowledgeBankRef) throws Exception {
        ProtoAgentTool protoObj = (ProtoAgentTool)JSON.parse((String)proto, ProtoAgentTool.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(user);
            Id newId = new Id(this.crudService.createFromKB(user, projectKey, protoObj, knowledgeBankRef));
            t.commit("Created agent tool " + newId.id);
            this.auditTrailService.generic("agent-tool-create").with("projectKey", projectKey).with("agentToolId", newId.id).emit();
            Id id = newId;
            return id;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/agent-tools/check-save-conflict"})
    public void checkSaveConflict(HttpServletRequest req, HttpServletResponse resp, @RequestParam AgentTool agentTool) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, agentTool.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AgentTool existingAgentTool = this.crudService.getMandatoryUnsafe(agentTool.projectKey, agentTool.id);
            VersionTag.ConflictCheckResult ccr = this.conflictCheckService.checkConflict(existingAgentTool.versionTag, agentTool.versionTag);
            if (!ccr.canBeSaved) {
                ccr.message = "This agent tool is being edited by more than one user.";
            }
            AgentToolsController.writeJSON((HttpServletResponse)resp, (Object)ccr);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-tools/save"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentTool save(HttpServletRequest req, HttpServletResponse resp, @RequestParam AgentTool agentTool, @RequestParam(required=false, defaultValue="{}") TaggableObjectsService.TaggableObjectSaveInfo saveInfo) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(t.getUser(), agentTool.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(t.getUser());
            this.crudService.save(t.getUser(), agentTool, saveInfo.summaryOnly);
            t.commit("Saved agentTool " + agentTool.id);
            this.auditTrailService.generic("agent-tool-save").with("projectKey", agentTool.projectKey).with("agentToolId", agentTool.id).emit();
        }
        return agentTool;
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-tools/copy"}, method={RequestMethod.POST})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentToolId) throws Exception {
        Id id;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(user);
            AgentTool agentTool = this.crudService.getMandatoryUnsafe(projectKey, agentToolId);
            id = new Id(this.crudService.copy(user, agentTool, projectKey));
            AgentToolsController.writeJSON((HttpServletResponse)resp, (Object)id);
            t.commit("Duplicated agent tool " + projectKey + "." + agentToolId + " to " + projectKey + "." + id.id);
        }
        this.auditTrailService.generic("agent-tool-duplicate").with("projectKey", projectKey).with("originalAgentToolId", agentToolId).with("newAgentToolId", id.id).emit();
    }

    @AuditedCall(value={"msgType", "agent-tools-logs-list", "projectKey", "${projectKey}", "agentToolId", "${id}"})
    @RequestMapping(value={"/api/agent-tools/list-logs"})
    public void listLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AgentToolsController.writeJSON((HttpServletResponse)resp, this.crudService.listLogs(projectKey, id));
    }

    @AuditedCall(value={"msgType", "agent-tools-log-get", "projectKey", "${projectKey}", "agentToolId", "${id}", "logName", "${logName}"})
    @RequestMapping(value={"/api/agent-tools/get-log"})
    public void getLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String logName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AgentToolsController.writeJSON((HttpServletResponse)resp, (Object)this.crudService.getLog(projectKey, id, logName));
    }

    @AuditedCall(value={"msgType", "agent-tools-log-stream", "projectKey", "${projectKey}", "agentToolId", "${id}", "logName", "${logName}"})
    @RequestMapping(value={"/api/agent-tools/stream-log"})
    public void streamLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String logName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        String dlName = DKUtils.getCompressedLogFileName((String)logName);
        resp.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", dlName));
        this.crudService.streamLog(projectKey, id, logName, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "agent-tools-log-delete", "projectKey", "${projectKey}", "agentToolId", "${id}", "logName", "${logName}"})
    @RequestMapping(value={"/api/agent-tools/delete-log"}, method={RequestMethod.POST})
    public void deleteLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String logName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.crudService.deleteLog(projectKey, id, logName);
    }

    @AuditedCall(value={"msgType", "agent-tools-logs-clear", "projectKey", "${projectKey}", "agentToolId", "${id}"})
    @RequestMapping(value={"/api/agent-tools/clear-logs"}, method={RequestMethod.POST})
    public void clearLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.crudService.clearLogs(projectKey, id);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/agent-tools/list-email-templates"})
    public void listEmailTemplates(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        TemplatesDAO templatesDAO = new TemplatesDAO();
        AgentToolsController.writeJSON((HttpServletResponse)resp, templatesDAO.list(TemplatesDAO.TemplateType.DIRECT_USAGE));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/agent-tools/get-email-template-content"})
    public void getEmailTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String templateName) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        TemplatesDAO templatesDAO = new TemplatesDAO();
        File templateFile = templatesDAO.get(templateName, TemplatesDAO.TemplateType.DIRECT_USAGE);
        String templateContent = FileUtils.readFileToString((File)templateFile, (Charset)StandardCharsets.UTF_8);
        AgentToolsController.writeJSON((HttpServletResponse)resp, (Object)new EmailTemplateContent(templateContent));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/agent-tools/can-create-local-mcp-tool"})
    @ResponseBody
    public LocalMCPToolPermission canCreateLocalMCPTool(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        LocalMCPToolPermission permission = new LocalMCPToolPermission();
        try {
            AgentTool at = new AgentTool();
            at.type = GenericStdioMCPClientTool.META.getType();
            this.crudService.checkWritePermission(user, at);
            permission.enabled = true;
        }
        catch (UnauthorizedException exc) {
            permission.enabled = false;
            permission.reason = exc.getMessage();
        }
        return permission;
    }

    public static class ProtoAgentTool {
        public String name;
        public String type;
        public String id;
        public JsonObject creationParams;
        public JsonObject quickTestQuery;
    }

    public static class EmailTemplateContent {
        public String templateContent;

        EmailTemplateContent(String content) {
            this.templateContent = content;
        }
    }

    public class LocalMCPToolPermission {
        boolean enabled;
        String reason;
    }
}

