/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token;

import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.Token;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.TokenBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ExactMatching
extends Token {
    final List<String> words;

    public ExactMatching(char letter) {
        super(4);
        this.words = Collections.singletonList(Character.toString(letter));
    }

    public ExactMatching(String word) {
        super(4);
        this.words = Collections.singletonList(word);
    }

    public ExactMatching(List<String> words) {
        super(4);
        ArrayList<String> noDuplicateString = new ArrayList<String>();
        for (String word : words) {
            if (noDuplicateString.contains(word)) continue;
            noDuplicateString.add(word);
        }
        this.words = noDuplicateString;
    }

    @Override
    public String toRegex() {
        if (this.words.size() == 1) {
            return TokenBuilder.betterEscape(this.words.get(0));
        }
        ArrayList<String> quotedWords = new ArrayList<String>();
        for (String word : this.words) {
            quotedWords.add(TokenBuilder.betterEscape(word));
        }
        Object regex = "(?:";
        regex = (String)regex + StringUtils.join(quotedWords, (String)"|");
        regex = (String)regex + ")";
        return regex;
    }

    @Override
    boolean compatible(String sentence) {
        return this.words.contains(sentence);
    }
}

