/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.visualif;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class VisualIfDesc
implements Serializable {
    public IfThen ifThen;
    public List<IfThen> elseIfThens;
    public List<Action> elseActions;
    @Nullable
    public transient VariablesContext expressionVariablesContext;

    public JsonObject selfReport() {
        JsonObject report = new JsonObject();
        if (this.ifThen != null) {
            report.add("ifThen", (JsonElement)this.ifThen.selfReport());
        }
        if (this.elseIfThens != null && !this.elseIfThens.isEmpty()) {
            JsonArray elseIfThensJson = new JsonArray();
            for (IfThen elseIfThen : this.elseIfThens) {
                if (elseIfThen == null) continue;
                elseIfThensJson.add((JsonElement)elseIfThen.selfReport());
            }
            report.add("elseIfThens", (JsonElement)elseIfThensJson);
        }
        if (this.elseActions != null && !this.elseActions.isEmpty()) {
            JsonArray elseActionsJson = new JsonArray();
            for (Action elseAction : this.elseActions) {
                if (elseAction == null) continue;
                elseActionsJson.add((JsonElement)elseAction.selfReport());
            }
            report.add("elseActions", (JsonElement)elseActionsJson);
        }
        return report;
    }

    public VisualIfDesc() {
        FilterDesc filter = new FilterDesc();
        filter.uiData = new FilterDesc.FilterUiData();
        filter.distinct = true;
        filter.enabled = true;
        this.ifThen = new IfThen(filter, new ArrayList<Action>());
        this.elseIfThens = new ArrayList<IfThen>();
        this.elseActions = new ArrayList<Action>();
    }

    public static class IfThen
    implements Serializable {
        private static Set<String> excludedFilterFields = Sets.newHashSet((Object[])new String[]{"expression", "date", "time", "date2", "time2", "col", "input", "num", "string", "value"});
        public FilterDesc filter;
        public List<Action> actions;

        public IfThen(FilterDesc filter, List<Action> actions) {
            this.filter = filter;
            this.actions = actions;
        }

        public JsonObject selfReport() {
            JsonObject report = new JsonObject();
            report.add("filter", (JsonElement)JSON.toJsonObjectExceptRecursive((Object)this.filter, excludedFilterFields));
            JsonArray actionsJson = new JsonArray();
            report.add("actions", (JsonElement)actionsJson);
            this.actions.forEach(action -> actionsJson.add((JsonElement)action.selfReport()));
            return report;
        }
    }

    public static class Action
    implements Serializable {
        public String outputColumnName;
        public ActionOperator operator;
        @Nullable
        public String value;
        @Nullable
        public String column;
        @Nullable
        public String formula;
        @Nullable
        public transient Expression expression;
        @Nullable
        public transient Column outputColumn;
        @Nullable
        public transient Column inputColumn;

        public Action(String outputColumnName, ActionOperator operator, String value, String column, String formula) {
            this.outputColumnName = outputColumnName;
            this.operator = operator;
            this.value = value;
            this.column = column;
            this.formula = formula;
        }

        public JsonObject selfReport() {
            JsonObject report = new JsonObject();
            if (this.operator != null) {
                report.addProperty("operator", this.operator.getRepr());
                if (ActionOperator.ASSIGN_FORMULA.equals((Object)this.operator)) {
                    JsonObject formulaJson = new JsonObject();
                    formulaJson.addProperty("formulaLength", (Number)StringUtils.defaultIfBlank((String)this.formula, (String)"").length());
                    report.add("formula", (JsonElement)formulaJson);
                }
            }
            return report;
        }
    }

    public static class TransformedVisualIfDesc
    implements Serializable {
        public TransformedIfThen ifThen;
        public List<TransformedIfThen> elseIfThens;
        public List<Action> elseActions;

        public TransformedVisualIfDesc(VisualIfDesc visualIfDesc) {
            this.ifThen = new TransformedIfThen(FilterDescUtils.getFilterRepr(visualIfDesc.ifThen.filter), visualIfDesc.ifThen.actions);
            this.ifThen.actions.forEach(this::trimAction);
            this.elseIfThens = new ArrayList<TransformedIfThen>();
            visualIfDesc.elseIfThens.forEach(elseIfThen -> {
                TransformedIfThen transformedIfThen = new TransformedIfThen(FilterDescUtils.getFilterRepr(elseIfThen.filter), elseIfThen.actions);
                transformedIfThen.actions.forEach(this::trimAction);
                this.elseIfThens.add(transformedIfThen);
            });
            this.elseActions = visualIfDesc.elseActions;
            this.elseActions.forEach(this::trimAction);
        }

        public void trimAction(Action action) {
            switch (action.operator) {
                case ASSIGN_COLUMN: {
                    action.value = null;
                    action.formula = null;
                    break;
                }
                case ASSIGN_FORMULA: {
                    action.value = null;
                    action.column = null;
                    break;
                }
                case ASSIGN_VALUE: {
                    action.formula = null;
                    action.column = null;
                }
            }
        }

        public static class TransformedIfThen
        implements Serializable {
            public String filterRepr;
            public List<Action> actions;

            public TransformedIfThen(String filterRepr, List<Action> actions) {
                this.filterRepr = filterRepr;
                this.actions = actions;
            }
        }
    }

    public static enum ActionOperator {
        ASSIGN_VALUE("ASSIGN_VALUE"),
        ASSIGN_COLUMN("ASSIGN_COLUMN"),
        ASSIGN_FORMULA("ASSIGN_FORMULA");

        private final String repr;

        private ActionOperator(String repr) {
            this.repr = repr;
        }

        public static ActionOperator fromRepr(String repr) throws UnsupportedOperationException {
            for (ActionOperator value : ActionOperator.values()) {
                if (!value.repr.equals(repr)) continue;
                return value;
            }
            throw new UnsupportedOperationException("Unknown operator : " + repr);
        }

        public String getRepr() {
            return this.repr;
        }
    }
}

